/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.container.jboss50;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.deployment.J2eeApplicationMetaData;
import org.jboss.deployment.J2eeModuleMetaData;
import org.jboss.metadata.WebMetaData;
import org.jboss.metadata.WebSecurityMetaData;
import org.jboss.metadata.web.Servlet;
import org.jboss.metadata.web.ServletMapping;
import org.jboss.wsf.spi.deployment.Deployment;
import org.jboss.wsf.spi.metadata.j2ee.JSEArchiveMetaData;
import org.jboss.wsf.spi.metadata.j2ee.JSESecurityMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSEArchiveMetaDataAdapter {
    public JSEArchiveMetaData buildUnifiedWebMetaData(Deployment dep, DeploymentUnit unit) {
        J2eeModuleMetaData module;
        J2eeApplicationMetaData appmd;
        String contextRoot = null;
        WebMetaData wmd = (WebMetaData)unit.getAttachment(WebMetaData.class);
        dep.addAttachment(WebMetaData.class, (Object)wmd);
        if (unit.getParent() != null && (appmd = (J2eeApplicationMetaData)unit.getParent().getAttachment(J2eeApplicationMetaData.class)) != null && (module = appmd.getModule(dep.getSimpleName())) != null) {
            contextRoot = module.getWebContext();
        }
        if (contextRoot == null) {
            contextRoot = wmd.getContextRoot();
        }
        JSEArchiveMetaData umd = new JSEArchiveMetaData();
        umd.setContextRoot(contextRoot);
        umd.setServletMappings(this.getServletMappings(wmd));
        umd.setServletClassNames(this.getServletClassMap(wmd));
        umd.setConfigName(wmd.getConfigName());
        umd.setConfigFile(wmd.getConfigFile());
        umd.setSecurityDomain(wmd.getSecurityDomain());
        umd.setPublishLocationAdapter(this.getPublishLocationAdpater(wmd));
        umd.setSecurityMetaData(this.getSecurityMetaData(wmd.getSecurityContraints()));
        return umd;
    }

    private JSEArchiveMetaData.PublishLocationAdapter getPublishLocationAdpater(final WebMetaData wmd) {
        return new JSEArchiveMetaData.PublishLocationAdapter(){

            public String getWsdlPublishLocationByName(String name) {
                return wmd.getWsdlPublishLocationByName(name);
            }
        };
    }

    protected List<JSESecurityMetaData> getSecurityMetaData(Iterator securityConstraints) {
        ArrayList<JSESecurityMetaData> unifiedsecurityMetaData = new ArrayList<JSESecurityMetaData>();
        while (securityConstraints.hasNext()) {
            WebSecurityMetaData securityMetaData = (WebSecurityMetaData)securityConstraints.next();
            JSESecurityMetaData current = new JSESecurityMetaData();
            unifiedsecurityMetaData.add(current);
            current.setTransportGuarantee(securityMetaData.getTransportGuarantee());
            Map resources = securityMetaData.getWebResources();
            for (WebSecurityMetaData.WebResourceCollection webResource : resources.values()) {
                JSESecurityMetaData.JSEResourceCollection currentResource = current.addWebResource(webResource.getName());
                for (String currentPattern : webResource.getUrlPatterns()) {
                    currentResource.addPattern(currentPattern);
                }
            }
        }
        return unifiedsecurityMetaData;
    }

    private Map<String, String> getServletMappings(WebMetaData wmd) {
        HashMap<String, String> mappings = new HashMap<String, String>();
        for (ServletMapping sm : wmd.getServletMappings()) {
            mappings.put(sm.getName(), (String)sm.getUrlPatterns().get(0));
        }
        return mappings;
    }

    private Map<String, String> getServletClassMap(WebMetaData wmd) {
        HashMap<String, String> mappings = new HashMap<String, String>();
        for (Servlet servlet : wmd.getServlets()) {
            if (servlet.getServletClass() == null || servlet.getServletClass().length() == 0) continue;
            mappings.put(servlet.getName(), servlet.getServletClass());
        }
        return mappings;
    }
}

