/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.container.jboss50;

import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
import org.jboss.metadata.WebMetaData;
import org.jboss.metadata.web.Servlet;
import org.jboss.wsf.container.jboss50.AbstractDeployerHookJSE;
import org.jboss.wsf.container.jboss50.VirtualFileAdaptor;
import org.jboss.wsf.spi.deployment.ArchiveDeployment;
import org.jboss.wsf.spi.deployment.Deployment;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.spi.deployment.Service;
import org.jboss.wsf.spi.deployment.UnifiedVirtualFile;
import org.jboss.wsf.spi.metadata.webservices.PortComponentMetaData;
import org.jboss.wsf.spi.metadata.webservices.WebserviceDescriptionMetaData;
import org.jboss.wsf.spi.metadata.webservices.WebservicesMetaData;

public class JAXRPCDeployerHookPreJSE
extends AbstractDeployerHookJSE {
    public Deployment.DeploymentType getDeploymentType() {
        return Deployment.DeploymentType.JAXRPC_JSE;
    }

    public Deployment createDeployment(DeploymentUnit unit) {
        ArchiveDeployment dep = this.newDeployment(unit);
        dep.setRootFile((UnifiedVirtualFile)new VirtualFileAdaptor(((VFSDeploymentUnit)unit).getRoot()));
        dep.setRuntimeClassLoader(null);
        dep.setType(this.getDeploymentType());
        Service service = dep.getService();
        WebMetaData webMetaData = (WebMetaData)unit.getAttachment(WebMetaData.class);
        if (webMetaData == null) {
            throw new IllegalStateException("Deployment unit does not contain web meta data");
        }
        WebservicesMetaData wsMetaData = this.getWebservicesMetaData(unit);
        if (wsMetaData == null) {
            throw new IllegalStateException("Deployment unit does not contain webservices meta data");
        }
        dep.addAttachment(WebservicesMetaData.class, (Object)wsMetaData);
        dep.addAttachment(WebMetaData.class, (Object)webMetaData);
        for (WebserviceDescriptionMetaData wsd : wsMetaData.getWebserviceDescriptions()) {
            for (PortComponentMetaData pcmd : wsd.getPortComponents()) {
                String servletLink = pcmd.getServletLink();
                if (servletLink == null) {
                    throw new IllegalStateException("servlet-link cannot be null");
                }
                Servlet servlet = this.getServletForName(webMetaData, servletLink);
                String servletClass = servlet.getServletClass();
                Endpoint ep = this.newEndpoint(servletClass);
                ep.setShortName(servletLink);
                service.addEndpoint(ep);
            }
        }
        return dep;
    }

    private Servlet getServletForName(WebMetaData wmd, String servletLink) {
        for (Servlet servlet : wmd.getServlets()) {
            if (!servletLink.equals(servlet.getName())) continue;
            return servlet;
        }
        throw new IllegalStateException("Cannot find servlet for link: " + servletLink);
    }

    public boolean isWebServiceDeployment(DeploymentUnit unit) {
        if (!super.isWebServiceDeployment(unit)) {
            return false;
        }
        WebservicesMetaData wsMetaData = this.getWebservicesMetaData(unit);
        return wsMetaData != null;
    }
}

