/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.container.jboss50;

import javax.xml.ws.Endpoint;
import javax.xml.ws.WebServiceException;
import org.jboss.wsf.spi.SPIProvider;
import org.jboss.wsf.spi.SPIProviderResolver;
import org.jboss.wsf.spi.deployment.AbstractExtensible;
import org.jboss.wsf.spi.deployment.Deployment;
import org.jboss.wsf.spi.deployment.DeploymentAspectManager;
import org.jboss.wsf.spi.deployment.DeploymentAspectManagerFactory;
import org.jboss.wsf.spi.deployment.DeploymentModelFactory;
import org.jboss.wsf.spi.deployment.Service;
import org.jboss.wsf.spi.http.HttpContext;
import org.jboss.wsf.spi.http.HttpContextFactory;
import org.jboss.wsf.spi.http.HttpServer;

public class DeploymentAspectHttpServer
extends AbstractExtensible
implements HttpServer {
    public void start() {
    }

    public HttpContext createContext(String contextRoot) {
        SPIProvider spiProvider = SPIProviderResolver.getInstance().getProvider();
        HttpContext httpContext = ((HttpContextFactory)spiProvider.getSPI(HttpContextFactory.class)).newHttpContext((HttpServer)this, contextRoot);
        return httpContext;
    }

    public void publish(HttpContext context, Endpoint endpoint) {
        Class implClass = this.getImplementorClass(endpoint);
        try {
            SPIProvider spiProvider = SPIProviderResolver.getInstance().getProvider();
            DeploymentModelFactory depModelFactory = (DeploymentModelFactory)spiProvider.getSPI(DeploymentModelFactory.class);
            Deployment dep = depModelFactory.newDeployment("endpoint-deployment", implClass.getClassLoader());
            dep.setRuntimeClassLoader(dep.getInitialClassLoader());
            Service service = dep.getService();
            service.setContextRoot(context.getContextRoot());
            org.jboss.wsf.spi.deployment.Endpoint ep = depModelFactory.newEndpoint(implClass.getName());
            service.addEndpoint(ep);
            DeploymentAspectManagerFactory depManagerFactory = (DeploymentAspectManagerFactory)spiProvider.getSPI(DeploymentAspectManagerFactory.class);
            DeploymentAspectManager depManager = depManagerFactory.getDeploymentAspectManager("WSDeploymentAspectManagerEndpointAPI");
            depManager.deploy(dep);
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (Exception ex) {
            throw new WebServiceException((Throwable)ex);
        }
    }

    public void destroy(HttpContext context, Endpoint endpoint) {
    }

    private Class getImplementorClass(Endpoint endpoint) {
        Object implementor = endpoint.getImplementor();
        Class<?> implClass = implementor instanceof Class ? (Class<?>)implementor : implementor.getClass();
        return implClass;
    }
}

