/*
  * JBoss, Home of Professional Open Source
  * Copyright 2005, JBoss Inc., and individual contributors as indicated
  * by the @authors tag. See the copyright.txt in the distribution for a
  * full listing of individual contributors.
  *
  * This is free software; you can redistribute it and/or modify it
  * under the terms of the GNU Lesser General Public License as
  * published by the Free Software Foundation; either version 2.1 of
  * the License, or (at your option) any later version.
  *
  * This software is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  * Lesser General Public License for more details.
  *
  * You should have received a copy of the GNU Lesser General Public
  * License along with this software; if not, write to the Free
  * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
  * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
  */
package org.jboss.security;

//$Id: SecurityRoleRef.java 46491 2006-07-25 17:09:06Z asaldhana $

/**
 *  Represents a Security Role Ref element in the deployment descriptor
 *  @author <a href="mailto:Anil.Saldhana@jboss.org">Anil Saldhana</a>
 *  @since  Jul 21, 2006 
 *  @version $Revision: 46491 $
 */
public class SecurityRoleRef
{
   private String name;
   private String link;
   private String description;
   
   public SecurityRoleRef(String name, String link, String description)
   {
      this.name = name;
      this.link = link;
      this.description = description;
   }

   /**
    * Get the description.
    * 
    * @return the description.
    */
   public String getDescription()
   {
      return description;
   }

   /**
    * Get the link.
    * 
    * @return the link.
    */
   public String getLink()
   {
      return link;
   }

   /**
    * Get the name.
    * 
    * @return the name.
    */
   public String getName()
   {
      return name;
   }  
}
