/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.debug.hot;

import java.io.File;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.jboss.seam.InterceptionType;
import org.jboss.seam.ScopeType;
import org.jboss.seam.Seam;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Intercept;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.Startup;
import org.jboss.seam.core.Exceptions;
import org.jboss.seam.core.Init;
import org.jboss.seam.core.Pages;
import org.jboss.seam.init.Initialization;
import org.jboss.seam.log.LogProvider;
import org.jboss.seam.log.Logging;
import org.jboss.seam.web.AbstractFilter;

@Name(value="org.jboss.seam.debug.hotDeployFilter")
@Startup
@Install(debug=true, precedence=0)
@Intercept(value=InterceptionType.NEVER)
@Scope(value=ScopeType.APPLICATION)
public class HotDeployFilter
extends AbstractFilter {
    private static LogProvider log = Logging.getLogProvider(HotDeployFilter.class);

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        Init init = (Init)this.getServletContext().getAttribute(Seam.getComponentName(Init.class));
        if (init != null && init.hasHotDeployableComponents()) {
            for (File file : init.getHotDeployPaths()) {
                if (!this.scan(request, init, file)) continue;
                new Initialization(this.getServletContext()).redeploy(((HttpServletRequest)request).getSession(true));
                break;
            }
        }
        this.getServletContext().removeAttribute(Seam.getComponentName(Pages.class));
        this.getServletContext().removeAttribute(Seam.getComponentName(Exceptions.class));
        chain.doFilter(request, response);
    }

    private boolean scan(ServletRequest request, Init init, File file) {
        if (file.isFile()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("file updated: " + file.getName()));
            }
            if (file.lastModified() > init.getTimestamp()) {
                return true;
            }
        } else if (file.isDirectory()) {
            for (File f : file.listFiles()) {
                if (!this.scan(request, init, f)) continue;
                return true;
            }
        }
        return false;
    }
}

