/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging.jdk.xml;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.Hashtable;
import java.util.Properties;
import java.util.logging.ErrorManager;
import java.util.logging.Filter;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import org.jboss.logging.jdk.handlers.HandlerSkeleton;
import org.jboss.util.StringPropertyReplacer;
import org.jboss.util.propertyeditor.PropertyEditors;
import org.jboss.util.xml.JBossEntityResolver;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DOMConfigurator {
    static final String CONFIGURATION_TAG = "jdk:configuration";
    static final String OLD_CONFIGURATION_TAG = "configuration";
    static final String RENDERER_TAG = "renderer";
    static final String APPENDER_TAG = "appender";
    static final String APPENDER_REF_TAG = "appender-ref";
    static final String PARAM_TAG = "param";
    static final String LAYOUT_TAG = "layout";
    static final String CATEGORY = "category";
    static final String LOGGER = "logger";
    static final String LOGGER_REF = "logger-ref";
    static final String CATEGORY_FACTORY_TAG = "categoryFactory";
    static final String NAME_ATTR = "name";
    static final String CLASS_ATTR = "class";
    static final String VALUE_ATTR = "value";
    static final String ROOT_TAG = "root";
    static final String ROOT_REF = "root-ref";
    static final String LEVEL_TAG = "level";
    static final String PRIORITY_TAG = "priority";
    static final String FILTER_TAG = "filter";
    static final String ERROR_HANDLER_TAG = "errorHandler";
    static final String REF_ATTR = "ref";
    static final String ADDITIVITY_ATTR = "additivity";
    static final String THRESHOLD_ATTR = "threshold";
    static final String CONFIG_DEBUG_ATTR = "configDebug";
    static final String INTERNAL_DEBUG_ATTR = "debug";
    static final String RENDERING_CLASS_ATTR = "renderingClass";
    static final String RENDERED_CLASS_ATTR = "renderedClass";
    static final String EMPTY_STR = "";
    static final Class[] ONE_STRING_PARAM = new Class[]{String.class};
    static final String dbfKey = "javax.xml.parsers.DocumentBuilderFactory";
    private Hashtable appenderBag = new Hashtable();
    private ErrorManager errorLog;
    private Properties props;
    private LogManager repository;
    private boolean debug;

    public static void configure(Element element) {
        DOMConfigurator configurator = new DOMConfigurator();
        configurator.doConfigure(element, LogManager.getLogManager());
    }

    public static void configure(String filename) throws FactoryConfigurationError {
        new DOMConfigurator().doConfigure(filename, LogManager.getLogManager());
    }

    public static void configure(URL url) throws FactoryConfigurationError {
        new DOMConfigurator().doConfigure(url, LogManager.getLogManager());
    }

    public static void configure(InputStream is) throws FactoryConfigurationError {
        new DOMConfigurator().doConfigure(is, LogManager.getLogManager());
    }

    public DOMConfigurator() {
        this(new ErrorManager());
    }

    public DOMConfigurator(ErrorManager errorLog) {
        this.errorLog = errorLog;
    }

    protected Handler findHandlerByName(Document doc, String appenderName) {
        Handler appender = (Handler)this.appenderBag.get(appenderName);
        if (appender != null) {
            return appender;
        }
        Element element = doc.getElementById(appenderName);
        if (element == null) {
            this.errorLog.error("No appender named [" + appenderName + "] could be found.", null, 0);
            return null;
        }
        appender = this.parseHandler(element);
        this.appenderBag.put(appenderName, appender);
        return appender;
    }

    protected Handler findHandlerByReference(Element appenderRef) {
        String appenderName = this.subst(appenderRef.getAttribute(REF_ATTR));
        Document doc = appenderRef.getOwnerDocument();
        return this.findHandlerByName(doc, appenderName);
    }

    protected Handler parseHandler(Element appenderElement) {
        String className = this.subst(appenderElement.getAttribute(CLASS_ATTR));
        this.debug("Class name: [" + className + ']');
        try {
            Object instance = this.instantiateByClassName(className, Handler.class, null);
            Handler appender = (Handler)instance;
            Properties beanProps = new Properties();
            String name = this.subst(appenderElement.getAttribute(NAME_ATTR));
            HandlerSkeleton handlerSkeleton = null;
            if (appender instanceof HandlerSkeleton) {
                handlerSkeleton = (HandlerSkeleton)appender;
                handlerSkeleton.setName(name);
            }
            NodeList children = appenderElement.getChildNodes();
            int length = children.getLength();
            for (int loop = 0; loop < length; ++loop) {
                Node currentNode = children.item(loop);
                if (currentNode.getNodeType() != 1) continue;
                Element currentElement = (Element)currentNode;
                if (currentElement.getTagName().equals(PARAM_TAG)) {
                    this.setParameter(currentElement, beanProps);
                    continue;
                }
                if (currentElement.getTagName().equals(LAYOUT_TAG)) {
                    Formatter format = this.parseLayout(currentElement);
                    appender.setFormatter(format);
                    continue;
                }
                if (currentElement.getTagName().equals(FILTER_TAG)) {
                    this.parseFilters(currentElement, appender);
                    continue;
                }
                if (currentElement.getTagName().equals(ERROR_HANDLER_TAG)) {
                    this.parseErrorManager(currentElement, appender);
                    continue;
                }
                if (!currentElement.getTagName().equals(APPENDER_REF_TAG)) continue;
                String refName = this.subst(currentElement.getAttribute(REF_ATTR));
                this.errorLog.error("Requesting attachment of handler named [" + refName + "] to handler named [" + appender + "] which does not implement org.apache.jdk.spi.HandlerAttachable.", null, 0);
            }
            PropertyEditors.mapJavaBeanProperties((Object)appender, (Properties)beanProps);
            if (handlerSkeleton != null) {
                handlerSkeleton.activateOptions();
            }
            return appender;
        }
        catch (Exception oops) {
            this.errorLog.error("Could not create an Handler. Reported error follows.", oops, 0);
            return null;
        }
    }

    protected void parseErrorManager(Element element, Handler appender) throws Exception {
        String className = this.subst(element.getAttribute(CLASS_ATTR));
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        Class<?> ehClazz = loader.loadClass(className);
        ErrorManager eh = (ErrorManager)ehClazz.newInstance();
        appender.setErrorManager(eh);
    }

    protected void parseFilters(Element element, Handler appender) throws Exception {
        String clazz = this.subst(element.getAttribute(CLASS_ATTR));
        Filter filter = (Filter)this.instantiateByClassName(clazz, Filter.class, null);
        if (filter != null) {
            Properties beanProps = new Properties();
            NodeList children = element.getChildNodes();
            int length = children.getLength();
            for (int loop = 0; loop < length; ++loop) {
                Element currentElement;
                String tagName;
                Node currentNode = children.item(loop);
                if (currentNode.getNodeType() != 1 || !(tagName = (currentElement = (Element)currentNode).getTagName()).equals(PARAM_TAG)) continue;
                this.setParameter(currentElement, beanProps);
            }
            PropertyEditors.mapJavaBeanProperties((Object)filter, (Properties)beanProps);
            this.debug("Setting filter of type [" + filter.getClass() + "] to appender named [" + appender + "].");
            appender.setFilter(filter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void parseCategory(Element loggerElement) throws Exception {
        Logger logger;
        String catName = this.subst(loggerElement.getAttribute(NAME_ATTR));
        String className = this.subst(loggerElement.getAttribute(CLASS_ATTR));
        if (EMPTY_STR.equals(className)) {
            this.debug("Retreiving an instance of java.util.logging.Logger.");
            logger = this.repository.getLogger(catName);
            if (logger == null) {
                logger = Logger.getLogger(catName);
                this.repository.addLogger(logger);
            }
        } else {
            this.debug("Desired logger sub-class: [" + className + ']');
            try {
                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                Class<?> c = loader.loadClass(className);
                Class[] sig = new Class[]{String.class, String.class};
                Constructor<?> ctor = c.getConstructor(sig);
                Object[] args = new Object[]{catName, null};
                logger = (Logger)ctor.newInstance(args);
            }
            catch (Exception oops) {
                this.errorLog.error("Could not retrieve category [" + catName + "]. Reported error follows.", oops, 0);
                return;
            }
        }
        Logger logger2 = logger;
        synchronized (logger2) {
            String flag = this.subst(loggerElement.getAttribute(ADDITIVITY_ATTR));
            boolean additivity = Boolean.valueOf(flag);
            this.debug("Setting [" + logger.getName() + "] additivity to [" + additivity + "].");
            logger.setUseParentHandlers(additivity);
            this.parseChildrenOfLoggerElement(loggerElement, logger, false);
        }
    }

    protected void parseCategoryFactory(Element factoryElement) throws Exception {
        String className = this.subst(factoryElement.getAttribute(CLASS_ATTR));
        if (EMPTY_STR.equals(className)) {
            this.errorLog.error("Category Factory tag class attribute not found.", null, 0);
        } else {
            this.debug("Desired category factory: [" + className + ']');
            Object catFactory = this.instantiateByClassName(className, Object.class, null);
            Properties beanProps = new Properties();
            Element currentElement = null;
            Node currentNode = null;
            NodeList children = factoryElement.getChildNodes();
            int length = children.getLength();
            for (int loop = 0; loop < length; ++loop) {
                currentNode = children.item(loop);
                if (currentNode.getNodeType() != 1 || !(currentElement = (Element)currentNode).getTagName().equals(PARAM_TAG)) continue;
                this.setParameter(currentElement, beanProps);
            }
            PropertyEditors.mapJavaBeanProperties((Object)catFactory, (Properties)beanProps);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void parseRoot(Element rootElement) throws Exception {
        Logger root = this.repository.getLogger(EMPTY_STR);
        if (root == null) {
            root = Logger.getLogger(EMPTY_STR);
            this.repository.addLogger(root);
        }
        Logger logger = root;
        synchronized (logger) {
            this.parseChildrenOfLoggerElement(rootElement, root, true);
        }
    }

    protected void parseChildrenOfLoggerElement(Element catElement, Logger logger, boolean isRoot) throws Exception {
        Properties beanProps = new Properties();
        Handler[] handlers = logger.getHandlers();
        for (int n = 0; n < handlers.length; ++n) {
            Handler h = handlers[n];
            logger.removeHandler(h);
        }
        NodeList children = catElement.getChildNodes();
        int length = children.getLength();
        for (int loop = 0; loop < length; ++loop) {
            Node currentNode = children.item(loop);
            if (currentNode.getNodeType() != 1) continue;
            Element currentElement = (Element)currentNode;
            String tagName = currentElement.getTagName();
            if (tagName.equals(APPENDER_REF_TAG)) {
                Element appenderRef = (Element)currentNode;
                Handler appender = this.findHandlerByReference(appenderRef);
                String refName = this.subst(appenderRef.getAttribute(REF_ATTR));
                if (appender != null) {
                    this.debug("Adding appender named [" + refName + "] to category [" + logger.getName() + "].");
                } else {
                    this.debug("Handler named [" + refName + "] not found.");
                }
                logger.addHandler(appender);
                continue;
            }
            if (tagName.equals(LEVEL_TAG)) {
                this.parseLevel(currentElement, logger, isRoot);
                continue;
            }
            if (tagName.equals(PRIORITY_TAG)) {
                this.parseLevel(currentElement, logger, isRoot);
                continue;
            }
            if (!tagName.equals(PARAM_TAG)) continue;
            this.setParameter(currentElement, beanProps);
        }
        PropertyEditors.mapJavaBeanProperties((Object)logger, (Properties)beanProps);
    }

    protected Formatter parseLayout(Element layout_element) {
        String className = this.subst(layout_element.getAttribute(CLASS_ATTR));
        this.debug("Parsing layout of class: \"" + className + "\"");
        try {
            Object instance = this.instantiateByClassName(className, Formatter.class, null);
            Formatter layout = (Formatter)instance;
            Properties beanProps = new Properties();
            NodeList params = layout_element.getChildNodes();
            int length = params.getLength();
            for (int loop = 0; loop < length; ++loop) {
                Element currentElement;
                String tagName;
                Node currentNode = params.item(loop);
                if (currentNode.getNodeType() != 1 || !(tagName = (currentElement = (Element)currentNode).getTagName()).equals(PARAM_TAG)) continue;
                this.setParameter(currentElement, beanProps);
            }
            PropertyEditors.mapJavaBeanProperties((Object)layout, (Properties)beanProps);
            return layout;
        }
        catch (Exception oops) {
            this.errorLog.error("Could not create the Layout. Reported error follows.", oops, 0);
            return null;
        }
    }

    protected void parseRenderer(Element element) {
        String renderingClass = this.subst(element.getAttribute(RENDERING_CLASS_ATTR));
        String renderedClass = this.subst(element.getAttribute(RENDERED_CLASS_ATTR));
    }

    protected void parseLevel(Element element, Logger logger, boolean isRoot) {
        String catName = logger.getName();
        if (isRoot) {
            catName = ROOT_TAG;
        }
        String levelName = this.subst(element.getAttribute(VALUE_ATTR));
        levelName = DOMConfigurator.mapLog4jLevel(levelName);
        this.debug("Level value for " + catName + " is  [" + levelName + "].");
        if ("INHERITED".equalsIgnoreCase(levelName) || "NULL".equalsIgnoreCase(levelName)) {
            if (isRoot) {
                this.errorLog.error("Root level cannot be inherited. Ignoring directive.", null, 0);
            } else {
                logger.setLevel(null);
            }
        } else {
            String className = this.subst(element.getAttribute(CLASS_ATTR));
            if (EMPTY_STR.equals(className)) {
                Level level = Level.parse(levelName);
                logger.setLevel(level);
            } else if (className.equals("org.jboss.logging.XLevel")) {
                logger.setLevel(Level.FINER);
            } else {
                this.debug("Desired Level sub-class: [" + className + ']');
                try {
                    ClassLoader loader = Thread.currentThread().getContextClassLoader();
                    Class<?> clazz = loader.loadClass(className);
                    Class[] sig = new Class[]{String.class, Integer.TYPE};
                    Object[] args = new Object[]{levelName, new Integer(Level.FINEST.intValue())};
                    Constructor<?> ctor = clazz.getConstructor(sig);
                    Level pri = (Level)ctor.newInstance(args);
                    logger.setLevel(pri);
                }
                catch (Exception oops) {
                    this.errorLog.error("Could not create level [" + levelName + "]. Reported error follows.", oops, 0);
                    return;
                }
            }
        }
        this.debug(catName + " level set to " + logger.getLevel());
    }

    protected void setParameter(Element elem, Properties beanProps) {
        String name = this.subst(elem.getAttribute(NAME_ATTR));
        String value = elem.getAttribute(VALUE_ATTR);
        value = this.subst(DOMConfigurator.convertSpecialChars(value));
        beanProps.setProperty(name, value);
    }

    public void doConfigure(final String filename, LogManager repository) {
        ParseAction action = new ParseAction(){

            public Document parse(DocumentBuilder parser) throws SAXException, IOException {
                return parser.parse(new File(filename));
            }

            public String toString() {
                return "file [" + filename + "]";
            }
        };
        this.doConfigure(action, repository);
    }

    public void doConfigure(final URL url, LogManager repository) {
        ParseAction action = new ParseAction(){

            public Document parse(DocumentBuilder parser) throws SAXException, IOException {
                return parser.parse(url.toString());
            }

            public String toString() {
                return "url [" + url.toString() + "]";
            }
        };
        this.doConfigure(action, repository);
    }

    public void doConfigure(final InputStream inputStream, LogManager repository) throws FactoryConfigurationError {
        ParseAction action = new ParseAction(){

            public Document parse(DocumentBuilder parser) throws SAXException, IOException {
                InputSource inputSource = new InputSource(inputStream);
                inputSource.setSystemId("dummy://jdk.dtd");
                return parser.parse(inputSource);
            }

            public String toString() {
                return "input stream [" + inputStream.toString() + "]";
            }
        };
        this.doConfigure(action, repository);
    }

    public void doConfigure(final Reader reader, LogManager repository) throws FactoryConfigurationError {
        ParseAction action = new ParseAction(){

            public Document parse(DocumentBuilder parser) throws SAXException, IOException {
                InputSource inputSource = new InputSource(reader);
                inputSource.setSystemId("dummy://jdk.dtd");
                return parser.parse(inputSource);
            }

            public String toString() {
                return "reader [" + reader.toString() + "]";
            }
        };
        this.doConfigure(action, repository);
    }

    protected void doConfigure(final InputSource inputSource, LogManager repository) throws FactoryConfigurationError {
        if (inputSource.getSystemId() == null) {
            inputSource.setSystemId("dummy://jdk.dtd");
        }
        ParseAction action = new ParseAction(){

            public Document parse(DocumentBuilder parser) throws SAXException, IOException {
                return parser.parse(inputSource);
            }

            public String toString() {
                return "input source [" + inputSource.toString() + "]";
            }
        };
        this.doConfigure(action, repository);
    }

    private final void doConfigure(ParseAction action, LogManager repository) throws FactoryConfigurationError {
        DocumentBuilderFactory dbf = null;
        this.repository = repository;
        try {
            dbf = DocumentBuilderFactory.newInstance();
            this.debug("Standard DocumentBuilderFactory search succeded.");
            this.debug("DocumentBuilderFactory is: " + dbf.getClass().getName());
        }
        catch (FactoryConfigurationError fce) {
            Exception e = fce.getException();
            this.errorLog.error("Could not instantiate a DocumentBuilderFactory.", e, 0);
            throw fce;
        }
        try {
            dbf.setValidating(true);
            DocumentBuilder docBuilder = dbf.newDocumentBuilder();
            JBossEntityResolver resolver = new JBossEntityResolver();
            resolver.registerLocalEntity("urn:jboss:jdklogger.dtd", "jdklogger.dtd");
            docBuilder.setEntityResolver((EntityResolver)resolver);
            Document doc = action.parse(docBuilder);
            this.parse(doc.getDocumentElement());
        }
        catch (Exception e) {
            this.errorLog.error("Could not parse " + action.toString() + ".", e, 0);
        }
    }

    public void doConfigure(Element element, LogManager repository) {
        this.repository = repository;
        this.parse(element);
    }

    protected void parse(Element element) {
        int loop;
        String rootElementName = element.getTagName();
        if (!rootElementName.equals(CONFIGURATION_TAG)) {
            if (rootElementName.equals(OLD_CONFIGURATION_TAG)) {
                this.errorLog.error("The <configuration> element has been deprecated., use the <jdk:configuration> element instead.", null, 0);
            } else {
                this.errorLog.error("DOM element is - not a <jdk:configuration> element.", null, 0);
                return;
            }
        }
        String debugAttrib = this.subst(element.getAttribute(INTERNAL_DEBUG_ATTR));
        this.debug("debug attribute= '" + debugAttrib + "'.");
        if (!debugAttrib.equals(EMPTY_STR) && !debugAttrib.equals("null")) {
            this.debug = Boolean.valueOf(debugAttrib);
        } else {
            this.debug("Ignoring debug attribute.");
        }
        String confDebug = this.subst(element.getAttribute(CONFIG_DEBUG_ATTR));
        if (!confDebug.equals(EMPTY_STR) && !confDebug.equals("null")) {
            this.debug = true;
        }
        String thresholdStr = this.subst(element.getAttribute(THRESHOLD_ATTR));
        this.debug("Threshold ='" + thresholdStr + "'.");
        if (!EMPTY_STR.equals(thresholdStr) && !"null".equals(thresholdStr)) {
            Level threshold = Level.parse(thresholdStr);
            Logger root = this.repository.getLogger(EMPTY_STR);
            root.setLevel(threshold);
        }
        String tagName = null;
        Element currentElement = null;
        Node currentNode = null;
        NodeList children = element.getChildNodes();
        int length = children.getLength();
        for (loop = 0; loop < length; ++loop) {
            currentNode = children.item(loop);
            if (currentNode.getNodeType() != 1 || !(tagName = (currentElement = (Element)currentNode).getTagName()).equals(CATEGORY_FACTORY_TAG)) continue;
            try {
                this.parseCategoryFactory(currentElement);
                continue;
            }
            catch (Exception e) {
                this.errorLog.error("Failed to parse: " + tagName, e, 0);
            }
        }
        for (loop = 0; loop < length; ++loop) {
            currentNode = children.item(loop);
            if (currentNode.getNodeType() != 1) continue;
            currentElement = (Element)currentNode;
            tagName = currentElement.getTagName();
            try {
                if (tagName.equals(CATEGORY) || tagName.equals(LOGGER)) {
                    this.parseCategory(currentElement);
                    continue;
                }
                if (tagName.equals(ROOT_TAG)) {
                    this.parseRoot(currentElement);
                    continue;
                }
                if (!tagName.equals(RENDERER_TAG)) continue;
                this.parseRenderer(currentElement);
                continue;
            }
            catch (Exception e) {
                this.errorLog.error("Failed to parse element: " + tagName, e, 0);
            }
        }
    }

    protected String subst(String value) {
        if (value == null) {
            return null;
        }
        try {
            return StringPropertyReplacer.replaceProperties((String)value);
        }
        catch (Exception e) {
            this.errorLog.error("Could not perform variable substitution.", e, 0);
            return value;
        }
    }

    static String mapLog4jLevel(String name) {
        String jdkName = null;
        if (name.equals("OFF")) {
            jdkName = Level.OFF.getName();
        } else if (name.equals("FATAL")) {
            jdkName = Level.SEVERE.getName();
        } else if (name.equals("ERROR")) {
            jdkName = Level.WARNING.getName();
        } else if (name.equals("ERROR")) {
            jdkName = Level.WARNING.getName();
        } else if (name.equals("WARN")) {
            jdkName = Level.WARNING.getName();
        } else if (name.equals("INFO")) {
            jdkName = Level.INFO.getName();
        } else if (name.equals("DEBUG")) {
            jdkName = Level.FINE.getName();
        } else if (name.equals("TRACE")) {
            jdkName = Level.FINER.getName();
        }
        return jdkName;
    }

    static String convertSpecialChars(String s) {
        int len = s.length();
        StringBuffer sbuf = new StringBuffer(len);
        int i = 0;
        while (i < len) {
            int c;
            if ((c = s.charAt(i++)) == 92) {
                if ((c = s.charAt(i++)) == 110) {
                    c = 10;
                } else if (c == 114) {
                    c = 13;
                } else if (c == 116) {
                    c = 9;
                } else if (c == 102) {
                    c = 12;
                } else if (c == 8) {
                    c = 8;
                } else if (c == 34) {
                    c = 34;
                } else if (c == 39) {
                    c = 39;
                } else if (c == 92) {
                    c = 92;
                }
            }
            sbuf.append((char)c);
        }
        return sbuf.toString();
    }

    protected void debug(String msg) {
        if (this.debug) {
            System.out.println(msg);
        }
    }

    Object instantiateByClassName(String className, Class superClass, Object defaultValue) {
        if (className != null) {
            try {
                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                Class<?> classObj = loader.loadClass(className);
                if (!superClass.isAssignableFrom(classObj)) {
                    this.errorLog.error("A \"" + className + "\" object is not assignable to a \"" + superClass.getName() + "\" variable." + "The class \"" + superClass.getName() + "\" was loaded by " + "[" + superClass.getClassLoader() + "] whereas object of type " + "'" + classObj.getName() + "\" was loaded by [" + classObj.getClassLoader() + "].", null, 0);
                    return defaultValue;
                }
                return classObj.newInstance();
            }
            catch (Exception e) {
                this.errorLog.error("Could not instantiate class [" + className + "].", e, 0);
            }
        }
        return defaultValue;
    }

    private static interface ParseAction {
        public Document parse(DocumentBuilder var1) throws SAXException, IOException;
    }
}

