/*
 * Decompiled with CFR 0.152.
 */
package javax.security.auth;

import java.security.Permission;
import java.security.PermissionCollection;

public class PrivateCredentialPermission
extends Permission {
    private String credentialClassName;
    private String principalClass;
    private String principalName;

    public PrivateCredentialPermission(String name, String actions) {
        super(name);
        if (actions == null || !actions.equalsIgnoreCase("read")) {
            throw new IllegalArgumentException("The only supported action is 'read'");
        }
        int space = name.indexOf(32);
        if (space > 0) {
            name = name.substring(0, space);
        }
        this.credentialClassName = name;
        this.principalClass = "*";
        this.principalName = "*";
    }

    public boolean equals(Object obj) {
        boolean equals = false;
        if (obj instanceof PrivateCredentialPermission) {
            PrivateCredentialPermission pcp = (PrivateCredentialPermission)obj;
            equals = this.credentialClassName.equals(pcp.credentialClassName);
        }
        return equals;
    }

    public int hashCode() {
        return this.credentialClassName.hashCode();
    }

    public String getActions() {
        return "read";
    }

    public String getCredentialClass() {
        return this.credentialClassName;
    }

    public String[][] getPrincipals() {
        String[][] principals = new String[][]{{"*", "*"}};
        return principals;
    }

    public boolean implies(Permission p) {
        if (!(p instanceof PrivateCredentialPermission)) {
            return false;
        }
        PrivateCredentialPermission pcp = (PrivateCredentialPermission)p;
        boolean implies = this.credentialClassName.equals("*");
        if (!implies) {
            implies = this.credentialClassName.equals(pcp.credentialClassName);
        }
        return implies;
    }

    public PermissionCollection newPermissionCollection() {
        return null;
    }
}

