/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.virtual.plugins.context.jar;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.virtual.plugins.context.AbstractURLHandler;
import org.jboss.virtual.plugins.context.StructuredVirtualFileHandler;
import org.jboss.virtual.spi.VFSContext;
import org.jboss.virtual.spi.VirtualFileHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SynthenticDirEntryHandler
extends AbstractURLHandler
implements StructuredVirtualFileHandler {
    private static final long serialVersionUID = 1L;
    private long lastModified;
    private transient List<VirtualFileHandler> entryChildren;
    private transient Map<String, VirtualFileHandler> entryMap;

    public SynthenticDirEntryHandler(VFSContext context, VirtualFileHandler parent, String entryName, long lastModified, URL url) throws IOException {
        super(context, parent, url, entryName);
        this.lastModified = lastModified;
    }

    public void addChild(VirtualFileHandler child) {
        if (this.entryChildren == null) {
            this.entryChildren = new ArrayList<VirtualFileHandler>();
        }
        this.entryChildren.add(child);
    }

    @Override
    public long getLastModified() {
        return this.lastModified;
    }

    @Override
    public long getSize() {
        return 0L;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public boolean isHidden() {
        this.checkClosed();
        return false;
    }

    @Override
    public InputStream openStream() throws IOException {
        throw new IOException("Directories cannot be opened");
    }

    @Override
    public List<VirtualFileHandler> getChildren(boolean ignoreErrors) throws IOException {
        this.checkClosed();
        List<VirtualFileHandler> children = this.entryChildren;
        if (this.entryChildren == null) {
            children = Collections.emptyList();
        }
        return children;
    }

    @Override
    public VirtualFileHandler findChild(String path) throws IOException {
        return super.structuredFindChild(path);
    }

    @Override
    public VirtualFileHandler createChildHandler(String name) throws IOException {
        VirtualFileHandler child;
        if (this.entryChildren == null) {
            throw new FileNotFoundException(this + " has no children");
        }
        if (this.entryMap == null) {
            this.entryMap = new HashMap<String, VirtualFileHandler>();
            for (VirtualFileHandler child2 : this.entryChildren) {
                this.entryMap.put(child2.getName(), child2);
            }
        }
        if ((child = this.entryMap.get(name)) == null) {
            throw new FileNotFoundException(this + " has no child: " + name);
        }
        return child;
    }
}

