/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.virtual.plugins.context.jar;

import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import org.jboss.virtual.plugins.context.jar.AbstractJarHandler;
import org.jboss.virtual.spi.VFSContext;
import org.jboss.virtual.spi.VirtualFileHandler;

public class JarHandler
extends AbstractJarHandler {
    private static final long serialVersionUID = 1L;

    public JarHandler(VFSContext context, VirtualFileHandler parent, URL url, String name) throws IOException {
        super(context, parent, url, name);
        try {
            JarURLConnection connection = (JarURLConnection)url.openConnection();
            this.initJarFile(connection.getJarFile());
        }
        catch (IOException original) {
            IOException e = new IOException("Error opening jar file: " + url + " reason=" + original.getMessage());
            e.setStackTrace(original.getStackTrace());
            throw e;
        }
    }

    public InputStream openStream() throws IOException {
        this.checkClosed();
        String jarURL = this.getURL().toString();
        String underlyingURL = jarURL.substring(4, jarURL.length() - 2);
        URL realURL = new URL(underlyingURL);
        InputStream is = realURL.openStream();
        return is;
    }
}

