/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.virtual.classloading;

import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import org.jboss.logging.Logger;
import org.jboss.virtual.VFS;
import org.jboss.virtual.classloading.SecurityActions;
import org.jboss.virtual.classloading.VFSClassLoader;

public class VFSClassLoaderFactory {
    private static Logger log = Logger.getLogger(VFSClassLoaderFactory.class);

    public static VFSClassLoader newClassLoader(URI rootURI, String[] paths) throws IOException {
        log.debug((Object)("newClassLoader, rootURI=" + rootURI + ", paths=" + Arrays.asList(paths)));
        VFS vfs = VFS.getVFS(rootURI);
        return SecurityActions.newClassLoader(paths, vfs);
    }

    public static VFSClassLoader newClassLoader(String[] paths, VFS vfs) {
        log.debug((Object)("newClassLoader, vfs=" + vfs + ", paths=" + Arrays.asList(paths)));
        return SecurityActions.newClassLoader(paths, vfs);
    }

    public static VFSClassLoader newClassLoader(String[] paths, VFS vfs, ClassLoader parent) {
        log.debug((Object)("newClassLoader, vfs" + vfs + ", paths=" + Arrays.asList(paths) + ", parent=" + parent));
        return SecurityActions.newClassLoader(paths, vfs, parent);
    }
}

