/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.reflect.plugins.introspection;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.jboss.reflect.plugins.AnnotationAttributeImpl;
import org.jboss.reflect.plugins.AnnotationHelper;
import org.jboss.reflect.plugins.AnnotationInfoImpl;
import org.jboss.reflect.plugins.AnnotationValueFactory;
import org.jboss.reflect.plugins.ArrayInfoImpl;
import org.jboss.reflect.plugins.ClassInfoHelper;
import org.jboss.reflect.plugins.ClassInfoImpl;
import org.jboss.reflect.plugins.ConstructorInfoImpl;
import org.jboss.reflect.plugins.EnumInfoImpl;
import org.jboss.reflect.plugins.FieldInfoImpl;
import org.jboss.reflect.plugins.MethodInfoImpl;
import org.jboss.reflect.plugins.introspection.ReflectClassInfoImpl;
import org.jboss.reflect.plugins.introspection.ReflectConstructorInfoImpl;
import org.jboss.reflect.plugins.introspection.ReflectFieldInfoImpl;
import org.jboss.reflect.plugins.introspection.ReflectMethodInfoImpl;
import org.jboss.reflect.spi.AnnotationInfo;
import org.jboss.reflect.spi.AnnotationValue;
import org.jboss.reflect.spi.ClassInfo;
import org.jboss.reflect.spi.InterfaceInfo;
import org.jboss.reflect.spi.PrimitiveInfo;
import org.jboss.reflect.spi.TypeInfo;
import org.jboss.reflect.spi.TypeInfoFactory;
import org.jboss.util.collection.WeakClassCache;

public class IntrospectionTypeInfoFactoryImpl
extends WeakClassCache
implements TypeInfoFactory,
AnnotationHelper,
ClassInfoHelper {
    static final AnnotationValue[] NO_ANNOTATIONS = new AnnotationValue[0];

    public void generateTypeInfo(Class clazz, ClassInfoImpl info) {
    }

    public ClassInfoImpl getSuperClass(ClassInfoImpl classInfo) {
        Class<? extends Object> superClazz;
        Class<? extends Object> clazz = classInfo.getType();
        ClassInfoImpl superType = null;
        if (!clazz.isInterface() && (superClazz = clazz.getSuperclass()) != null) {
            superType = (ClassInfoImpl)this.getTypeInfo(superClazz);
        }
        return superType;
    }

    public AnnotationValue[] getAnnotations(Object obj) {
        Annotation[] annotations;
        if (obj instanceof AccessibleObject) {
            annotations = this.readAnnotations((AccessibleObject)obj);
        } else if (obj instanceof Class) {
            annotations = this.readAnnotations((Class)obj);
        } else {
            throw new RuntimeException("Attempt was made to read annotations from unsupported type " + obj.getClass().getName() + ": " + obj);
        }
        if (annotations.length == 0) {
            return NO_ANNOTATIONS;
        }
        AnnotationValue[] annotationValues = new AnnotationValue[annotations.length];
        for (int i = 0; i < annotations.length; ++i) {
            AnnotationInfo info = (AnnotationInfo)this.getTypeInfo(annotations[i].annotationType());
            annotationValues[i] = this.createAnnotationValue(info, annotations[i]);
        }
        return annotationValues;
    }

    public AnnotationValue createAnnotationValue(AnnotationInfo info, Object ann) {
        return AnnotationValueFactory.createAnnotationValue(this, this, info, ann);
    }

    public ConstructorInfoImpl[] getConstructors(ClassInfoImpl classInfo) {
        Constructor[] constructors;
        Class<? extends Object> clazz = classInfo.getType();
        ReflectConstructorInfoImpl[] infos = null;
        if (!clazz.isInterface() && (constructors = this.getDeclaredConstructors(clazz)) != null && constructors.length > 0) {
            infos = new ReflectConstructorInfoImpl[constructors.length];
            for (int i = 0; i < constructors.length; ++i) {
                AnnotationValue[] annotations = this.getAnnotations(constructors[i]);
                infos[i] = new ReflectConstructorInfoImpl(annotations, this.getTypeInfos(constructors[i].getParameterTypes()), this.getParameterAnnotations(constructors[i].getParameterAnnotations()), this.getClassInfos(constructors[i].getExceptionTypes()), constructors[i].getModifiers(), (ClassInfo)this.getTypeInfo(constructors[i].getDeclaringClass()));
                infos[i].setConstructor(constructors[i]);
            }
        }
        return infos;
    }

    public FieldInfoImpl[] getFields(ClassInfoImpl classInfo) {
        Class<? extends Object> clazz = classInfo.getType();
        Field[] fields = this.getDeclaredFields(clazz);
        if (fields == null || fields.length == 0) {
            return null;
        }
        FieldInfoImpl[] infos = new ReflectFieldInfoImpl[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            AnnotationValue[] annotations = this.getAnnotations(fields[i]);
            infos[i] = new ReflectFieldInfoImpl(annotations, fields[i].getName(), this.getTypeInfo(fields[i].getType()), fields[i].getModifiers(), (ClassInfo)this.getTypeInfo(fields[i].getDeclaringClass()));
            ((ReflectFieldInfoImpl)infos[i]).setField(fields[i]);
        }
        return infos;
    }

    public MethodInfoImpl[] getMethods(ClassInfoImpl classInfo) {
        Class<? extends Object> clazz = classInfo.getType();
        Method[] methods = this.getDeclaredMethods(clazz);
        if (methods == null || methods.length == 0) {
            return null;
        }
        MethodInfoImpl[] infos = new ReflectMethodInfoImpl[methods.length];
        for (int i = 0; i < methods.length; ++i) {
            AnnotationValue[] annotations = this.getAnnotations(methods[i]);
            infos[i] = new ReflectMethodInfoImpl(annotations, methods[i].getName(), this.getTypeInfo(methods[i].getReturnType()), this.getTypeInfos(methods[i].getParameterTypes()), this.getParameterAnnotations(methods[i].getParameterAnnotations()), this.getClassInfos(methods[i].getExceptionTypes()), methods[i].getModifiers(), (ClassInfo)this.getTypeInfo(methods[i].getDeclaringClass()));
            ((ReflectMethodInfoImpl)infos[i]).setMethod(methods[i]);
        }
        return infos;
    }

    public InterfaceInfo[] getInterfaces(ClassInfoImpl classInfo) {
        Class<? extends Object> clazz = classInfo.getType();
        Class<?>[] interfaces = clazz.getInterfaces();
        if (interfaces == null || interfaces.length == 0) {
            return null;
        }
        InterfaceInfo[] infos = new InterfaceInfo[interfaces.length];
        for (int i = 0; i < interfaces.length; ++i) {
            infos[i] = (InterfaceInfo)this.getTypeInfo(interfaces[i]);
        }
        return infos;
    }

    public TypeInfo[] getTypeInfos(Class[] classes) {
        if (classes == null || classes.length == 0) {
            return null;
        }
        TypeInfo[] result = new TypeInfo[classes.length];
        for (int i = 0; i < classes.length; ++i) {
            result[i] = this.getTypeInfo(classes[i]);
        }
        return result;
    }

    public ClassInfo[] getClassInfos(Class[] classes) {
        if (classes == null || classes.length == 0) {
            return null;
        }
        ClassInfo[] result = new ClassInfo[classes.length];
        for (int i = 0; i < classes.length; ++i) {
            result[i] = (ClassInfo)this.getTypeInfo(classes[i]);
        }
        return result;
    }

    public TypeInfo getTypeInfo(Class clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("Null class");
        }
        PrimitiveInfo primitive = PrimitiveInfo.valueOf(clazz.getName());
        if (primitive != null) {
            return primitive;
        }
        return (TypeInfo)this.get(clazz);
    }

    public TypeInfo getTypeInfo(String name, ClassLoader cl) throws ClassNotFoundException {
        if (name == null) {
            throw new IllegalArgumentException("Null class name");
        }
        if (cl == null) {
            cl = Thread.currentThread().getContextClassLoader();
        }
        Class<?> clazz = cl.loadClass(name);
        return this.getTypeInfo(clazz);
    }

    protected Object instantiate(Class clazz) {
        ClassInfoImpl result;
        if (clazz.isArray()) {
            TypeInfo componentType = this.getTypeInfo(clazz.getComponentType());
            result = new ArrayInfoImpl(componentType);
        } else if (clazz.isEnum()) {
            result = new EnumInfoImpl(clazz.getName(), clazz.getModifiers());
        } else if (clazz.isAnnotation()) {
            result = new AnnotationInfoImpl(clazz.getName(), clazz.getModifiers());
            Method[] methods = this.getDeclaredMethods(clazz);
            AnnotationAttributeImpl[] atttributes = new AnnotationAttributeImpl[methods.length];
            for (int i = 0; i < methods.length; ++i) {
                atttributes[i] = new AnnotationAttributeImpl(methods[i].getName(), this.getTypeInfo(methods[i].getReturnType()), null);
            }
            ((AnnotationInfoImpl)result).setAttributes(atttributes);
        } else {
            result = clazz.isInterface() ? new ReflectClassInfoImpl(clazz.getName()) : new ReflectClassInfoImpl(clazz.getName());
        }
        result.setType(clazz);
        result.setClassInfoHelper(this);
        result.setAnnotationHelper(this);
        return result;
    }

    protected void generate(Class clazz, Object result) {
        this.generateTypeInfo(clazz, (ClassInfoImpl)result);
    }

    protected Constructor[] getDeclaredConstructors(final Class clazz) {
        if (System.getSecurityManager() == null) {
            return clazz.getDeclaredConstructors();
        }
        PrivilegedAction<Constructor[]> action = new PrivilegedAction<Constructor[]>(){

            @Override
            public Constructor[] run() {
                return clazz.getDeclaredConstructors();
            }
        };
        return AccessController.doPrivileged(action);
    }

    protected Field[] getDeclaredFields(final Class clazz) {
        if (System.getSecurityManager() == null) {
            return clazz.getDeclaredFields();
        }
        PrivilegedAction<Field[]> action = new PrivilegedAction<Field[]>(){

            @Override
            public Field[] run() {
                return clazz.getDeclaredFields();
            }
        };
        return AccessController.doPrivileged(action);
    }

    protected Method[] getDeclaredMethods(final Class clazz) {
        if (System.getSecurityManager() == null) {
            return clazz.getDeclaredMethods();
        }
        PrivilegedAction<Method[]> action = new PrivilegedAction<Method[]>(){

            @Override
            public Method[] run() {
                return clazz.getDeclaredMethods();
            }
        };
        return AccessController.doPrivileged(action);
    }

    private Annotation[] readAnnotations(final AccessibleObject ao) {
        if (System.getSecurityManager() == null) {
            return ao.getAnnotations();
        }
        PrivilegedAction<Annotation[]> action = new PrivilegedAction<Annotation[]>(){

            @Override
            public Annotation[] run() {
                return ao.getAnnotations();
            }
        };
        return AccessController.doPrivileged(action);
    }

    private Annotation[] readAnnotations(final Class clazz) {
        if (System.getSecurityManager() == null) {
            return clazz.getAnnotations();
        }
        PrivilegedAction<Annotation[]> action = new PrivilegedAction<Annotation[]>(){

            @Override
            public Annotation[] run() {
                return clazz.getAnnotations();
            }
        };
        return AccessController.doPrivileged(action);
    }

    protected AnnotationValue[][] getParameterAnnotations(Annotation[][] annotations) {
        AnnotationValue[][] annotationValues = new AnnotationValue[annotations.length][];
        for (int param = 0; param < annotations.length; ++param) {
            annotationValues[param] = new AnnotationValue[annotations[param].length];
            for (int ann = 0; ann < annotations[param].length; ++ann) {
                AnnotationInfo info = (AnnotationInfo)this.getTypeInfo(annotations[param][ann].annotationType());
                annotationValues[param][ann] = this.createAnnotationValue(info, annotations[param][ann]);
            }
        }
        return annotationValues;
    }
}

