/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.reflect.plugins;

import java.io.Serializable;
import java.lang.annotation.Inherited;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jboss.reflect.plugins.AnnotationHelper;
import org.jboss.reflect.spi.AnnotatedInfo;
import org.jboss.reflect.spi.AnnotationValue;
import org.jboss.util.JBossObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class InheritableAnnotationHolder
extends JBossObject
implements AnnotatedInfo,
Serializable {
    private static final long serialVersionUID = 3257290210164289843L;
    private static final String INHERITED_NAME = Inherited.class.getName();
    static final Map<String, AnnotationValue> UNKNOWN_ANNOTATIONS_MAP = Collections.unmodifiableMap(new HashMap());
    static final AnnotationValue[] UNKNOWN_ANNOTATIONS = new AnnotationValue[0];
    protected Map<String, AnnotationValue> declaredAnnotations = UNKNOWN_ANNOTATIONS_MAP;
    protected Map<String, AnnotationValue> allAnnotations = UNKNOWN_ANNOTATIONS_MAP;
    protected AnnotationValue[] allAnnotationsArray = UNKNOWN_ANNOTATIONS;
    protected AnnotationValue[] declaredAnnotationsArray = UNKNOWN_ANNOTATIONS;
    protected Object annotatedElement;
    protected AnnotationHelper annotationHelper;

    public void setAnnotationHelper(AnnotationHelper helper) {
        this.annotationHelper = helper;
    }

    public void setAnnotatedElement(Object annotatedElement) {
        this.annotatedElement = annotatedElement;
    }

    public AnnotationValue[] getDeclaredAnnotations() {
        if (this.declaredAnnotationsArray == UNKNOWN_ANNOTATIONS) {
            this.setupAnnotations(this.annotationHelper.getAnnotations(this.annotatedElement));
        }
        return this.declaredAnnotationsArray;
    }

    @Override
    public AnnotationValue[] getAnnotations() {
        if (this.allAnnotationsArray == UNKNOWN_ANNOTATIONS) {
            this.setupAnnotations(this.annotationHelper.getAnnotations(this.annotatedElement));
        }
        return this.allAnnotationsArray;
    }

    @Override
    public AnnotationValue getAnnotation(String name) {
        if (this.allAnnotations == UNKNOWN_ANNOTATIONS_MAP) {
            this.setupAnnotations(this.annotationHelper.getAnnotations(this.annotatedElement));
        }
        return this.allAnnotations.get(name);
    }

    @Override
    public boolean isAnnotationPresent(String name) {
        if (this.allAnnotations == UNKNOWN_ANNOTATIONS_MAP) {
            this.setupAnnotations(this.annotationHelper.getAnnotations(this.annotatedElement));
        }
        return this.allAnnotations.containsKey(name);
    }

    public void setupAnnotations(AnnotationValue[] annotations) {
        AnnotationValue[] superAllAnnotations;
        InheritableAnnotationHolder superHolder = this.getSuperHolder();
        AnnotationValue[] annotationValueArray = superAllAnnotations = superHolder != null ? superHolder.getAnnotations() : null;
        if (annotations != null && annotations.length > 0) {
            int i;
            this.declaredAnnotations = new HashMap<String, AnnotationValue>();
            this.declaredAnnotationsArray = annotations;
            for (i = 0; i < annotations.length; ++i) {
                this.declaredAnnotations.put(annotations[i].getAnnotationType().getName(), annotations[i]);
            }
            this.allAnnotations = new HashMap<String, AnnotationValue>();
            if (superHolder != null && superAllAnnotations != null && superAllAnnotations.length != 0) {
                for (i = 0; i < superAllAnnotations.length; ++i) {
                    AnnotationValue av = superAllAnnotations[i];
                    if (!av.getAnnotationType().isAnnotationPresent(INHERITED_NAME)) continue;
                    this.allAnnotations.put(av.getAnnotationType().getName(), av);
                }
            } else {
                this.allAnnotationsArray = this.declaredAnnotationsArray;
            }
            for (i = 0; i < annotations.length; ++i) {
                this.allAnnotations.put(annotations[i].getAnnotationType().getName(), annotations[i]);
            }
            this.allAnnotationsArray = this.allAnnotations.values().toArray(new AnnotationValue[this.allAnnotations.size()]);
        } else if (superHolder != null) {
            this.allAnnotations = superHolder.getAllAnnotations();
            this.allAnnotationsArray = superAllAnnotations;
        }
    }

    protected Map<String, AnnotationValue> getAllAnnotations() {
        if (this.allAnnotations == UNKNOWN_ANNOTATIONS_MAP) {
            this.setupAnnotations(this.annotationHelper.getAnnotations(this.annotatedElement));
        }
        return this.allAnnotations;
    }

    protected abstract InheritableAnnotationHolder getSuperHolder();
}

