/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.reflect.plugins;

import org.jboss.reflect.plugins.ClassInfoImpl;
import org.jboss.reflect.spi.AnnotatedInfo;
import org.jboss.reflect.spi.AnnotationValue;
import org.jboss.reflect.spi.ArrayInfo;
import org.jboss.reflect.spi.TypeInfo;

public class ArrayInfoImpl
extends ClassInfoImpl
implements ArrayInfo {
    private static final long serialVersionUID = 3905804162787980599L;
    protected TypeInfo componentType;
    protected int hash = -1;

    public ArrayInfoImpl() {
    }

    public ArrayInfoImpl(TypeInfo componentType) {
        this.componentType = componentType;
        this.calculateHash();
    }

    public TypeInfo getComponentType() {
        return this.componentType;
    }

    public String getName() {
        return "[L" + this.componentType.getName() + ";";
    }

    public AnnotationValue getAnnotation(String name) {
        if (this.componentType instanceof AnnotatedInfo) {
            return ((AnnotatedInfo)((Object)this.componentType)).getAnnotation(name);
        }
        return null;
    }

    public AnnotationValue[] getAnnotations() {
        if (this.componentType instanceof AnnotatedInfo) {
            return ((AnnotatedInfo)((Object)this.componentType)).getAnnotations();
        }
        return UNKNOWN_ANNOTATIONS;
    }

    public boolean isAnnotationPresent(String name) {
        if (this.componentType instanceof AnnotatedInfo) {
            return ((AnnotatedInfo)((Object)this.componentType)).isAnnotationPresent(name);
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ArrayInfoImpl)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ArrayInfoImpl arrayInfo = (ArrayInfoImpl)o;
        return this.componentType.equals(arrayInfo.componentType);
    }

    public int hashCode() {
        return this.hash;
    }

    protected void calculateHash() {
        int result = super.hashCode();
        this.hash = result = 29 * result + this.componentType.hashCode();
    }
}

