/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.reflect.plugins;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import org.jboss.reflect.plugins.AnnotationHelper;
import org.jboss.reflect.plugins.AnnotationValueImpl;
import org.jboss.reflect.plugins.ArrayValueImpl;
import org.jboss.reflect.plugins.ClassValueImpl;
import org.jboss.reflect.plugins.EnumValueImpl;
import org.jboss.reflect.plugins.StringValueImpl;
import org.jboss.reflect.spi.AnnotationInfo;
import org.jboss.reflect.spi.AnnotationValue;
import org.jboss.reflect.spi.ArrayInfo;
import org.jboss.reflect.spi.ClassInfo;
import org.jboss.reflect.spi.EnumInfo;
import org.jboss.reflect.spi.PrimitiveInfo;
import org.jboss.reflect.spi.PrimitiveValue;
import org.jboss.reflect.spi.TypeInfo;
import org.jboss.reflect.spi.TypeInfoFactory;
import org.jboss.reflect.spi.Value;

public class AnnotationValueFactory {
    public static Value createValue(AnnotationHelper annotationHelper, TypeInfo type, Object value) {
        Value rtnValue = null;
        if (type instanceof ArrayInfo) {
            Object[] objects = AnnotationValueFactory.getArray((ArrayInfo)type, value);
            Value[] values = new Value[objects.length];
            for (int i = 0; i < objects.length; ++i) {
                values[i] = AnnotationValueFactory.createValue(annotationHelper, ((ArrayInfo)type).getComponentType(), objects[i]);
            }
            rtnValue = new ArrayValueImpl(type, values);
        } else if (type instanceof PrimitiveInfo) {
            rtnValue = new PrimitiveValue(value.toString(), (PrimitiveInfo)type);
        } else if (type.getName().equals("java.lang.String")) {
            rtnValue = new StringValueImpl((String)value, type);
        } else if (type instanceof AnnotationInfo) {
            rtnValue = annotationHelper.createAnnotationValue((AnnotationInfo)type, value);
        } else if (type instanceof EnumInfo) {
            rtnValue = new EnumValueImpl(type, value.toString());
        } else if (type instanceof ClassInfo) {
            rtnValue = new ClassValueImpl(((Class)value).getName(), type);
        }
        return rtnValue;
    }

    public static AnnotationValue createAnnotationValue(TypeInfoFactory typeInfoFactory, AnnotationHelper annotationHelper, AnnotationInfo info, Object ann) {
        Annotation annotation = (Annotation)ann;
        Class<? extends Annotation> clazz = annotation.annotationType();
        Method[] methods = AnnotationValueFactory.getDeclaredMethods(clazz);
        HashMap<String, Value> attributes = new HashMap<String, Value>();
        for (int j = 0; j < methods.length; ++j) {
            try {
                Class<?> typeClass = methods[j].getReturnType();
                Object val = methods[j].invoke((Object)annotation, new Object[0]);
                TypeInfo typeInfo = typeInfoFactory.getTypeInfo(typeClass);
                Value value = AnnotationValueFactory.createValue(annotationHelper, typeInfo, val);
                attributes.put(methods[j].getName(), value);
                continue;
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }
        return new AnnotationValueImpl(info, attributes);
    }

    private static Object[] getArray(ArrayInfo arrayInfo, Object value) {
        TypeInfo componentType = arrayInfo.getComponentType();
        if (!(componentType instanceof PrimitiveInfo)) {
            return (Object[])value;
        }
        Comparable<Boolean>[] ret = null;
        String typeName = componentType.getName();
        if (typeName.equals("boolean")) {
            boolean[] input = (boolean[])value;
            ret = new Boolean[input.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = new Boolean(input[i]);
            }
        } else if (typeName.equals("char")) {
            char[] input = (char[])value;
            ret = new Character[input.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = new Character(input[i]);
            }
        } else if (typeName.equals("double")) {
            double[] input = (double[])value;
            ret = new Double[input.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = new Double(input[i]);
            }
        } else if (typeName.equals("float")) {
            float[] input = (float[])value;
            ret = new Float[input.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = new Float(input[i]);
            }
        } else if (typeName.equals("int")) {
            int[] input = (int[])value;
            ret = new Integer[input.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = new Integer(input[i]);
            }
        } else if (typeName.equals("long")) {
            long[] input = (long[])value;
            ret = new Long[input.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = new Long(input[i]);
            }
        } else if (typeName.equals("short")) {
            short[] input = (short[])value;
            ret = new Short[input.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = new Short(input[i]);
            }
        }
        if (ret == null) {
            throw new RuntimeException("Array component type " + componentType + " is not handled");
        }
        return ret;
    }

    private static Method[] getDeclaredMethods(final Class clazz) {
        if (System.getSecurityManager() == null) {
            return clazz.getDeclaredMethods();
        }
        PrivilegedAction<Method[]> action = new PrivilegedAction<Method[]>(){

            @Override
            public Method[] run() {
                return clazz.getDeclaredMethods();
            }
        };
        return AccessController.doPrivileged(action);
    }
}

