/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.plugins.loader.memory;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.metadata.plugins.loader.AbstractMutableMetaDataLoader;
import org.jboss.metadata.spi.retrieval.AnnotationItem;
import org.jboss.metadata.spi.retrieval.AnnotationsItem;
import org.jboss.metadata.spi.retrieval.Item;
import org.jboss.metadata.spi.retrieval.MetaDataItem;
import org.jboss.metadata.spi.retrieval.MetaDatasItem;
import org.jboss.metadata.spi.retrieval.basic.BasicAnnotationItem;
import org.jboss.metadata.spi.retrieval.basic.BasicAnnotationsItem;
import org.jboss.metadata.spi.retrieval.basic.BasicMetaDataItem;
import org.jboss.metadata.spi.retrieval.basic.BasicMetaDatasItem;
import org.jboss.metadata.spi.scope.ScopeKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemoryMetaDataLoader
extends AbstractMutableMetaDataLoader {
    private volatile Map<String, BasicAnnotationItem> annotations;
    private volatile Map<String, BasicMetaDataItem> metaDataByName;
    private volatile BasicAnnotationsItem cachedAnnotationsItem;
    private volatile BasicMetaDatasItem cachedMetaDatasItem;
    private final boolean cachable;

    public MemoryMetaDataLoader() {
        this(true, false);
    }

    public MemoryMetaDataLoader(boolean cachable, boolean restricted) {
        super(restricted);
        this.cachable = cachable;
    }

    public MemoryMetaDataLoader(ScopeKey scope) {
        this(scope, true, false);
    }

    public MemoryMetaDataLoader(ScopeKey scope, boolean cachable, boolean restricted) {
        super(scope, restricted);
        this.cachable = cachable;
    }

    @Override
    public <T> boolean isCachable(Item<T> item) {
        return this.cachable;
    }

    @Override
    public AnnotationsItem retrieveAnnotations() {
        BasicAnnotationsItem result = this.cachedAnnotationsItem;
        if (result != null && result.isValid()) {
            return result;
        }
        Map<String, BasicAnnotationItem> temp = this.annotations;
        if (temp == null) {
            return this.noAnnotations();
        }
        Collection<BasicAnnotationItem> values = temp.values();
        if (values.isEmpty()) {
            return this.noAnnotations();
        }
        AnnotationItem[] items = values.toArray(new AnnotationItem[values.size()]);
        this.cachedAnnotationsItem = result = new BasicAnnotationsItem(this, items);
        return result;
    }

    @Override
    public <T extends Annotation> AnnotationItem<T> retrieveAnnotation(Class<T> annotationType) {
        Map<String, BasicAnnotationItem> temp = this.annotations;
        if (temp == null) {
            return null;
        }
        return temp.get(annotationType.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends Annotation> T addAnnotation(T annotation) {
        if (annotation == null) {
            throw new IllegalArgumentException("Null annotation");
        }
        this.checkRestricted(annotation);
        MemoryMetaDataLoader memoryMetaDataLoader = this;
        synchronized (memoryMetaDataLoader) {
            if (this.annotations == null) {
                this.annotations = new ConcurrentHashMap<String, BasicAnnotationItem>();
            }
        }
        T result = null;
        Class<? extends Annotation> annotationType = annotation.annotationType();
        BasicAnnotationItem old = this.annotations.get(annotationType.getName());
        if (old != null) {
            result = old.getAnnotation();
            if (result == annotation) {
                return result;
            }
            old.invalidate();
        }
        BasicAnnotationItem<T> item = new BasicAnnotationItem<T>(this, annotation);
        this.annotations.put(annotationType.getName(), item);
        this.invalidateAnnotationsItem();
        this.invalidateMetaDatasItem();
        this.invalidate();
        return result;
    }

    @Override
    public <T extends Annotation> T removeAnnotation(Class<T> annotationType) {
        if (this.annotations == null) {
            return null;
        }
        BasicAnnotationItem annotation = this.annotations.remove(annotationType.getName());
        if (annotation == null) {
            return null;
        }
        annotation.invalidate();
        this.invalidateAnnotationsItem();
        this.invalidateMetaDatasItem();
        return annotation.getAnnotation();
    }

    @Override
    public MetaDatasItem retrieveMetaData() {
        Map<String, BasicMetaDataItem> temp2;
        BasicMetaDatasItem result = this.cachedMetaDatasItem;
        if (result != null && result.isValid()) {
            return result;
        }
        ArrayList<BasicMetaDataItem> all = null;
        Map<String, BasicAnnotationItem> temp1 = this.annotations;
        if (temp1 != null && temp1.size() > 0) {
            if (all == null) {
                all = new ArrayList<BasicMetaDataItem>();
            }
            Collection<BasicAnnotationItem> values = temp1.values();
            all.addAll(values);
        }
        if ((temp2 = this.metaDataByName) != null && temp2.size() > 0) {
            if (all == null) {
                all = new ArrayList();
            }
            Collection<BasicMetaDataItem> values = temp2.values();
            all.addAll(values);
        }
        if (all == null) {
            return this.noMetaDatas();
        }
        MetaDataItem[] metaDataItems = all.toArray(new MetaDataItem[all.size()]);
        this.cachedMetaDatasItem = result = new BasicMetaDatasItem(this, metaDataItems);
        return result;
    }

    @Override
    public <T> MetaDataItem<T> retrieveMetaData(Class<T> type) {
        MetaDataItem<T> result = super.retrieveMetaData(type);
        if (result != null) {
            return result;
        }
        Map<String, BasicMetaDataItem> temp = this.metaDataByName;
        if (temp == null) {
            return null;
        }
        return temp.get(type.getName());
    }

    @Override
    public MetaDataItem retrieveMetaData(String name) {
        MetaDataItem result;
        Map<String, BasicMetaDataItem> temp = this.metaDataByName;
        if (temp != null && (result = (MetaDataItem)temp.get(name)) != null) {
            return result;
        }
        Map<String, BasicAnnotationItem> temp2 = this.annotations;
        if (temp2 != null) {
            return temp2.get(name);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T addMetaData(T metaData, Class<T> type) {
        if (metaData == null) {
            throw new IllegalArgumentException("Null metaData");
        }
        if (type == null) {
            throw new IllegalArgumentException("Null type");
        }
        if (metaData instanceof Annotation) {
            return (T)this.addAnnotation((Annotation)metaData);
        }
        this.checkRestricted(type);
        MemoryMetaDataLoader memoryMetaDataLoader = this;
        synchronized (memoryMetaDataLoader) {
            if (this.metaDataByName == null) {
                this.metaDataByName = new ConcurrentHashMap<String, BasicMetaDataItem>();
            }
        }
        T result = null;
        BasicMetaDataItem old = this.metaDataByName.get(type.getName());
        if (old != null) {
            result = old.getValue();
            if (result == metaData) {
                return result;
            }
            old.invalidate();
        }
        BasicMetaDataItem<T> item = new BasicMetaDataItem<T>(this, type.getName(), metaData);
        this.metaDataByName.put(type.getName(), item);
        this.invalidateMetaDatasItem();
        this.invalidate();
        return result;
    }

    @Override
    public <T> T removeMetaData(Class<T> type) {
        if (type == null) {
            throw new IllegalArgumentException("Null type");
        }
        if (type.isAnnotation()) {
            return this.removeAnnotation(type);
        }
        if (this.metaDataByName == null) {
            return null;
        }
        BasicMetaDataItem result = this.metaDataByName.remove(type.getName());
        if (result == null) {
            return null;
        }
        result.invalidate();
        this.invalidateMetaDatasItem();
        return result.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T addMetaData(String name, T metaData, Class<T> type) {
        if (name == null) {
            throw new IllegalArgumentException("Null name");
        }
        if (metaData == null) {
            throw new IllegalArgumentException("Null metaData");
        }
        if (type == null) {
            throw new IllegalArgumentException("Null type");
        }
        this.checkRestricted(type);
        MemoryMetaDataLoader memoryMetaDataLoader = this;
        synchronized (memoryMetaDataLoader) {
            if (this.metaDataByName == null) {
                this.metaDataByName = new ConcurrentHashMap<String, BasicMetaDataItem>();
            }
        }
        T result = null;
        BasicMetaDataItem old = this.metaDataByName.get(name);
        if (old != null) {
            result = old.getValue();
            if (result == metaData) {
                return result;
            }
            old.invalidate();
        }
        BasicMetaDataItem<T> item = new BasicMetaDataItem<T>(this, name, metaData);
        this.metaDataByName.put(name, item);
        this.invalidateMetaDatasItem();
        this.invalidate();
        return result;
    }

    @Override
    public <T> T removeMetaData(String name, Class<T> type) {
        if (name == null) {
            throw new IllegalArgumentException("Null name");
        }
        Map<String, BasicMetaDataItem> temp = this.metaDataByName;
        if (temp == null) {
            return null;
        }
        BasicMetaDataItem result = temp.remove(name);
        if (result == null) {
            return null;
        }
        result.invalidate();
        this.invalidateMetaDatasItem();
        return result.getValue();
    }

    protected void invalidateAnnotationsItem() {
        BasicAnnotationsItem temp = this.cachedAnnotationsItem;
        if (temp != null) {
            temp.invalidate();
            this.cachedAnnotationsItem = null;
        }
    }

    protected BasicAnnotationsItem noAnnotations() {
        BasicAnnotationsItem result;
        this.cachedAnnotationsItem = result = new BasicAnnotationsItem(this, BasicAnnotationsItem.NO_ANNOTATION_ITEMS);
        return result;
    }

    protected void invalidateMetaDatasItem() {
        BasicMetaDatasItem temp = this.cachedMetaDatasItem;
        if (temp != null) {
            temp.invalidate();
            this.cachedMetaDatasItem = null;
        }
    }

    protected BasicMetaDatasItem noMetaDatas() {
        BasicMetaDatasItem result;
        this.cachedMetaDatasItem = result = new BasicMetaDatasItem(this, BasicMetaDatasItem.NO_META_DATA_ITEMS);
        return result;
    }
}

