/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.util.naming;

import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.LinkRef;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import org.jboss.lang.JBossStringBuilder;
import org.jboss.logging.Logger;

public class ENCThreadLocalKey
implements ObjectFactory {
    private static final Logger log = Logger.getLogger(Class.forName("org.jboss.util.naming.ENCThreadLocalKey"));
    private static final ThreadLocal key = new ThreadLocal();

    public static void setKey(String tlkey) {
        key.set(tlkey);
    }

    public static String getKey() {
        return (String)key.get();
    }

    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable environment) throws Exception {
        RefAddr addr;
        Reference ref = (Reference)obj;
        String reftype = (String)key.get();
        boolean trace = log.isTraceEnabled();
        if (reftype == null) {
            if (trace) {
                log.trace((Object)"using default in ENC");
            }
            reftype = "default";
        }
        if ((addr = ref.get(reftype)) == null) {
            if (trace) {
                log.trace((Object)"using default in ENC");
            }
            addr = ref.get("default");
        }
        if (addr != null) {
            String target = (String)addr.getContent();
            if (trace) {
                log.trace((Object)new JBossStringBuilder().append("found Reference ").append(reftype).append(" with content ").append(target).toString());
            }
            return new LinkRef(target);
        }
        return null;
    }
}

