/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.net.protocol;

import edu.emory.mathcs.backport.java.util.Collections;
import java.net.URL;
import java.net.URLStreamHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.jboss.lang.JBossStringBuilder;
import org.jboss.logging.Logger;

public class URLStreamHandlerFactory
implements java.net.URLStreamHandlerFactory {
    private static final Logger log = Logger.getLogger(Class.forName("org.jboss.net.protocol.URLStreamHandlerFactory"));
    public static final String PACKAGE_PREFIX = "org.jboss.net.protocol";
    private static Map handlerMap = Collections.synchronizedMap(new HashMap());
    private static ThreadLocal createURLStreamHandlerProtocol = new ThreadLocal();
    private String[] handlerPkgs = new String[]{"org.jboss.net.protocol"};
    private String lastHandlerPkgs = "org.jboss.net.protocol";
    public static final String[] PROTOCOLS = new String[]{"resource", "file"};

    public static void preload() {
        for (int i = 0; i < PROTOCOLS.length; ++i) {
            try {
                URL url = new URL(PROTOCOLS[i], "", -1, "");
                log.trace((Object)new JBossStringBuilder().append("Loaded protocol: ").append(PROTOCOLS[i]).toString());
                continue;
            }
            catch (Exception e) {
                log.warn((Object)new JBossStringBuilder().append("Failed to load protocol: ").append(PROTOCOLS[i]).toString(), (Throwable)e);
            }
        }
    }

    public static void clear() {
        handlerMap.clear();
    }

    public URLStreamHandler createURLStreamHandler(String protocol) {
        URLStreamHandler handler = (URLStreamHandler)handlerMap.get(protocol);
        if (handler != null) {
            return handler;
        }
        String prevProtocol = (String)createURLStreamHandlerProtocol.get();
        if (prevProtocol != null && prevProtocol.equals(protocol)) {
            return null;
        }
        createURLStreamHandlerProtocol.set(protocol);
        this.checkHandlerPkgs();
        ClassLoader ctxLoader = Thread.currentThread().getContextClassLoader();
        for (int p = 0; p < this.handlerPkgs.length; ++p) {
            try {
                String classname = new JBossStringBuilder().append(this.handlerPkgs[p]).append(".").append(protocol).append(".Handler").toString();
                Class<?> type = null;
                try {
                    type = ctxLoader.loadClass(classname);
                }
                catch (ClassNotFoundException e) {
                    type = Class.forName(classname);
                }
                if (type == null) continue;
                handler = (URLStreamHandler)type.newInstance();
                handlerMap.put(protocol, handler);
                log.trace((Object)new JBossStringBuilder().append("Found protocol:").append(protocol).append(" handler:").append((Object)handler).toString());
                continue;
            }
            catch (Throwable ignore) {
                // empty catch block
            }
        }
        createURLStreamHandlerProtocol.set(null);
        return handler;
    }

    private synchronized void checkHandlerPkgs() {
        String handlerPkgsProp = System.getProperty("java.protocol.handler.pkgs");
        if (handlerPkgsProp != null && !handlerPkgsProp.equals(this.lastHandlerPkgs)) {
            StringTokenizer tokeninzer = new StringTokenizer(handlerPkgsProp, "|");
            ArrayList<String> tmp = new ArrayList<String>();
            while (tokeninzer.hasMoreTokens()) {
                String pkg = tokeninzer.nextToken().intern();
                if (tmp.contains(pkg)) continue;
                tmp.add(pkg);
            }
            if (!tmp.contains(PACKAGE_PREFIX)) {
                tmp.add(PACKAGE_PREFIX);
            }
            this.handlerPkgs = new String[tmp.size()];
            tmp.toArray(this.handlerPkgs);
            this.lastHandlerPkgs = handlerPkgsProp;
        }
    }
}

