/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.statetransfer;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.CacheException;
import org.jboss.cache.CacheImpl;
import org.jboss.cache.Fqn;
import org.jboss.cache.Node;
import org.jboss.cache.NodeFactory;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.Region;
import org.jboss.cache.buddyreplication.BuddyManager;
import org.jboss.cache.eviction.EvictedEventNode;
import org.jboss.cache.eviction.NodeEventType;
import org.jboss.cache.loader.CacheLoader;
import org.jboss.cache.marshall.NodeData;
import org.jboss.cache.marshall.NodeDataExceptionMarker;
import org.jboss.cache.marshall.NodeDataMarker;
import org.jboss.cache.statetransfer.StateTransferIntegrator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultStateTransferIntegrator
implements StateTransferIntegrator {
    protected Log log = LogFactory.getLog((String)this.getClass().getName());
    private CacheImpl cache;
    private Fqn targetFqn;
    private NodeFactory factory;
    private NodeFactory.NodeType nodeType;
    private Set<Fqn> internalFqns;

    public DefaultStateTransferIntegrator(Fqn targetFqn, CacheImpl cache) {
        this.targetFqn = targetFqn;
        this.cache = cache;
        this.factory = cache.getConfiguration().getRuntimeConfig().getNodeFactory();
        this.nodeType = cache.getConfiguration().isNodeLockingOptimistic() ? NodeFactory.NodeType.VERSIONED_NODE : NodeFactory.NodeType.UNVERSIONED_NODE;
        this.internalFqns = cache.getInternalFqns();
    }

    @Override
    public void integrateState(ObjectInputStream ois, Node target) throws Exception {
        this.integrateTransientState(ois, (NodeSPI)target);
        this.integrateAssociatedState(ois);
        this.integratePersistentState(ois);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void integrateTransientState(ObjectInputStream in, NodeSPI target) throws Exception {
        boolean transientSet = false;
        try {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("integrating transient state for " + target));
            }
            this.integrateTransientState(target, in);
            transientSet = true;
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)"transient state successfully integrated");
            }
            this.notifyAllNodesCreated(target);
        }
        catch (Exception e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Caught unexpected exception", (Throwable)e);
            }
        }
        finally {
            if (!transientSet) {
                this.log.warn((Object)("transient state integration failed, removing all children of " + target));
                target.clearData();
                target.removeChildrenDirect();
            }
        }
    }

    protected void integrateAssociatedState(ObjectInputStream in) throws Exception {
        this.cache.getMarshaller().objectFromObjectStream(in);
    }

    protected void integratePersistentState(ObjectInputStream in) throws Exception {
        CacheLoader loader = this.cache.getCacheLoader();
        if (loader == null) {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)"cache loader is null, will not attempt to integrate persistent state");
            }
        } else {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("integrating persistent state using " + loader.getClass().getName()));
            }
            boolean persistentSet = false;
            try {
                if (this.targetFqn.isRoot()) {
                    loader.storeEntireState(in);
                } else {
                    loader.storeState(this.targetFqn, in);
                }
                persistentSet = true;
            }
            catch (ClassCastException cce) {
                this.log.error((Object)"Failed integrating persistent state. One of cacheloaders is not adhering to state stream format. See JBCACHE-738.");
                throw cce;
            }
            finally {
                if (!persistentSet) {
                    this.log.warn((Object)"persistent state integration failed, removing all nodes from loader");
                    loader.remove(this.targetFqn);
                } else if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)"persistent state integrated successfully");
                }
            }
        }
    }

    protected CacheImpl getCache() {
        return this.cache;
    }

    protected NodeFactory getFactory() {
        return this.factory;
    }

    protected NodeFactory.NodeType getNodeType() {
        return this.nodeType;
    }

    protected Fqn getTargetFqn() {
        return this.targetFqn;
    }

    private void notifyAllNodesCreated(NodeSPI curr) {
        if (curr == null) {
            return;
        }
        this.getCache().getNotifier().notifyNodeCreated(curr.getFqn(), true, true);
        this.getCache().getNotifier().notifyNodeCreated(curr.getFqn(), false, true);
        Set children = curr.getChildrenDirect();
        for (NodeSPI n : children) {
            this.notifyAllNodesCreated(n);
        }
    }

    private void integrateTransientState(NodeSPI target, ObjectInputStream in) throws Exception {
        Set<Node> retainedNodes = this.retainInternalNodes(target);
        target.removeChildrenDirect();
        List<NodeData> list = this.readNodesAsList(in);
        if (list != null) {
            NodeData nd;
            Iterator<NodeData> nodeDataIterator = list.iterator();
            if (nodeDataIterator.hasNext() && (nd = nodeDataIterator.next()) != null && !nd.isMarker()) {
                target.putAll(nd.getAttributes());
                Fqn tferFqn = nd.getFqn();
                Fqn tgtFqn = target.getFqn();
                boolean move = tgtFqn.isChildOrEquals(BuddyManager.BUDDY_BACKUP_SUBTREE_FQN) && !tferFqn.isChildOrEquals(tgtFqn);
                int offset = move ? tgtFqn.size() - tferFqn.size() : 0;
                this.integrateStateTransferChildren(target, offset, nodeDataIterator);
                this.integrateRetainedNodes(target, retainedNodes);
            }
            this.cache.getMarshaller().objectFromObjectStream(in);
        }
    }

    private List<NodeData> readNodesAsList(ObjectInputStream in) throws Exception {
        Object obj = this.cache.getMarshaller().objectFromObjectStream(in);
        if (obj instanceof NodeDataMarker) {
            return null;
        }
        List list = (List)obj;
        return list;
    }

    private NodeData integrateStateTransferChildren(NodeSPI parent, int offset, Iterator<NodeData> nodeDataIterator) throws IOException, ClassNotFoundException {
        NodeData nd;
        int parent_level = parent.getFqn().size();
        int target_level = parent_level + 1;
        NodeData nodeData = nd = nodeDataIterator.hasNext() ? nodeDataIterator.next() : null;
        while (nd != null && !nd.isMarker()) {
            int size;
            Fqn fqn = nd.getFqn();
            if (offset > 0) {
                fqn = new Fqn(parent.getFqn().getAncestor(offset), fqn);
            }
            if ((size = fqn.size()) <= parent_level) {
                return nd;
            }
            if (size > target_level) {
                throw new IllegalStateException("NodeData " + fqn + " is not a direct child of " + parent.getFqn());
            }
            Object name = fqn.get(size - 1);
            Map attrs = nd.getAttributes();
            NodeSPI target = this.factory.createDataNode(name, fqn, parent, attrs, false);
            parent.addChild(name, target);
            Region region = this.cache.getRegion(fqn, false);
            if (region != null && region.getEvictionPolicy() != null) {
                region.putNodeEvent(new EvictedEventNode(fqn, NodeEventType.ADD_NODE_EVENT, attrs == null ? 0 : attrs.size()));
            }
            nd = this.integrateStateTransferChildren(target, offset, nodeDataIterator);
        }
        if (nd != null && nd.isExceptionMarker()) {
            NodeDataExceptionMarker ndem = (NodeDataExceptionMarker)nd;
            throw new CacheException("State provider node " + ndem.getCacheNodeIdentity() + " threw exception during loadState", ndem.getCause());
        }
        return null;
    }

    private Set<Node> retainInternalNodes(Node target) {
        HashSet<Node> result = new HashSet<Node>();
        Fqn targetFqn = target.getFqn();
        for (Fqn internalFqn : this.internalFqns) {
            Node internalNode;
            if (!internalFqn.isChildOf(targetFqn) || (internalNode = this.getInternalNode(target, internalFqn)) == null) continue;
            result.add(internalNode);
        }
        return result;
    }

    private Node getInternalNode(Node parent, Fqn internalFqn) {
        Object name = internalFqn.get(parent.getFqn().size());
        Node result = parent.getChild(new Fqn<Object>(name));
        if (result != null && internalFqn.size() < result.getFqn().size()) {
            result = this.getInternalNode(result, internalFqn);
        }
        return result;
    }

    private void integrateRetainedNodes(NodeSPI root, Set<Node> retainedNodes) {
        Fqn rootFqn = root.getFqn();
        for (Node retained : retainedNodes) {
            if (!retained.getFqn().isChildOf(rootFqn)) continue;
            this.integrateRetainedNode(root, retained);
        }
    }

    private void integrateRetainedNode(NodeSPI ancestor, Node descendant) {
        Fqn descFqn = descendant.getFqn();
        Fqn ancFqn = ancestor.getFqn();
        Object name = descFqn.get(ancFqn.size());
        NodeSPI child = (NodeSPI)ancestor.getChild(new Fqn<Object>(name));
        if (ancFqn.size() == descFqn.size() + 1) {
            if (child == null) {
                ancestor.addChild(name, descendant);
            } else {
                this.log.warn((Object)("Received unexpected internal node " + descFqn + " in transferred state"));
            }
        } else {
            if (child == null) {
                child = this.factory.createDataNode(name, new Fqn<Object>(ancFqn, name), ancestor, null, true);
                ancestor.addChild(name, child);
            }
            this.integrateRetainedNode(child, descendant);
        }
    }
}

