/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.rpc;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.CacheImpl;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.marshall.MethodCall;
import org.jboss.cache.marshall.MethodCallFactory;
import org.jboss.cache.rpc.NoHandlerForRPCException;
import org.jgroups.Address;

public class RpcTreeCache
extends CacheImpl {
    private static final Log log = LogFactory.getLog(RpcTreeCache.class);
    public static final Method dispatchRpcCallMethod;
    protected Map rpcHandlers = new HashMap();

    public RpcTreeCache(String cluster_name, String props, long state_fetch_timeout) throws Exception {
    }

    public RpcTreeCache() throws Exception {
    }

    public List callRemoteMethods(String serviceName, Vector members, Method method, Object[] args, boolean synchronous, boolean exclude_self, long timeout) throws Exception {
        return this.callRemoteMethods(serviceName, members, MethodCallFactory.create(method, args), synchronous, exclude_self, timeout);
    }

    public List callRemoteMethods(String serviceName, Vector mbrs, MethodCall method_call, boolean synchronous, boolean exclude_self, long timeout) throws Exception {
        List responses;
        block5: {
            block3: {
                block4: {
                    Object resp;
                    responses = null;
                    if (this.getConfiguration().getCacheMode() != Configuration.CacheMode.LOCAL) break block3;
                    if (!synchronous) break block4;
                    responses = new ArrayList<Object>();
                    if (!exclude_self && !((resp = this._dispatchRpcCall(serviceName, method_call)) instanceof NoHandlerForRPCException)) {
                        responses.add(this._dispatchRpcCall(serviceName, method_call));
                    }
                    break block5;
                }
                if (exclude_self) break block5;
                this._dispatchRpcCall(serviceName, method_call);
                break block5;
            }
            MethodCall wrapper = MethodCallFactory.create(dispatchRpcCallMethod, new Object[]{serviceName, method_call});
            responses = this.callRemoteMethods((List<Address>)mbrs, wrapper, synchronous, exclude_self, timeout);
            if (responses != null) {
                for (int i = 0; i < responses.size(); ++i) {
                    Object obj = responses.get(i);
                    if (!(obj instanceof NoHandlerForRPCException)) continue;
                    responses.remove(i);
                    --i;
                }
            }
        }
        return responses;
    }

    public List callRemoteMethods(String serviceName, Vector members, String method_name, Class[] types, Object[] args, boolean synchronous, boolean exclude_self, long timeout) throws Exception {
        Object handler = this.rpcHandlers.get(serviceName);
        if (handler == null) {
            String msg = "No rpc handler registered under: " + serviceName;
            log.trace((Object)msg);
            throw new NoHandlerForRPCException(msg);
        }
        Method method = handler.getClass().getDeclaredMethod(method_name, types);
        return this.callRemoteMethods(serviceName, members, method, args, synchronous, exclude_self, timeout);
    }

    public void registerRPCHandler(String serviceName, Object handler) {
        this.rpcHandlers.put(serviceName, handler);
    }

    public void unregisterRPCHandler(String serviceName, Object handler) {
        Object registered = this.rpcHandlers.remove(serviceName);
        if (handler != registered) {
            this.rpcHandlers.put(serviceName, handler);
        }
    }

    public Object _dispatchRpcCall(String serviceName, MethodCall call) {
        Object retval = null;
        Object handler = this.rpcHandlers.get(serviceName);
        if (handler == null) {
            String msg = "No rpc handler registered under: " + serviceName;
            log.trace((Object)msg);
            return new NoHandlerForRPCException(msg, this.getLocalAddress());
        }
        try {
            retval = call.invoke(handler);
        }
        catch (Throwable t) {
            log.trace((Object)"rpc call threw exception", t);
            retval = t;
        }
        return retval;
    }

    static {
        try {
            dispatchRpcCallMethod = RpcTreeCache.class.getDeclaredMethod("_dispatchRpcCall", String.class, MethodCall.class);
        }
        catch (NoSuchMethodException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

