/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.notifications;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.CacheImpl;
import org.jboss.cache.CacheListener;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;
import org.jboss.cache.InvocationContext;
import org.jboss.cache.marshall.MethodCall;
import org.jboss.cache.util.MapCopy;
import org.jgroups.View;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Notifier<K, V> {
    private boolean hasListeners = false;
    private CacheListener evictionPolicyListener;
    private final Set<CacheListener> listeners = new CopyOnWriteArraySet<CacheListener>();
    private CacheImpl cache;
    private InvocationContext tempCtx;
    private static final Log log = LogFactory.getLog(Notifier.class);
    private static Method nodeCreated;
    private static Method nodeModified;
    private static Method nodeRemoved;
    private static Method nodeVisited;
    private static Method nodeEvicted;
    private static Method nodeLoaded;
    private static Method nodePassivated;
    private static Method nodeActivated;
    private static Method nodeMoved;
    private static Method cacheStarted;
    private static Method cacheStopped;
    private static Method viewChange;
    private static Class emptyMap;
    private static Class singletonMap;

    public Notifier(CacheImpl cache) {
        this.cache = cache;
    }

    public void setEvictionPolicyListener(CacheListener l) {
        this.evictionPolicyListener = l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCacheListener(CacheListener l) {
        Set<CacheListener> set = this.listeners;
        synchronized (set) {
            this.listeners.add(l);
            this.hasListeners = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCacheListener(CacheListener l) {
        Set<CacheListener> set = this.listeners;
        synchronized (set) {
            this.listeners.remove(l);
            this.hasListeners = !this.listeners.isEmpty();
        }
    }

    public void removeAllCacheListeners() {
        this.listeners.clear();
        this.hasListeners = false;
    }

    public Set<CacheListener> getCacheListeners() {
        return Collections.unmodifiableSet(this.listeners);
    }

    public void notifyNodeCreated(Fqn fqn, boolean pre, boolean sendImmediately) {
        boolean originLocal = this.cache.getInvocationContext().isOriginLocal();
        if (sendImmediately) {
            this.resetInvocationContext();
            if (this.evictionPolicyListener != null) {
                this.evictionPolicyListener.nodeCreated(fqn, pre, originLocal);
            }
            if (this.hasListeners) {
                for (CacheListener listener : this.listeners) {
                    listener.nodeCreated(fqn, pre, originLocal);
                }
            }
            this.restoreInvocationContext();
        } else {
            MethodCall call = new MethodCall(nodeCreated, new Object[]{fqn, pre, originLocal});
            this.cache.getInvocationContext().addCacheListenerEvent(call);
        }
    }

    public void notifyNodeModified(Fqn fqn, boolean pre, CacheListener.ModificationType modificationType, Map<K, V> data, boolean sendImmediately) {
        boolean originLocal = this.cache.getInvocationContext().isOriginLocal();
        Map<Object, Object> dataCopy = this.copy(data);
        if (sendImmediately) {
            this.resetInvocationContext();
            if (this.evictionPolicyListener != null) {
                this.evictionPolicyListener.nodeModified(fqn, pre, originLocal, modificationType, dataCopy);
            }
            if (this.hasListeners) {
                for (CacheListener listener : this.listeners) {
                    listener.nodeModified(fqn, pre, originLocal, modificationType, dataCopy);
                }
            }
            this.restoreInvocationContext();
        } else {
            MethodCall call = new MethodCall(nodeModified, new Object[]{fqn, pre, originLocal, modificationType, dataCopy});
            this.cache.getInvocationContext().addCacheListenerEvent(call);
        }
    }

    public void notifyNodeRemoved(Fqn fqn, boolean pre, Map<K, V> data, boolean sendImmediately) {
        boolean originLocal = this.cache.getInvocationContext().isOriginLocal();
        Map<Object, Object> dataCopy = this.copy(data);
        if (sendImmediately) {
            this.resetInvocationContext();
            if (this.evictionPolicyListener != null) {
                this.evictionPolicyListener.nodeRemoved(fqn, pre, originLocal, dataCopy);
            }
            if (this.hasListeners) {
                for (CacheListener listener : this.listeners) {
                    listener.nodeRemoved(fqn, pre, originLocal, dataCopy);
                }
            }
            this.restoreInvocationContext();
        } else {
            MethodCall call = new MethodCall(nodeRemoved, new Object[]{fqn, pre, originLocal, dataCopy});
            this.cache.getInvocationContext().addCacheListenerEvent(call);
        }
    }

    public void notifyNodeVisited(Fqn fqn, boolean pre, boolean sendImmediately) {
        if (sendImmediately) {
            this.resetInvocationContext();
            if (this.evictionPolicyListener != null) {
                this.evictionPolicyListener.nodeVisited(fqn, pre);
            }
            if (this.hasListeners) {
                for (CacheListener listener : this.listeners) {
                    listener.nodeVisited(fqn, pre);
                }
            }
            this.restoreInvocationContext();
        } else {
            MethodCall call = new MethodCall(nodeVisited, new Object[]{fqn, pre});
            this.cache.getInvocationContext().addCacheListenerEvent(call);
        }
    }

    public void notifyNodeMoved(Fqn originalFqn, Fqn newFqn, boolean pre, boolean sendImmediately) {
        boolean originLocal = this.cache.getInvocationContext().isOriginLocal();
        if (sendImmediately) {
            this.resetInvocationContext();
            if (this.evictionPolicyListener != null) {
                this.evictionPolicyListener.nodeMoved(originalFqn, newFqn, pre, originLocal);
            }
            if (this.hasListeners) {
                for (CacheListener listener : this.listeners) {
                    listener.nodeMoved(originalFqn, newFqn, pre, originLocal);
                }
            }
            this.restoreInvocationContext();
        } else {
            MethodCall call = new MethodCall(nodeMoved, new Object[]{originalFqn, newFqn, pre, originLocal});
            this.cache.getInvocationContext().addCacheListenerEvent(call);
        }
    }

    public void notifyNodeEvicted(Fqn fqn, boolean pre, boolean sendImmediately) {
        boolean originLocal = this.cache.getInvocationContext().isOriginLocal();
        if (sendImmediately) {
            this.resetInvocationContext();
            if (this.evictionPolicyListener != null) {
                this.evictionPolicyListener.nodeEvicted(fqn, pre, originLocal);
            }
            if (this.hasListeners) {
                for (CacheListener listener : this.listeners) {
                    listener.nodeEvicted(fqn, pre, originLocal);
                }
            }
            this.restoreInvocationContext();
        } else {
            MethodCall call = new MethodCall(nodeEvicted, new Object[]{fqn, pre, originLocal});
            this.cache.getInvocationContext().addCacheListenerEvent(call);
        }
    }

    public void notifyNodeLoaded(Fqn fqn, boolean pre, Map<K, V> data, boolean sendImmediately) {
        Map<Object, Object> dataCopy = this.copy(data);
        if (sendImmediately) {
            this.resetInvocationContext();
            if (this.evictionPolicyListener != null) {
                this.evictionPolicyListener.nodeLoaded(fqn, pre, dataCopy);
            }
            if (this.hasListeners) {
                for (CacheListener listener : this.listeners) {
                    listener.nodeLoaded(fqn, pre, dataCopy);
                }
            }
            this.restoreInvocationContext();
        } else {
            MethodCall call = new MethodCall(nodeLoaded, new Object[]{fqn, pre, dataCopy});
            this.cache.getInvocationContext().addCacheListenerEvent(call);
        }
    }

    public void notifyNodeActivated(Fqn fqn, boolean pre, boolean sendImmediately) {
        if (sendImmediately) {
            this.resetInvocationContext();
            if (this.evictionPolicyListener != null) {
                this.evictionPolicyListener.nodeActivated(fqn, pre);
            }
            if (this.hasListeners) {
                for (CacheListener listener : this.listeners) {
                    listener.nodeActivated(fqn, pre);
                }
            }
            this.restoreInvocationContext();
        } else {
            MethodCall call = new MethodCall(nodeActivated, new Object[]{fqn, pre});
            this.cache.getInvocationContext().addCacheListenerEvent(call);
        }
    }

    public void notifyNodePassivated(Fqn fqn, boolean pre, boolean sendImmediately) {
        if (sendImmediately) {
            this.resetInvocationContext();
            if (this.evictionPolicyListener != null) {
                this.evictionPolicyListener.nodePassivated(fqn, pre);
            }
            if (this.hasListeners) {
                for (CacheListener listener : this.listeners) {
                    listener.nodePassivated(fqn, pre);
                }
            }
            this.restoreInvocationContext();
        } else {
            MethodCall call = new MethodCall(nodePassivated, new Object[]{fqn, pre});
            this.cache.getInvocationContext().addCacheListenerEvent(call);
        }
    }

    public void notifyCacheStarted(CacheSPI cache, boolean sendImmediately) {
        if (sendImmediately) {
            this.resetInvocationContext();
            if (this.evictionPolicyListener != null) {
                this.evictionPolicyListener.cacheStarted(cache);
            }
            if (this.hasListeners) {
                for (CacheListener listener : this.listeners) {
                    listener.cacheStarted(cache);
                }
            }
            this.restoreInvocationContext();
        } else {
            MethodCall call = new MethodCall(cacheStarted, new Object[]{cache});
            cache.getInvocationContext().addCacheListenerEvent(call);
        }
    }

    public void notifyCacheStopped(CacheSPI cache, boolean sendImmediately) {
        if (sendImmediately) {
            this.resetInvocationContext();
            if (this.evictionPolicyListener != null) {
                this.evictionPolicyListener.cacheStopped(cache);
            }
            if (this.hasListeners) {
                for (CacheListener listener : this.listeners) {
                    listener.cacheStopped(cache);
                }
            }
            this.restoreInvocationContext();
        } else {
            MethodCall call = new MethodCall(cacheStopped, new Object[]{cache});
            cache.getInvocationContext().addCacheListenerEvent(call);
        }
    }

    public void notifyViewChange(View new_view, boolean sendImmediately) {
        if (sendImmediately) {
            this.resetInvocationContext();
            if (this.evictionPolicyListener != null) {
                this.evictionPolicyListener.viewChange(new_view);
            }
            if (this.hasListeners) {
                for (CacheListener listener : this.listeners) {
                    listener.viewChange(new_view);
                }
            }
            this.restoreInvocationContext();
        } else {
            MethodCall call = new MethodCall(viewChange, new Object[]{new_view});
            this.cache.getInvocationContext().addCacheListenerEvent(call);
        }
    }

    private Map<K, V> copy(Map<K, V> data) {
        if (this.safe(data)) {
            return data;
        }
        return new MapCopy<K, V>(data);
    }

    private void restoreInvocationContext() {
        this.cache.getInvocationContext().setState(this.tempCtx);
    }

    private void resetInvocationContext() {
        try {
            this.tempCtx = this.cache.getInvocationContext().clone();
        }
        catch (CloneNotSupportedException e) {
            log.warn((Object)("Unable to clone Invocation Context " + this.cache.getInvocationContext()), (Throwable)e);
        }
        this.cache.getInvocationContext().reset();
    }

    private boolean safe(Map map) {
        return map == null || map instanceof MapCopy || map.getClass().equals(emptyMap) || map.getClass().equals(singletonMap);
    }

    public void invokeQueuedNotifications(List<MethodCall> queue) {
        this.resetInvocationContext();
        for (MethodCall c : queue) {
            if (this.evictionPolicyListener != null) {
                try {
                    c.invoke(this.evictionPolicyListener);
                }
                catch (Throwable throwable) {
                    log.error((Object)("Unable to deliver queued notification " + (Object)((Object)c) + " to eviction policy listener"), throwable);
                }
            }
            if (!this.hasListeners) continue;
            for (CacheListener listener : this.listeners) {
                try {
                    c.invoke(listener);
                }
                catch (Throwable throwable) {
                    log.error((Object)("Unable to deliver queued notification " + (Object)((Object)c) + " to listener " + listener), throwable);
                }
            }
        }
        this.restoreInvocationContext();
    }

    public void invokeQueuedNotifications() {
        this.invokeQueuedNotifications(this.cache.getInvocationContext().getCacheListenerEvents());
    }

    static {
        emptyMap = Collections.emptyMap().getClass();
        singletonMap = Collections.singletonMap(null, null).getClass();
        try {
            nodeCreated = CacheListener.class.getMethod("nodeCreated", Fqn.class, Boolean.TYPE, Boolean.TYPE);
            nodeModified = CacheListener.class.getMethod("nodeModified", Fqn.class, Boolean.TYPE, Boolean.TYPE, CacheListener.ModificationType.class, Map.class);
            nodeRemoved = CacheListener.class.getMethod("nodeRemoved", Fqn.class, Boolean.TYPE, Boolean.TYPE, Map.class);
            nodeVisited = CacheListener.class.getMethod("nodeVisited", Fqn.class, Boolean.TYPE);
            nodeEvicted = CacheListener.class.getMethod("nodeEvicted", Fqn.class, Boolean.TYPE, Boolean.TYPE);
            nodeLoaded = CacheListener.class.getMethod("nodeLoaded", Fqn.class, Boolean.TYPE, Map.class);
            nodePassivated = CacheListener.class.getMethod("nodePassivated", Fqn.class, Boolean.TYPE);
            nodeActivated = CacheListener.class.getMethod("nodeActivated", Fqn.class, Boolean.TYPE);
            nodeMoved = CacheListener.class.getMethod("nodeMoved", Fqn.class, Fqn.class, Boolean.TYPE, Boolean.TYPE);
            cacheStarted = CacheListener.class.getMethod("cacheStarted", CacheSPI.class);
            cacheStopped = CacheListener.class.getMethod("cacheStopped", CacheSPI.class);
            viewChange = CacheListener.class.getMethod("viewChange", View.class);
        }
        catch (Exception e) {
            log.error((Object)"Unable to initialise Notifier - unable to get Methods on CacheListener.class", (Throwable)e);
        }
    }
}

