/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.loader.rmi;

import java.rmi.Naming;
import javax.management.MBeanServer;
import javax.management.MBeanServerInvocationHandler;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.CacheImpl;
import org.jboss.cache.DefaultCacheFactory;
import org.jboss.cache.jmx.JmxUtil;
import org.jboss.cache.loader.rmi.RemoteTreeCacheImpl;
import org.jboss.cache.loader.rmi.RmiCacheServerMBean;

public class RmiCacheServer
implements RmiCacheServerMBean {
    static Log log = LogFactory.getLog(RmiCacheServer.class);
    CacheImpl cache;
    RemoteTreeCacheImpl remoteObj;
    String bindAddress;
    String mbeanServerName;
    int port;
    String configFile;
    String bindName;
    ObjectName cacheName;

    public String getBindAddress() {
        return this.bindAddress;
    }

    public void setBindAddress(String bindAddress) {
        this.bindAddress = bindAddress;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getMBeanServerName() {
        return this.mbeanServerName;
    }

    public void setMBeanServerName(String name) {
        this.mbeanServerName = name;
    }

    public String getConfig() {
        return this.configFile;
    }

    public void setConfig(String config) {
        this.configFile = config;
    }

    public CacheImpl getCache() {
        return this.cache;
    }

    public void setCache(CacheImpl cache) {
        this.cache = cache;
    }

    public String getCacheName() {
        return this.cacheName != null ? this.cacheName.toString() : "n/a";
    }

    public void setCacheName(String cacheName) throws MalformedObjectNameException {
        this.cacheName = new ObjectName(cacheName);
    }

    public String getBindName() {
        return this.bindName;
    }

    public void setBindName(String bindName) {
        this.bindName = bindName;
    }

    public RmiCacheServer(String host, int port, String bindName, String config) {
        this.bindAddress = host;
        this.port = port;
        this.configFile = config;
        this.bindName = bindName;
    }

    public void create() {
    }

    public void start() throws Exception {
        if (this.cache == null) {
            MBeanServer server = JmxUtil.getMBeanServer();
            if (this.cacheName != null && server != null) {
                this.cache = MBeanServerInvocationHandler.newProxyInstance(server, this.cacheName, CacheImpl.class, false);
            }
        }
        if (this.cache == null) {
            this.cache = (CacheImpl)DefaultCacheFactory.getInstance().createCache(this.configFile);
        }
        this.remoteObj = new RemoteTreeCacheImpl(this.cache);
        Naming.rebind("//" + this.bindAddress + ":" + this.port + "/" + this.bindName, this.remoteObj);
    }

    public void stop() {
        if (this.cache != null) {
            this.cache.stop();
            this.cache.destroy();
            this.cache = null;
        }
        if (this.remoteObj != null) {
            try {
                Naming.unbind("//" + this.bindAddress + ":" + this.port + "/" + this.bindName);
            }
            catch (Exception e) {
                log.error((Object)e, (Throwable)e);
            }
        }
    }

    public void destroy() {
    }

    public static void main(String[] args) {
        String bindAddress = "localhost";
        String configFile = "cache-service.xml";
        String bindName = "rmiCacheLoader";
        int port = 1098;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-bindAddress")) {
                bindAddress = args[++i];
                continue;
            }
            if (args[i].equals("-port")) {
                port = Integer.parseInt(args[i]);
                continue;
            }
            if (args[i].equals("-config")) {
                configFile = args[++i];
                continue;
            }
            if (args[i].equals("-bindName")) {
                bindName = args[++i];
                continue;
            }
            RmiCacheServer.help();
            return;
        }
        RmiCacheServer server = new RmiCacheServer(bindAddress, port, bindName, configFile);
        try {
            server.start();
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
        }
    }

    private static void help() {
        System.out.println("CacheServer [-bindAddress <host>] [-port <port>] [-bindName <RMI bind name>] [-config <cache config>] [-help]");
    }
}

