/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.loader;

import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.jboss.cache.CacheImpl;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.config.CacheLoaderConfig;
import org.jboss.cache.loader.DelegatingCacheLoader;
import org.jboss.cache.loader.RpcDelegatingCacheLoaderConfig;
import org.jboss.cache.lock.TimeoutException;
import org.jboss.cache.marshall.MethodCall;
import org.jboss.cache.marshall.MethodCallFactory;
import org.jgroups.Address;

public class RpcDelegatingCacheLoader
extends DelegatingCacheLoader {
    private RpcDelegatingCacheLoaderConfig config = new RpcDelegatingCacheLoaderConfig();
    private Address localAddress;
    public static final Method METHOD_GET_STATE;
    public static final Method METHOD_SET_STATE;
    public static final Method METHOD_GET_CHILDREN_NAMES;
    public static final Method METHOD_GET_WITH_2_PARAMS;
    public static final Method METHOD_GET_WITH_1_PARAM;
    public static final Method METHOD_EXISTS;
    public static final Method METHOD_PUT_WITH_3_PARAMS;
    public static final Method METHOD_PUT_WITH_2_PARAMS;
    public static final Method METHOD_REMOVE_WITH_2_PARAMS;
    public static final Method METHOD_REMOVE_WITH_1_PARAM;
    public static final Method METHOD_REMOVE_DATA;

    public RpcDelegatingCacheLoader() {
    }

    public RpcDelegatingCacheLoader(CacheSPI cache, int timeout) {
        this.setCache(cache);
        this.config.setTimeout(timeout);
    }

    public void setConfig(CacheLoaderConfig.IndividualCacheLoaderConfig base) {
        this.config = base instanceof RpcDelegatingCacheLoaderConfig ? (RpcDelegatingCacheLoaderConfig)base : new RpcDelegatingCacheLoaderConfig(base);
    }

    public CacheLoaderConfig.IndividualCacheLoaderConfig getConfig() {
        return this.config;
    }

    protected Set delegateGetChildrenNames(Fqn name) throws Exception {
        return (Set)this.doMethodCall(METHOD_GET_CHILDREN_NAMES, new Object[]{name});
    }

    protected Map delegateGet(Fqn name) throws Exception {
        NodeSPI n = (NodeSPI)this.doMethodCall(METHOD_GET_WITH_1_PARAM, new Object[]{name});
        if (n == null) {
            return null;
        }
        return n.getDataDirect();
    }

    protected boolean delegateExists(Fqn name) throws Exception {
        Boolean exists = (Boolean)this.doMethodCall(METHOD_EXISTS, new Object[]{name});
        return exists != null && exists != false;
    }

    protected Object delegatePut(Fqn name, Object key, Object value) throws Exception {
        return this.doMethodCall(METHOD_PUT_WITH_3_PARAMS, new Object[]{name, key, value});
    }

    protected void delegatePut(Fqn name, Map attributes) throws Exception {
        this.doMethodCall(METHOD_PUT_WITH_2_PARAMS, new Object[]{name, attributes});
    }

    protected Object delegateRemove(Fqn name, Object key) throws Exception {
        return this.doMethodCall(METHOD_REMOVE_WITH_2_PARAMS, new Object[]{name, key});
    }

    protected void delegateRemove(Fqn name) throws Exception {
        this.doMethodCall(METHOD_REMOVE_WITH_1_PARAM, new Object[]{name});
    }

    protected void delegateRemoveData(Fqn name) throws Exception {
        this.doMethodCall(METHOD_REMOVE_DATA, new Object[]{name});
    }

    protected void delegateLoadEntireState(ObjectOutputStream os) throws Exception {
    }

    protected void delegateLoadState(Fqn subtree, ObjectOutputStream os) throws Exception {
        throw new UnsupportedOperationException("setting and loading state for specific Fqns not supported");
    }

    protected void delegateStoreEntireState(ObjectInputStream is) throws Exception {
    }

    protected void delegateStoreState(Fqn subtree, ObjectInputStream is) throws Exception {
        throw new UnsupportedOperationException("setting and loading state for specific Fqns not supported");
    }

    private Object doMethodCall(Method method, Object[] args) throws Exception {
        if (this.cache.getRPCManager().isCoordinator()) {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)"Cannot delegate to the remote coordinator because the cache is itself the coordinator.");
            }
            return null;
        }
        if (this.localAddress == null) {
            this.localAddress = this.cache.getLocalAddress();
        }
        if (this.localAddress == null) {
            throw new Exception("Cannot delegate to the remote coordinator because the cache has no local address.");
        }
        Address coordinator = this.cache.getRPCManager().getCoordinator();
        if (coordinator == null) {
            throw new Exception("Cannot delegate to the remote coordinator because the cache has no coordinator.");
        }
        Vector<Address> members = new Vector<Address>();
        members.add(coordinator);
        MethodCall methodCall = MethodCallFactory.create(method, args);
        boolean synchronous = true;
        boolean excludeSelf = true;
        List responses = this.cache.getRPCManager().callRemoteMethods(members, methodCall, synchronous, excludeSelf, this.config.getTimeout());
        if (responses == null) {
            throw new Exception("Remote method call [" + this.cache.getLocalAddress() + "]->[" + coordinator + "]." + methodCall.getMethod().getName() + "() was discarded!");
        }
        Object response = responses.get(0);
        if (response instanceof TimeoutException) {
            throw new Exception("Remote method call [" + this.cache.getLocalAddress() + "]->[" + coordinator + "]." + methodCall.getMethod().getName() + "() timed out: " + response);
        }
        if (response instanceof Throwable) {
            throw new Exception("Remote method call [" + this.cache.getLocalAddress() + "]->[" + coordinator + "]." + methodCall.getMethod().getName() + "() failed!", (Throwable)response);
        }
        return response;
    }

    static {
        try {
            METHOD_GET_STATE = CacheImpl.class.getDeclaredMethod("getStateBytes", new Class[0]);
            METHOD_SET_STATE = CacheImpl.class.getDeclaredMethod("setStateBytes", byte[].class);
            METHOD_GET_CHILDREN_NAMES = CacheImpl.class.getDeclaredMethod("getChildrenNames", Fqn.class);
            METHOD_GET_WITH_2_PARAMS = CacheImpl.class.getDeclaredMethod("get", Fqn.class, Object.class);
            METHOD_GET_WITH_1_PARAM = CacheImpl.class.getDeclaredMethod("get", Fqn.class);
            METHOD_EXISTS = CacheImpl.class.getDeclaredMethod("exists", Fqn.class);
            METHOD_PUT_WITH_3_PARAMS = CacheImpl.class.getDeclaredMethod("put", Fqn.class, Object.class, Object.class);
            METHOD_PUT_WITH_2_PARAMS = CacheImpl.class.getDeclaredMethod("put", Fqn.class, Map.class);
            METHOD_REMOVE_WITH_2_PARAMS = CacheImpl.class.getDeclaredMethod("remove", Fqn.class, Object.class);
            METHOD_REMOVE_WITH_1_PARAM = CacheImpl.class.getDeclaredMethod("remove", Fqn.class);
            METHOD_REMOVE_DATA = CacheImpl.class.getDeclaredMethod("removeData", Fqn.class);
        }
        catch (NoSuchMethodException ex) {
            throw new ExceptionInInitializerError(ex);
        }
    }
}

