/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.loader;

import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.cache.Fqn;
import org.jboss.cache.Modification;
import org.jboss.cache.RegionManager;
import org.jboss.cache.config.CacheLoaderConfig;
import org.jboss.cache.loader.AbstractCacheLoader;
import org.jboss.cache.loader.CacheLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChainingCacheLoader
extends AbstractCacheLoader {
    private final List<CacheLoader> cacheLoaders = new ArrayList<CacheLoader>(2);
    private final List<CacheLoader> writeCacheLoaders = new ArrayList<CacheLoader>(2);
    private final List<CacheLoaderConfig.IndividualCacheLoaderConfig> cacheLoaderConfigs = new ArrayList<CacheLoaderConfig.IndividualCacheLoaderConfig>(2);

    @Override
    public void setConfig(CacheLoaderConfig.IndividualCacheLoaderConfig config) {
    }

    @Override
    public CacheLoaderConfig.IndividualCacheLoaderConfig getConfig() {
        return null;
    }

    @Override
    public Set<String> getChildrenNames(Fqn fqn) throws Exception {
        CacheLoader l;
        Set<String> answer = null;
        Iterator<CacheLoader> i = this.cacheLoaders.iterator();
        while (i.hasNext() && ((answer = (l = i.next()).getChildrenNames(fqn)) == null || answer.size() <= 0)) {
        }
        return answer;
    }

    public Map get(Fqn name) throws Exception {
        CacheLoader l;
        Map<Object, Object> answer = null;
        Iterator<CacheLoader> i = this.cacheLoaders.iterator();
        while (i.hasNext() && (answer = (l = i.next()).get(name)) == null) {
        }
        return answer;
    }

    @Override
    public boolean exists(Fqn name) throws Exception {
        CacheLoader l;
        boolean answer = false;
        Iterator<CacheLoader> i = this.cacheLoaders.iterator();
        while (i.hasNext() && !(answer = (l = i.next()).exists(name))) {
        }
        return answer;
    }

    @Override
    public Object put(Fqn name, Object key, Object value) throws Exception {
        Object answer = null;
        Iterator<CacheLoader> i = this.writeCacheLoaders.iterator();
        boolean isFirst = true;
        while (i.hasNext()) {
            CacheLoader l = i.next();
            Object tAnswer = l.put(name, key, value);
            if (!isFirst) continue;
            answer = tAnswer;
            isFirst = false;
        }
        return answer;
    }

    public void put(Fqn name, Map attributes) throws Exception {
        for (CacheLoader l : this.writeCacheLoaders) {
            l.put(name, attributes);
        }
    }

    @Override
    public void put(List<Modification> modifications) throws Exception {
        for (CacheLoader l : this.writeCacheLoaders) {
            l.put(modifications);
        }
    }

    @Override
    public Object remove(Fqn name, Object key) throws Exception {
        Object answer = null;
        Iterator<CacheLoader> i = this.writeCacheLoaders.iterator();
        boolean isFirst = true;
        while (i.hasNext()) {
            CacheLoader l = i.next();
            Object tAnswer = l.remove(name, key);
            if (!isFirst) continue;
            answer = tAnswer;
            isFirst = false;
        }
        return answer;
    }

    @Override
    public void remove(Fqn name) throws Exception {
        for (CacheLoader l : this.writeCacheLoaders) {
            l.remove(name);
        }
    }

    @Override
    public void removeData(Fqn name) throws Exception {
        for (CacheLoader l : this.writeCacheLoaders) {
            l.removeData(name);
        }
    }

    public void prepare(Object tx, List modifications, boolean one_phase) throws Exception {
        for (CacheLoader l : this.writeCacheLoaders) {
            l.prepare(tx, modifications, one_phase);
        }
    }

    @Override
    public void commit(Object tx) throws Exception {
        for (CacheLoader l : this.writeCacheLoaders) {
            l.commit(tx);
        }
    }

    @Override
    public void rollback(Object tx) {
        for (CacheLoader l : this.writeCacheLoaders) {
            l.rollback(tx);
        }
    }

    @Override
    public void create() throws Exception {
        Iterator<CacheLoader> it = this.cacheLoaders.iterator();
        Iterator<CacheLoaderConfig.IndividualCacheLoaderConfig> cfgIt = this.cacheLoaderConfigs.iterator();
        while (it.hasNext() && cfgIt.hasNext()) {
            CacheLoader cl = it.next();
            CacheLoaderConfig.IndividualCacheLoaderConfig cfg = cfgIt.next();
            cl.create();
        }
    }

    @Override
    public void start() throws Exception {
        Iterator<CacheLoader> it = this.cacheLoaders.iterator();
        while (it.hasNext()) {
            it.next().start();
        }
    }

    @Override
    public void stop() {
        Iterator<CacheLoader> it = this.cacheLoaders.iterator();
        while (it.hasNext()) {
            it.next().stop();
        }
    }

    @Override
    public void destroy() {
        Iterator<CacheLoader> it = this.cacheLoaders.iterator();
        while (it.hasNext()) {
            it.next().destroy();
        }
    }

    @Override
    public void setRegionManager(RegionManager manager) {
    }

    @Override
    public void loadEntireState(ObjectOutputStream os) throws Exception {
        Iterator<CacheLoader> i = this.cacheLoaders.iterator();
        Iterator<CacheLoaderConfig.IndividualCacheLoaderConfig> cfgs = this.cacheLoaderConfigs.iterator();
        while (i.hasNext() && cfgs.hasNext()) {
            CacheLoader l = i.next();
            CacheLoaderConfig.IndividualCacheLoaderConfig cfg = cfgs.next();
            if (!cfg.isFetchPersistentState()) continue;
            l.loadEntireState(os);
            break;
        }
    }

    @Override
    public void loadState(Fqn subtree, ObjectOutputStream os) throws Exception {
        Iterator<CacheLoader> i = this.cacheLoaders.iterator();
        Iterator<CacheLoaderConfig.IndividualCacheLoaderConfig> cfgs = this.cacheLoaderConfigs.iterator();
        while (i.hasNext() && cfgs.hasNext()) {
            CacheLoader l = i.next();
            CacheLoaderConfig.IndividualCacheLoaderConfig cfg = cfgs.next();
            if (!cfg.isFetchPersistentState()) continue;
            l.loadState(subtree, os);
            break;
        }
    }

    @Override
    public void storeEntireState(ObjectInputStream is) throws Exception {
        Iterator<CacheLoader> i = this.writeCacheLoaders.iterator();
        Iterator<CacheLoaderConfig.IndividualCacheLoaderConfig> cfgs = this.cacheLoaderConfigs.iterator();
        while (i.hasNext()) {
            CacheLoader l = i.next();
            CacheLoaderConfig.IndividualCacheLoaderConfig cfg = cfgs.next();
            if (!cfg.isFetchPersistentState()) continue;
            l.storeEntireState(is);
            break;
        }
    }

    @Override
    public void storeState(Fqn subtree, ObjectInputStream is) throws Exception {
        Iterator<CacheLoader> i = this.writeCacheLoaders.iterator();
        Iterator<CacheLoaderConfig.IndividualCacheLoaderConfig> cfgs = this.cacheLoaderConfigs.iterator();
        while (i.hasNext()) {
            CacheLoader l = i.next();
            CacheLoaderConfig.IndividualCacheLoaderConfig cfg = cfgs.next();
            if (!cfg.isFetchPersistentState()) continue;
            l.storeState(subtree, is);
            break;
        }
    }

    public int getSize() {
        return this.cacheLoaders.size();
    }

    public List<CacheLoader> getCacheLoaders() {
        return Collections.unmodifiableList(this.cacheLoaders);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCacheLoader(CacheLoader l, CacheLoaderConfig.IndividualCacheLoaderConfig cfg) {
        ChainingCacheLoader chainingCacheLoader = this;
        synchronized (chainingCacheLoader) {
            this.cacheLoaderConfigs.add(cfg);
            this.cacheLoaders.add(l);
            if (!cfg.isIgnoreModifications()) {
                this.writeCacheLoaders.add(l);
            }
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("ChainingCacheLoader{");
        Iterator<CacheLoader> i = this.cacheLoaders.iterator();
        Iterator<CacheLoaderConfig.IndividualCacheLoaderConfig> c = this.cacheLoaderConfigs.iterator();
        int count = 0;
        while (i.hasNext() && c.hasNext()) {
            CacheLoader loader = i.next();
            CacheLoaderConfig.IndividualCacheLoaderConfig cfg = c.next();
            buf.append(++count);
            buf.append(": IgnoreMods? ");
            buf.append(cfg.isIgnoreModifications());
            buf.append(" CLoader: ");
            buf.append(loader);
            buf.append("; ");
        }
        buf.append("}");
        return buf.toString();
    }

    public void purgeIfNecessary() throws Exception {
        Iterator<CacheLoader> loaders = this.cacheLoaders.iterator();
        Iterator<CacheLoaderConfig.IndividualCacheLoaderConfig> configs = this.cacheLoaderConfigs.iterator();
        while (loaders.hasNext() && configs.hasNext()) {
            CacheLoader myLoader = loaders.next();
            CacheLoaderConfig.IndividualCacheLoaderConfig myConfig = configs.next();
            if (myConfig.isIgnoreModifications() || !myConfig.isPurgeOnStartup()) continue;
            myLoader.remove(Fqn.ROOT);
        }
    }
}

