/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.loader;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.jboss.cache.Fqn;
import org.jboss.cache.Modification;
import org.jboss.cache.config.CacheLoaderConfig;
import org.jboss.cache.loader.AbstractCacheLoader;
import org.jboss.cache.loader.AdjListJDBCCacheLoaderConfig;
import org.jboss.cache.loader.ConnectionFactory;
import org.jboss.cache.loader.ManagedConnectionFactory;
import org.jboss.cache.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AdjListJDBCCacheLoader
extends AbstractCacheLoader {
    protected ConnectionFactory cf;
    protected String driverName;
    private AdjListJDBCCacheLoaderConfig config;
    protected static final Map NULL_NODE_IN_ROW = new Map(){

        public int size() {
            throw new UnsupportedOperationException();
        }

        public void clear() {
            throw new UnsupportedOperationException();
        }

        public boolean isEmpty() {
            throw new UnsupportedOperationException();
        }

        public boolean containsKey(Object key) {
            throw new UnsupportedOperationException();
        }

        public boolean containsValue(Object value) {
            throw new UnsupportedOperationException();
        }

        public Collection values() {
            throw new UnsupportedOperationException();
        }

        public void putAll(Map t) {
            throw new UnsupportedOperationException();
        }

        public Set entrySet() {
            throw new UnsupportedOperationException();
        }

        public Set keySet() {
            throw new UnsupportedOperationException();
        }

        public Object get(Object key) {
            throw new UnsupportedOperationException();
        }

        public Object remove(Object key) {
            throw new UnsupportedOperationException();
        }

        public Object put(Object key, Object value) {
            throw new UnsupportedOperationException();
        }
    };

    @Override
    public void setConfig(CacheLoaderConfig.IndividualCacheLoaderConfig base) {
        this.config = this.processConfig(base);
        if (this.config.getDatasourceName() == null) {
            try {
                this.getLogger().debug((Object)"Initialising with a connection factory since data source is not provided.");
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug((Object)("Using connection factory " + this.config.getConnectionFactoryClass()));
                }
                this.cf = (ConnectionFactory)Util.loadClass(this.config.getConnectionFactoryClass()).newInstance();
            }
            catch (Exception e) {
                this.getLogger().error((Object)"Connection factory class could not be loaded", (Throwable)e);
                throw new IllegalStateException("Connection factory class could not be loaded", e);
            }
        } else {
            this.cf = new ManagedConnectionFactory();
        }
        this.cf.setConfig(this.config);
    }

    public Map get(Fqn name) throws Exception {
        Map node = this.loadNode(name);
        return node == NULL_NODE_IN_ROW ? new HashMap(0) : node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> getChildrenNames(Fqn fqn) throws Exception {
        HashSet<String> children = null;
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)("executing sql: " + this.config.getSelectChildNamesSql() + " (" + fqn + ")"));
            }
            con = this.cf.getConnection();
            ps = con.prepareStatement(this.config.getSelectChildNamesSql());
            ps.setString(1, fqn.toString());
            rs = ps.executeQuery();
            if (rs.next()) {
                children = new HashSet<String>();
                do {
                    String child = rs.getString(1);
                    int slashInd = child.lastIndexOf(47);
                    String name = child.substring(slashInd + 1);
                    children.add(name);
                } while (rs.next());
            }
            this.safeClose(rs);
            this.safeClose(ps);
            this.cf.close(con);
        }
        catch (SQLException e) {
            try {
                this.reportAndRethrowError("Failed to get children names for fqn " + fqn, e);
                this.safeClose(rs);
                this.safeClose(ps);
                this.cf.close(con);
            }
            catch (Throwable throwable) {
                this.safeClose(rs);
                this.safeClose(ps);
                this.cf.close(con);
                throw throwable;
            }
        }
        return children == null ? null : Collections.unmodifiableSet(children);
    }

    @Override
    public void removeData(Fqn name) throws Exception {
        this.updateNode(name, null);
    }

    @Override
    public void prepare(Object tx, List<Modification> modifications, boolean one_phase) throws Exception {
        this.cf.prepare(tx);
        try {
            this.put(modifications);
            if (one_phase) {
                this.commit(tx);
            }
        }
        catch (Exception e) {
            this.rollback(tx);
            throw e;
        }
    }

    @Override
    public void commit(Object tx) throws Exception {
        this.cf.commit(tx);
    }

    @Override
    public void rollback(Object tx) {
        this.cf.rollback(tx);
    }

    @Override
    public void create() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() throws Exception {
        this.cf.start();
        Connection con = null;
        Statement st = null;
        try {
            con = this.cf.getConnection();
            this.driverName = this.getDriverName(con);
            if (this.config.getCreateTable() && !this.tableExists(this.config.getTable(), con)) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug((Object)("executing ddl: " + this.config.getCreateTableDDL()));
                }
                st = con.createStatement();
                st.executeUpdate(this.config.getCreateTableDDL());
            }
        }
        finally {
            this.safeClose(st);
            this.cf.close(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        if (this.config.getDropTable()) {
            Connection con = null;
            Statement st = null;
            try {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug((Object)("executing ddl: " + this.config.getDropTableDDL()));
                }
                con = this.cf.getConnection();
                st = con.createStatement();
                st.executeUpdate(this.config.getDropTableDDL());
                this.safeClose(st);
                this.safeClose(st);
                this.cf.close(con);
                this.cf.stop();
            }
            catch (SQLException e) {
                try {
                    this.getLogger().error((Object)("Failed to drop table: " + e.getMessage()), (Throwable)e);
                    this.safeClose(st);
                    this.cf.close(con);
                    this.cf.stop();
                }
                catch (Throwable throwable) {
                    this.safeClose(st);
                    this.cf.close(con);
                    this.cf.stop();
                    throw throwable;
                }
            }
        }
    }

    @Override
    public void destroy() {
    }

    @Override
    public boolean exists(Fqn name) throws Exception {
        Map node = this.loadNode(name);
        return node != null;
    }

    @Override
    public Object remove(Fqn name, Object key) throws Exception {
        Object removedValue = null;
        Map node = this.loadNode(name);
        if (node != null && node != NULL_NODE_IN_ROW) {
            removedValue = node.remove(key);
            if (node.isEmpty()) {
                this.updateNode(name, null);
            } else {
                this.updateNode(name, node);
            }
        }
        return removedValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map loadNode(Fqn name) {
        boolean rowExists = false;
        Map oldNode = null;
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)("executing sql: " + this.config.getSelectNodeSql() + " (" + name + ")"));
            }
            con = this.cf.getConnection();
            ps = con.prepareStatement(this.config.getSelectNodeSql());
            ps.setString(1, name.toString());
            rs = ps.executeQuery();
            if (rs.next()) {
                rowExists = true;
                InputStream is = rs.getBinaryStream(1);
                if (is != null && !rs.wasNull()) {
                    try {
                        Object marshalledNode = this.unmarshall(is);
                        oldNode = (Map)marshalledNode;
                    }
                    catch (Exception e) {
                        throw new Exception("Unable to load to deserialize result: ", e);
                    }
                    finally {
                        this.safeClose(is);
                    }
                }
            }
            this.safeClose(rs);
            this.safeClose(ps);
            this.cf.close(con);
        }
        catch (Exception e) {
            try {
                this.reportAndRethrowError("Failed to load node for fqn " + name, e);
                this.safeClose(rs);
                this.safeClose(ps);
                this.cf.close(con);
            }
            catch (Throwable throwable) {
                this.safeClose(rs);
                this.safeClose(ps);
                this.cf.close(con);
                throw throwable;
            }
        }
        return oldNode == null ? (rowExists ? NULL_NODE_IN_ROW : null) : oldNode;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void insertNode(Fqn name, Map node) {
        Connection con = null;
        PreparedStatement ps = null;
        try {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)("executing sql: " + this.config.getInsertNodeSql() + " (" + name + ")"));
            }
            con = this.cf.getConnection();
            ps = con.prepareStatement(this.config.getInsertNodeSql());
            ps.setString(1, name.toString());
            if (node != null) {
                byte[] byteStream = this.marshall(node);
                ByteArrayInputStream bais = new ByteArrayInputStream(byteStream);
                ps.setBinaryStream(2, (InputStream)bais, byteStream.length);
            } else if (this.driverName != null && (this.driverName.contains("SQLSERVER") || this.driverName.contains("POSTGRESQL"))) {
                ps.setNull(2, -4);
            } else {
                ps.setNull(2, 2004);
            }
            if (name.size() == 0) {
                ps.setNull(3, 12);
            } else {
                ps.setString(3, name.getAncestor(name.size() - 1).toString());
            }
            int rows = ps.executeUpdate();
            if (rows != 1) {
                throw new IllegalStateException("Expected one insert row but got " + rows);
            }
        }
        catch (RuntimeException e) {
            try {
                throw e;
                catch (Exception e2) {
                    this.getLogger().error((Object)("Failed to insert node :" + e2.getMessage()));
                    throw new IllegalStateException("Failed to insert node: " + e2.getMessage(), e2);
                }
            }
            catch (Throwable throwable) {
                this.safeClose(ps);
                this.cf.close(con);
                throw throwable;
            }
        }
        this.safeClose(ps);
        this.cf.close(con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateNode(Fqn name, Map node) {
        Connection con = null;
        PreparedStatement ps = null;
        try {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)("executing sql: " + this.config.getUpdateNodeSql()));
            }
            con = this.cf.getConnection();
            ps = con.prepareStatement(this.config.getUpdateNodeSql());
            if (node == null) {
                node = new HashMap(0);
            }
            byte[] byteStream = this.marshall(node);
            ByteArrayInputStream bais = new ByteArrayInputStream(byteStream);
            ps.setBinaryStream(1, (InputStream)bais, byteStream.length);
            ps.setString(2, name.toString());
            int rows = ps.executeUpdate();
            this.safeClose(ps);
            this.cf.close(con);
        }
        catch (Exception e) {
            try {
                this.reportAndRethrowError("Failed to update node for fqn " + name, e);
                this.safeClose(ps);
                this.cf.close(con);
            }
            catch (Throwable throwable) {
                this.safeClose(ps);
                this.cf.close(con);
                throw throwable;
            }
        }
    }

    protected String getDriverName(Connection con) {
        if (con == null) {
            return null;
        }
        try {
            DatabaseMetaData dmd = con.getMetaData();
            return AdjListJDBCCacheLoader.toUpperCase(dmd.getDriverName());
        }
        catch (SQLException e) {
            throw new IllegalStateException("Error while getting the driver name", e);
        }
    }

    static String getRequiredProperty(Properties props, String name) {
        String value = props.getProperty(name);
        if (value == null) {
            throw new IllegalStateException("Missing required property: " + name);
        }
        return value;
    }

    protected boolean tableExists(String tableName, Connection con) {
        ResultSet rs = null;
        try {
            DatabaseMetaData dmd = con.getMetaData();
            String catalog = con.getCatalog();
            String schema = null;
            String quote = dmd.getIdentifierQuoteString();
            if (tableName.startsWith(quote)) {
                if (!tableName.endsWith(quote)) {
                    throw new IllegalStateException("Mismatched quote in table name: " + tableName);
                }
                int quoteLength = quote.length();
                tableName = tableName.substring(quoteLength, tableName.length() - quoteLength);
                if (dmd.storesLowerCaseQuotedIdentifiers()) {
                    tableName = AdjListJDBCCacheLoader.toLowerCase(tableName);
                } else if (dmd.storesUpperCaseQuotedIdentifiers()) {
                    tableName = AdjListJDBCCacheLoader.toUpperCase(tableName);
                }
            } else if (dmd.storesLowerCaseIdentifiers()) {
                tableName = AdjListJDBCCacheLoader.toLowerCase(tableName);
            } else if (dmd.storesUpperCaseIdentifiers()) {
                tableName = AdjListJDBCCacheLoader.toUpperCase(tableName);
            }
            int dotIndex = tableName.indexOf(46);
            if (dotIndex != -1) {
                schema = tableName.substring(0, dotIndex);
                tableName = tableName.substring(dotIndex + 1);
            }
            rs = dmd.getTables(catalog, schema, tableName, null);
            boolean bl = rs.next();
            this.safeClose(rs);
            return bl;
        }
        catch (SQLException e) {
            try {
                throw new IllegalStateException("Error while checking if table aleady exists " + tableName, e);
            }
            catch (Throwable throwable) {
                this.safeClose(rs);
                throw throwable;
            }
        }
    }

    protected abstract Log getLogger();

    protected abstract AdjListJDBCCacheLoaderConfig processConfig(CacheLoaderConfig.IndividualCacheLoaderConfig var1);

    protected void reportAndRethrowError(String message, Exception cause) throws IllegalStateException {
        this.getLogger().error((Object)message, (Throwable)cause);
        throw new IllegalStateException(message, cause);
    }

    protected void safeClose(InputStream is) {
        if (is != null) {
            try {
                is.close();
            }
            catch (IOException e) {
                this.getLogger().warn((Object)("Failed to close input stream: " + e.getMessage()));
            }
        }
    }

    protected void safeClose(Statement st) {
        if (st != null) {
            try {
                st.close();
            }
            catch (SQLException e) {
                this.getLogger().warn((Object)("Failed to close statement: " + e.getMessage()));
            }
        }
    }

    protected void safeClose(ResultSet rs) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException e) {
                this.getLogger().warn((Object)("Failed to close result set: " + e.getMessage()));
            }
        }
    }

    protected Object unmarshall(InputStream from) throws Exception {
        return this.getMarshaller().objectFromStream(from);
    }

    protected byte[] marshall(Object obj) throws Exception {
        return this.getMarshaller().objectToByteBuffer(obj);
    }

    private static String toUpperCase(String s) {
        return s.toUpperCase(Locale.ENGLISH);
    }

    private static String toLowerCase(String s) {
        return s.toLowerCase(Locale.ENGLISH);
    }
}

