/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.interceptors;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;
import org.jboss.cache.InvocationContext;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.config.Option;
import org.jboss.cache.interceptors.BaseRpcInterceptor;
import org.jboss.cache.interceptors.InvalidationInterceptorMBean;
import org.jboss.cache.marshall.MethodCall;
import org.jboss.cache.marshall.MethodCallFactory;
import org.jboss.cache.marshall.MethodDeclarations;
import org.jboss.cache.optimistic.TransactionWorkspace;
import org.jboss.cache.transaction.GlobalTransaction;
import org.jboss.cache.transaction.OptimisticTransactionEntry;
import org.jboss.cache.transaction.TransactionEntry;
import org.jboss.cache.transaction.TransactionTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InvalidationInterceptor
extends BaseRpcInterceptor
implements InvalidationInterceptorMBean {
    private long m_invalidations = 0L;
    protected TransactionTable txTable;

    @Override
    public void setCache(CacheSPI cache) {
        super.setCache(cache);
        this.txTable = cache.getTransactionTable();
    }

    @Override
    public Object invoke(MethodCall m) throws Throwable {
        InvocationContext ctx = this.cache.getInvocationContext();
        Option optionOverride = ctx.getOptionOverrides();
        if (optionOverride != null && optionOverride.isCacheModeLocal() && ctx.getTransaction() == null) {
            return super.invoke(m);
        }
        Transaction tx = ctx.getTransaction();
        Object retval = super.invoke(m);
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("(" + this.cache.getLocalAddress() + ") method call " + (Object)((Object)m)));
        }
        if (MethodDeclarations.isCrudMethod(m.getMethodId())) {
            if (m.getMethodId() != 45) {
                Fqn fqn;
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)"Is a CRUD method");
                }
                if (!((fqn = this.findFqn(m.getArgs())) == null || tx != null && this.isValid(tx))) {
                    this.invalidateAcrossCluster(fqn, null);
                }
            } else {
                this.log.debug((Object)"Encountered a putForExternalRead() - is a no op.");
            }
        } else if (tx != null && this.isValid(tx)) {
            switch (m.getMethodId()) {
                case 10: 
                case 18: {
                    this.log.debug((Object)"Entering InvalidationInterceptor's prepare phase");
                    GlobalTransaction gtx = ctx.getGlobalTransaction();
                    TransactionEntry entry = this.txTable.get(gtx);
                    if (entry == null) {
                        throw new IllegalStateException("cannot find transaction entry for " + gtx);
                    }
                    LinkedList<MethodCall> modifications = new LinkedList<MethodCall>(entry.getModifications());
                    if (modifications.size() > 0) {
                        if (this.containsPutForExternalRead(modifications)) {
                            this.log.debug((Object)"Modification list contains a putForExternalRead operation.  Not invalidating.");
                            break;
                        }
                        try {
                            this.invalidateModifications(modifications, this.configuration.isNodeLockingOptimistic() ? this.getWorkspace(gtx) : null);
                            break;
                        }
                        catch (Throwable t) {
                            this.log.warn((Object)"Unable to broadcast evicts as a part of the prepare phase.  Rolling back.", t);
                            try {
                                tx.setRollbackOnly();
                            }
                            catch (SystemException se) {
                                throw new RuntimeException("setting tx rollback failed ", se);
                            }
                            if (t instanceof RuntimeException) {
                                throw t;
                            }
                            throw new RuntimeException("Unable to broadcast invalidation messages", t);
                        }
                    }
                    this.log.debug((Object)"Nothing to invalidate - no modifications in the transaction.");
                }
            }
        }
        return retval;
    }

    private boolean containsPutForExternalRead(List<MethodCall> l) {
        for (MethodCall m : l) {
            if (m.getMethodId() != 45 && m.getMethodId() != 46) continue;
            return true;
        }
        return false;
    }

    @Override
    public long getInvalidations() {
        return this.m_invalidations;
    }

    @Override
    public void resetStatistics() {
        this.m_invalidations = 0L;
    }

    @Override
    public Map<String, Object> dumpStatistics() {
        HashMap<String, Object> retval = new HashMap<String, Object>();
        retval.put("Invalidations", this.m_invalidations);
        return retval;
    }

    protected void invalidateAcrossCluster(Fqn fqn, TransactionWorkspace workspace) throws Throwable {
        MethodCall call;
        if (this.configuration.getExposeManagementStatistics() && this.getStatisticsEnabled()) {
            ++this.m_invalidations;
        }
        MethodCall methodCall = call = workspace != null && !workspace.isVersioningImplicit() ? MethodCallFactory.create(MethodDeclarations.evictVersionedNodeMethodLocal, fqn, workspace.getNode(fqn).getVersion()) : MethodCallFactory.create(MethodDeclarations.evictNodeMethodLocal, fqn);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Cache [" + this.cache.getLocalAddress() + "] replicating " + (Object)((Object)call)));
        }
        this.replicateCall(call, this.configuration.getCacheMode() == Configuration.CacheMode.INVALIDATION_SYNC);
    }

    protected void invalidateModifications(List<MethodCall> modifications, TransactionWorkspace workspace) throws Throwable {
        Set<Fqn> modifiedFqns = this.optimisedIterator(modifications);
        for (Fqn fqn : modifiedFqns) {
            this.invalidateAcrossCluster(fqn, workspace);
        }
    }

    protected TransactionWorkspace getWorkspace(GlobalTransaction gtx) {
        OptimisticTransactionEntry entry = (OptimisticTransactionEntry)this.txTable.get(gtx);
        return entry.getTransactionWorkSpace();
    }

    protected Fqn findFqn(Object[] objects) {
        return (Fqn)objects[1];
    }

    protected Set<Fqn> optimisedIterator(List<MethodCall> list) {
        HashSet<Fqn> fqns = new HashSet<Fqn>();
        for (MethodCall mc : list) {
            if (!MethodDeclarations.isCrudMethod(mc.getMethodId())) continue;
            fqns.add(this.findFqn(mc.getArgs()));
        }
        return fqns;
    }
}

