/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.interceptors;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.jboss.cache.CacheException;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;
import org.jboss.cache.InvocationContext;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.interceptors.BaseCacheLoaderInterceptor;
import org.jboss.cache.interceptors.CacheLoaderInterceptorMBean;
import org.jboss.cache.lock.NodeLock;
import org.jboss.cache.marshall.MethodCall;
import org.jboss.cache.marshall.MethodCallFactory;
import org.jboss.cache.marshall.MethodDeclarations;
import org.jboss.cache.transaction.GlobalTransaction;
import org.jboss.cache.transaction.TransactionEntry;
import org.jboss.cache.transaction.TransactionTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheLoaderInterceptor
extends BaseCacheLoaderInterceptor
implements CacheLoaderInterceptorMBean {
    private long m_cacheLoads = 0L;
    private long m_cacheMisses = 0L;
    private TransactionTable txTable = null;
    protected boolean isActivation = false;
    protected boolean useCacheStore = true;

    @Override
    public void setCache(CacheSPI cache) {
        super.setCache(cache);
        this.txTable = cache.getTransactionTable();
    }

    @Override
    public Object invoke(MethodCall m) throws Throwable {
        Fqn fqn = null;
        Fqn fqn2 = null;
        Object[] args = m.getArgs();
        boolean acquireLock = false;
        boolean initNode = false;
        Object key = null;
        InvocationContext ctx = this.cache.getInvocationContext();
        TransactionEntry entry = null;
        boolean recursive = false;
        GlobalTransaction gtx = ctx.getGlobalTransaction();
        if (gtx != null) {
            entry = this.txTable.get(gtx);
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("invoke " + (Object)((Object)m)));
        }
        switch (m.getMethodId()) {
            case 1: 
            case 2: {
                fqn = (Fqn)args[1];
                initNode = true;
                break;
            }
            case 3: 
            case 45: {
                fqn = (Fqn)args[1];
                if (this.useCacheStore) {
                    initNode = true;
                    break;
                }
                acquireLock = true;
                break;
            }
            case 36: {
                fqn = (Fqn)args[0];
                fqn2 = (Fqn)args[1];
                acquireLock = true;
                recursive = true;
                break;
            }
            case 15: {
                fqn = (Fqn)args[1];
                break;
            }
            case 26: {
                fqn = (Fqn)args[0];
                key = args[1];
                acquireLock = true;
                break;
            }
            case 17: 
            case 23: 
            case 25: 
            case 31: 
            case 32: {
                fqn = (Fqn)args[0];
                acquireLock = true;
                break;
            }
            case 12: {
                this.cleanupNodesCreated(entry);
                break;
            }
            default: {
                if (this.useCacheStore) break;
                if (m.getMethodId() == 6) {
                    fqn = (Fqn)args[1];
                    break;
                }
                if (m.getMethodId() != 7) break;
                fqn = (Fqn)args[1];
                initNode = true;
            }
        }
        if (fqn != null) {
            if (fqn2 != null) {
                this.loadIfNeeded(fqn2, key, initNode, acquireLock, m, entry, false, m.getMethodId() == 36);
            }
            this.loadIfNeeded(fqn, key, initNode, acquireLock, m, entry, recursive, m.getMethodId() == 36);
        }
        return super.invoke(m);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadIfNeeded(Fqn fqn, Object key, boolean initNode, boolean acquireLock, MethodCall m, TransactionEntry entry, boolean recursive, boolean isMove) throws Throwable {
        this.obtainLoaderLock(fqn);
        try {
            NodeSPI n = this.cache.peek(fqn, true);
            boolean mustLoad = this.mustLoad(n, key);
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("load element " + fqn + " mustLoad=" + mustLoad));
            }
            if (mustLoad) {
                if (initNode) {
                    n = this.createTempNode(fqn, entry);
                } else if (!this.wasRemovedInTx(fqn)) {
                    n = this.loadNode(fqn, n, entry);
                }
                if (acquireLock) {
                    this.lock(fqn, NodeLock.LockType.WRITE, false);
                }
            }
            if (recursive || m.getMethodId() == 23) {
                this.loadChildren(fqn, n, recursive, isMove);
            }
        }
        finally {
            this.releaseLoaderLock(fqn);
        }
    }

    private void loadChildren(Fqn fqn, NodeSPI node, boolean recursive, boolean isMove) throws Throwable {
        if (node != null && node.getChildrenLoaded()) {
            return;
        }
        Set<String> children_names = this.loader.getChildrenNames(fqn);
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("load children " + fqn + " children=" + children_names));
        }
        if (children_names == null) {
            if (node != null) {
                if (this.useCacheStore) {
                    node.removeChildrenDirect();
                }
                node.setChildrenLoaded(true);
            }
            return;
        }
        if (node == null) {
            node = this.createNodes(fqn, null);
        }
        for (String name : children_names) {
            Fqn<Object> child_fqn = new Fqn<Object>(name);
            NodeSPI<Object, Object> child = node.addChildDirect(child_fqn);
            if ((isMove || this.isActivation) && recursive) {
                child.putAllDirect(this.loader.get(child.getFqn()));
                child.setDataLoaded(true);
            } else {
                child.setDataLoaded(false);
            }
            if (!recursive) continue;
            this.loadChildren(child.getFqn(), child, true, isMove);
        }
        this.lock(fqn, recursive ? NodeLock.LockType.WRITE : NodeLock.LockType.READ, true);
        node.setChildrenLoaded(true);
    }

    private boolean mustLoad(NodeSPI n, Object key) {
        if (n == null) {
            this.log.trace((Object)"mustLoad, node null");
            return true;
        }
        if (!n.getDataLoaded()) {
            this.log.trace((Object)"must Load, uninitialized");
            return true;
        }
        return false;
    }

    @Override
    public long getCacheLoaderLoads() {
        return this.m_cacheLoads;
    }

    @Override
    public long getCacheLoaderMisses() {
        return this.m_cacheMisses;
    }

    @Override
    public void resetStatistics() {
        this.m_cacheLoads = 0L;
        this.m_cacheMisses = 0L;
    }

    @Override
    public Map<String, Object> dumpStatistics() {
        HashMap<String, Object> retval = new HashMap<String, Object>();
        retval.put("CacheLoaderLoads", this.m_cacheLoads);
        retval.put("CacheLoaderMisses", this.m_cacheMisses);
        return retval;
    }

    protected void lock(Fqn fqn, NodeLock.LockType lock_type, boolean recursive) throws Throwable {
        if (this.configuration.isNodeLockingOptimistic()) {
            return;
        }
        MethodCall m = MethodCallFactory.create(MethodDeclarations.lockMethodLocal, new Object[]{fqn, lock_type, recursive});
        this.cache.getInterceptorChain().get(0).invoke(m);
    }

    protected NodeSPI getNode(Fqn fqn) {
        return this.cache.peek(fqn, true);
    }

    private boolean wasRemovedInTx(Fqn fqn) {
        GlobalTransaction t = this.cache.getInvocationContext().getGlobalTransaction();
        if (t == null) {
            return false;
        }
        TransactionEntry entry = this.txTable.get(t);
        for (MethodCall m : entry.getCacheLoaderModifications()) {
            if (m.getMethodId() != 5 || !fqn.isChildOrEquals((Fqn)m.getArgs()[1])) continue;
            return true;
        }
        return false;
    }

    private NodeSPI loadNode(Fqn fqn, NodeSPI n, TransactionEntry entry) throws Exception {
        Map nodeData;
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("loadNode " + fqn));
        }
        if ((nodeData = this.loadData(fqn)) != null) {
            this.log.trace((Object)"Node data is not null, loading");
            this.cache.getNotifier().notifyNodeLoaded(fqn, true, Collections.emptyMap(), true);
            if (this.isActivation) {
                this.cache.getNotifier().notifyNodeActivated(fqn, true, true);
            }
            n = this.createNodes(fqn, entry);
            n.putAllDirect(nodeData);
            this.cache.getNotifier().notifyNodeLoaded(fqn, false, nodeData, true);
            if (this.isActivation) {
                this.cache.getNotifier().notifyNodeActivated(fqn, false, true);
            }
        }
        if (n != null && !n.getDataLoaded()) {
            this.log.trace((Object)"Setting dataLoaded to true");
            n.setDataLoaded(true);
        }
        return n;
    }

    private NodeSPI createTempNode(Fqn fqn, TransactionEntry entry) throws Exception {
        NodeSPI n = this.createNodes(fqn, entry);
        n.setDataLoaded(false);
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("createTempNode n " + n));
        }
        return n;
    }

    private NodeSPI createNodes(Fqn fqn, TransactionEntry entry) throws Exception {
        Fqn<Object> tmp_fqn = Fqn.ROOT;
        int size = fqn.size();
        NodeSPI n = this.cache.getRoot();
        for (int i = 0; i < size; ++i) {
            boolean last;
            Object child_name = fqn.get(i);
            tmp_fqn = new Fqn<Object>(tmp_fqn, child_name);
            NodeSPI child_node = this.findChild(n, child_name);
            boolean bl = last = i == size - 1;
            if (child_node == null) {
                if (last) {
                    child_node = n.addChildDirect(new Fqn<Object>(child_name));
                    child_node.setDataLoaded(true);
                } else {
                    child_node = n.addChildDirect(new Fqn<Object>(child_name));
                    child_node.setDataLoaded(false);
                }
                if (entry != null) {
                    entry.loadUninitialisedNode(tmp_fqn);
                }
            }
            n = child_node;
        }
        return n;
    }

    private NodeSPI findChild(NodeSPI child, Object child_name) {
        return (NodeSPI)child.getChildrenMapDirect().get(child_name);
    }

    private void cleanupNodesCreated(TransactionEntry entry) {
        boolean traceEnabled = this.log.isTraceEnabled();
        this.log.trace((Object)"Removing temporarily created nodes from treecache");
        List<Fqn> list = entry.getDummyNodesCreatedByCacheLoader();
        if (list != null && list.size() > 0) {
            ListIterator<Fqn> i = list.listIterator(list.size());
            while (i.hasPrevious()) {
                Fqn fqn = i.previous();
                try {
                    this.cache.evict(fqn, false);
                }
                catch (CacheException e) {
                    if (!traceEnabled) continue;
                    this.log.trace((Object)("Unable to evict node " + fqn), (Throwable)e);
                }
            }
        }
    }

    private Map loadData(Fqn fqn) throws Exception {
        boolean nodeExists;
        Map<Object, Object> nodeData = this.loader.get(fqn);
        boolean bl = nodeExists = nodeData != null;
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("nodeExists " + nodeExists));
        }
        if (this.configuration.getExposeManagementStatistics() && this.getStatisticsEnabled()) {
            if (nodeExists) {
                ++this.m_cacheLoads;
            } else {
                ++this.m_cacheMisses;
            }
        }
        return nodeData;
    }

    private void warnCustom() {
        this.log.warn((Object)"CacheLoader.get(Fqn) returned a null; assuming the node nodes not exist.");
        this.log.warn((Object)"The CacheLoader interface has changed since JBossCache 1.3.x");
        this.log.warn((Object)"Please see http://jira.jboss.com/jira/browse/JBCACHE-118");
        this.log.warn((Object)"CacheLoader.get() should return an empty Map if the node does exist but doesn't have any attributes.");
    }
}

