/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.eviction;

import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.Region;
import org.jboss.cache.eviction.BaseEvictionAlgorithm;
import org.jboss.cache.eviction.EvictedEventNode;
import org.jboss.cache.eviction.EvictionException;
import org.jboss.cache.eviction.EvictionQueue;
import org.jboss.cache.eviction.ExpirationConfiguration;
import org.jboss.cache.eviction.ExpirationPolicy;
import org.jboss.cache.eviction.NodeEntry;

public class ExpirationAlgorithm
extends BaseEvictionAlgorithm {
    private static final Log log = LogFactory.getLog(ExpirationAlgorithm.class);
    private ExpirationConfiguration config;
    private ExpirationPolicy policy;
    private SortedSet<ExpirationEntry> set;

    public ExpirationAlgorithm(ExpirationPolicy policy) {
        this.policy = policy;
        this.set = new TreeSet<ExpirationEntry>();
    }

    private void addEvictionEntry(EvictedEventNode node) {
        Fqn fqn = node.getFqn();
        this.addEvictionEntry(fqn);
    }

    private void addEvictionEntry(Fqn fqn) {
        Long l = this.getExpiration(fqn);
        if (l == null) {
            if (this.config.getWarnNoExpirationKey()) {
                log.warn((Object)("No expiration key '" + this.config.getExpirationKeyName() + "' for Node: " + fqn));
            } else if (log.isDebugEnabled()) {
                log.debug((Object)("No expiration key for Node: " + fqn));
            }
        } else {
            this.setExpiration(fqn, l);
        }
    }

    private void setExpiration(Fqn fqn, Long l) {
        boolean found = this.set.remove(new ExpirationEntry(fqn));
        if (found && log.isTraceEnabled()) {
            log.trace((Object)("removed old expiration for " + fqn));
        }
        ExpirationEntry ee = new ExpirationEntry(fqn, l);
        if (log.isTraceEnabled()) {
            log.trace((Object)("adding eviction entry: " + ee));
        }
        this.set.add(ee);
    }

    private Long getExpiration(Fqn fqn) {
        NodeSPI n = this.policy.getCache().peek(fqn, false);
        if (n == null) {
            return null;
        }
        return (Long)n.getDirect(this.config.getExpirationKeyName());
    }

    protected void processQueues(Region region) throws EvictionException {
        EvictedEventNode node;
        int count = 0;
        block6: while ((node = region.takeLastEventNode()) != null) {
            ++count;
            switch (node.getEventType()) {
                case ADD_NODE_EVENT: 
                case ADD_ELEMENT_EVENT: {
                    this.addEvictionEntry(node);
                    continue block6;
                }
                case REMOVE_ELEMENT_EVENT: 
                case REMOVE_NODE_EVENT: 
                case UNMARK_USE_EVENT: {
                    this.removeEvictionEntry(node);
                    continue block6;
                }
                case VISIT_NODE_EVENT: {
                    continue block6;
                }
                case MARK_IN_USE_EVENT: {
                    this.markInUse(node);
                    continue block6;
                }
            }
            throw new RuntimeException("Illegal Eviction Event type " + (Object)((Object)node.getEventType()));
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("processed " + count + " node events in region: " + region.getFqn()));
        }
    }

    private void markInUse(EvictedEventNode node) {
        long expiration = node.getInUseTimeout() + System.currentTimeMillis();
        this.setExpiration(node.getFqn(), expiration);
    }

    protected void prune() throws EvictionException {
        ExpirationEntry ee;
        if (this.set.isEmpty()) {
            return;
        }
        long now = System.currentTimeMillis();
        int max = this.config.getMaxNodes();
        Iterator i = this.set.iterator();
        while (i.hasNext() && ((ee = (ExpirationEntry)i.next()).getExpiration() < now || max != 0 && this.set.size() > max)) {
            i.remove();
            this.evictCacheNode(ee.getFqn());
        }
        if (max != 0 && max > this.set.size()) {
            log.warn((Object)("Unable to remove nodes to reduce region size below " + this.config.getMaxNodes() + ".  " + "Set expiration for nodes in this region"));
        }
    }

    private void removeEvictionEntry(EvictedEventNode node) {
        Fqn fqn = node.getFqn();
        if (this.getExpiration(fqn) == null) {
            this.set.remove(new ExpirationEntry(fqn));
        }
    }

    public void resetEvictionQueue(Region region) {
        for (ExpirationEntry ee : this.set) {
            this.addEvictionEntry(ee.getFqn());
        }
    }

    protected EvictionQueue setupEvictionQueue(Region region) throws EvictionException {
        this.region = region;
        this.config = (ExpirationConfiguration)region.getEvictionPolicyConfig();
        return new DummyEvictionQueue();
    }

    protected boolean shouldEvictNode(NodeEntry ne) {
        throw new UnsupportedOperationException();
    }

    class DummyEvictionQueue
    implements EvictionQueue {
        DummyEvictionQueue() {
        }

        public void addNodeEntry(NodeEntry entry) {
            throw new UnsupportedOperationException();
        }

        public void clear() {
            ExpirationAlgorithm.this.set.clear();
        }

        public boolean containsNodeEntry(NodeEntry entry) {
            return false;
        }

        public NodeEntry getFirstNodeEntry() {
            return null;
        }

        public NodeEntry getNodeEntry(Fqn fqn) {
            return null;
        }

        public NodeEntry getNodeEntry(String fqn) {
            return null;
        }

        public int getNumberOfElements() {
            return ExpirationAlgorithm.this.set.size();
        }

        public int getNumberOfNodes() {
            return ExpirationAlgorithm.this.set.size();
        }

        public Iterator iterate() {
            return null;
        }

        public void modifyElementCount(int difference) {
        }

        public void removeNodeEntry(NodeEntry entry) {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ExpirationEntry
    implements Comparable<ExpirationEntry> {
        private long expiration;
        private Fqn fqn;

        public ExpirationEntry(Fqn fqn) {
            this.fqn = fqn;
        }

        public ExpirationEntry(Fqn fqn, long expiration) {
            this.fqn = fqn;
            this.expiration = expiration;
        }

        @Override
        public int compareTo(ExpirationEntry ee) {
            if (this.fqn.equals(ee.fqn)) {
                return 0;
            }
            long n = this.expiration - ee.expiration;
            if (n < 0L) {
                return -1;
            }
            if (n > 0L) {
                return 1;
            }
            return this.fqn.compareTo(ee.fqn);
        }

        public long getExpiration() {
            return this.expiration;
        }

        public Fqn getFqn() {
            return this.fqn;
        }

        public boolean equals(Object o) {
            if (!(o instanceof ExpirationEntry)) {
                return false;
            }
            ExpirationEntry ee = (ExpirationEntry)o;
            return this.fqn.equals(ee.fqn);
        }

        public int hashCode() {
            return this.fqn.hashCode();
        }

        public String toString() {
            long now = System.currentTimeMillis();
            long ttl = this.expiration - now;
            String sttl = ttl > 60000L ? ttl / 60000L + "min" : (ttl > 1000L ? ttl / 1000L + "s" : ttl + "ms");
            return "EE fqn=" + this.fqn + " ttl=" + sttl;
        }
    }
}

