/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.eviction;

import org.jboss.cache.config.ConfigurationComponent;
import org.jboss.cache.config.ConfigurationException;
import org.jboss.cache.config.Dynamic;
import org.jboss.cache.eviction.EvictionPolicyConfig;

public abstract class EvictionPolicyConfigBase
extends ConfigurationComponent
implements EvictionPolicyConfig {
    private static final long serialVersionUID = 4591691674370188932L;
    private String evictionPolicyClass;
    @Dynamic
    private int maxNodes = 0;

    protected EvictionPolicyConfigBase() {
        this.setEvictionPolicyClassName();
    }

    public String getEvictionPolicyClass() {
        return this.evictionPolicyClass;
    }

    public void setEvictionPolicyClass(String evictionPolicyClass) {
        this.testImmutability("evictionPolicyClass");
        this.evictionPolicyClass = evictionPolicyClass;
    }

    public int getMaxNodes() {
        return this.maxNodes;
    }

    public void setMaxNodes(int maxNodes) {
        this.testImmutability("maxNodes");
        this.maxNodes = maxNodes;
    }

    public void validate() throws ConfigurationException {
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof EvictionPolicyConfigBase) {
            EvictionPolicyConfigBase other = (EvictionPolicyConfigBase)obj;
            return this.maxNodes == other.maxNodes && EvictionPolicyConfigBase.safeEquals(this.evictionPolicyClass, other.evictionPolicyClass);
        }
        return false;
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.maxNodes;
        result = 31 * result + (this.evictionPolicyClass == null ? 0 : this.evictionPolicyClass.hashCode());
        return result;
    }

    public void reset() {
        this.setEvictionPolicyClass(null);
        this.setMaxNodes(0);
        this.setEvictionPolicyClassName();
    }

    protected abstract void setEvictionPolicyClassName();
}

