/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.statetransfer;

import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.CacheException;
import org.jboss.cache.CacheImpl;
import org.jboss.cache.Fqn;
import org.jboss.cache.Node;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.config.Option;
import org.jboss.cache.loader.CacheLoaderManager;
import org.jboss.cache.lock.NodeLock;
import org.jboss.cache.lock.TimeoutException;
import org.jboss.cache.marshall.NodeData;
import org.jboss.cache.marshall.NodeDataMarker;
import org.jboss.cache.statetransfer.StateTransferFactory;
import org.jboss.cache.statetransfer.StateTransferGenerator;
import org.jboss.cache.statetransfer.StateTransferIntegrator;

public class StateTransferManager {
    protected static final Log log = LogFactory.getLog(StateTransferManager.class);
    public static final NodeData STREAMING_DELIMITER_NODE = new NodeDataMarker();
    public static final String PARTIAL_STATE_DELIMITER = "_PARTIAL_STATE_DELIMITER";
    private final CacheImpl cache;

    public StateTransferManager(CacheImpl cache) {
        this.cache = cache;
    }

    public CacheImpl getTreeCache() {
        return this.cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getState(ObjectOutputStream out, Fqn fqn, long timeout, boolean force, boolean suppressErrors) throws Throwable {
        boolean fetchPersistentState;
        boolean canProvideState = !this.cache.getRegionManager().isInactive(fqn) && this.cache.findNode(fqn) != null;
        boolean fetchTransientState = this.cache.getConfiguration().isFetchInMemoryState();
        CacheLoaderManager cacheLoaderManager = this.cache.getCacheLoaderManager();
        boolean bl = fetchPersistentState = cacheLoaderManager != null && cacheLoaderManager.isFetchPersistentState();
        if (canProvideState && (fetchPersistentState || fetchTransientState)) {
            this.cache.getMarshaller().objectToObjectStream(true, out);
            StateTransferGenerator generator = this.getStateTransferGenerator();
            Object owner = this.getOwnerForLock();
            long startTime = System.currentTimeMillis();
            NodeSPI rootNode = this.cache.findNode(fqn);
            try {
                log.info((Object)("locking the " + fqn + " subtree to return the in-memory (transient) state"));
                this.acquireLocksForStateTransfer(rootNode, owner, timeout, true, force);
                generator.generateState(out, rootNode, fetchTransientState, fetchPersistentState, suppressErrors);
                log.info((Object)("Successfully generated state in " + (System.currentTimeMillis() - startTime) + " msec"));
            }
            finally {
                this.releaseStateTransferLocks(rootNode, owner, true);
            }
        } else {
            this.cache.getMarshaller().objectToObjectStream(false, out);
            CacheException e = null;
            if (!canProvideState) {
                String exceptionMessage = "Cache instance at " + this.cache.getLocalAddress() + " cannot provide state for fqn " + fqn + ".";
                if (this.cache.getRegionManager().isInactive(fqn)) {
                    exceptionMessage = exceptionMessage + " Region for fqn " + fqn + " is inactive.";
                }
                if (this.cache.findNode(fqn) == null) {
                    exceptionMessage = exceptionMessage + " There is no cache node at fqn " + fqn;
                }
                e = new CacheException(exceptionMessage);
            }
            if (!fetchPersistentState && !fetchTransientState) {
                e = new CacheException("Cache instance at " + this.cache.getLocalAddress() + " is not configured to provide state");
            }
            this.cache.getMarshaller().objectToObjectStream(e, out);
            throw e;
        }
    }

    public void loadState(Fqn subtreeRoot, Node integrationRoot, Object[] sources, ClassLoader cl) throws Exception {
        this.cache.fetchPartialState(sources, subtreeRoot, integrationRoot.getFqn());
    }

    public void setState(ObjectInputStream in, Fqn targetRoot) throws Exception {
        Object o;
        Boolean hasState;
        CacheImpl cache = this.getTreeCache();
        NodeSPI target = cache.findNode(targetRoot);
        if (target == null) {
            cache.getInvocationContext().getOptionOverrides().setCacheModeLocal(true);
            cache.put(targetRoot, (Map)null);
            target = cache.findNode(targetRoot);
        }
        if (!(hasState = (Boolean)(o = cache.getMarshaller().objectFromObjectStream(in))).booleanValue()) {
            throw new CacheException("Cache instance at " + cache.getLocalAddress() + " cannot integrate state since state provider could not provide state due to " + cache.getMarshaller().objectFromObjectStream(in));
        }
        this.setState(in, target);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setState(ObjectInputStream state, NodeSPI targetRoot) throws Exception {
        Object owner = this.getOwnerForLock();
        long timeout = this.cache.getConfiguration().getInitialStateRetrievalTimeout();
        long startTime = System.currentTimeMillis();
        try {
            this.acquireLocksForStateTransfer(targetRoot, owner, timeout, true, true);
            Option option = new Option();
            option.setBypassInterceptorChain(true);
            this.cache.getInvocationContext().setOptionOverrides(option);
            StateTransferIntegrator integrator = this.getStateTransferIntegrator(state, targetRoot.getFqn());
            log.info((Object)("starting state integration at node " + targetRoot));
            integrator.integrateState(state, targetRoot);
            log.info((Object)("successfully integrated state in " + (System.currentTimeMillis() - startTime) + " msec"));
        }
        finally {
            this.releaseStateTransferLocks(targetRoot, owner, true);
        }
    }

    protected void acquireLocksForStateTransfer(NodeSPI root, Object lockOwner, long timeout, boolean lockChildren, boolean force) throws Exception {
        try {
            if (lockChildren) {
                root.getLock().acquireAll(lockOwner, timeout, NodeLock.LockType.READ);
            } else {
                root.getLock().acquire(lockOwner, timeout, NodeLock.LockType.READ);
            }
        }
        catch (TimeoutException te) {
            log.error((Object)("Caught TimeoutException acquiring locks on region " + root.getFqn()), (Throwable)te);
            if (force) {
                throw te;
            }
            throw te;
        }
    }

    protected void releaseStateTransferLocks(NodeSPI root, Object lockOwner, boolean childrenLocked) {
        try {
            if (childrenLocked) {
                root.getLock().releaseAll(lockOwner);
            } else {
                root.getLock().release(lockOwner);
            }
        }
        catch (Throwable t) {
            log.error((Object)"failed releasing locks", t);
        }
    }

    protected StateTransferGenerator getStateTransferGenerator() {
        return StateTransferFactory.getStateTransferGenerator(this.getTreeCache());
    }

    protected StateTransferIntegrator getStateTransferIntegrator(ObjectInputStream istream, Fqn fqn) throws Exception {
        return StateTransferFactory.getStateTransferIntegrator(istream, fqn, this.getTreeCache());
    }

    private Object getOwnerForLock() {
        Object owner = this.getTreeCache().getCurrentTransaction();
        if (owner == null) {
            owner = Thread.currentThread();
        }
        return owner;
    }
}

