/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.optimistic;

import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.cache.Fqn;
import org.jboss.cache.optimistic.TransactionWorkspace;
import org.jboss.cache.optimistic.WorkspaceNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransactionWorkspaceImpl<K, V>
implements TransactionWorkspace<K, V> {
    private Map<Fqn, WorkspaceNode<K, V>> nodes = new ConcurrentHashMap<Fqn, WorkspaceNode<K, V>>();
    private boolean versioningImplicit = true;

    @Override
    public Map<Fqn, WorkspaceNode<K, V>> getNodes() {
        return this.nodes;
    }

    @Override
    public void setNodes(Map<Fqn, WorkspaceNode<K, V>> nodes) {
        this.nodes = nodes;
    }

    @Override
    public WorkspaceNode<K, V> getNode(Fqn fqn) {
        return this.nodes.get(fqn);
    }

    @Override
    public void addNode(WorkspaceNode<K, V> node) {
        this.nodes.put(node.getFqn(), node);
    }

    @Override
    public WorkspaceNode<K, V> removeNode(Fqn fqn) {
        return this.nodes.remove(fqn);
    }

    @Override
    public SortedMap<Fqn, WorkspaceNode<K, V>> getNodesAfter(Fqn fqn) {
        TreeMap<Fqn, WorkspaceNode<K, V>> sm = new TreeMap<Fqn, WorkspaceNode<K, V>>();
        sm.putAll(this.nodes);
        return sm.tailMap(fqn);
    }

    @Override
    public boolean isVersioningImplicit() {
        return this.versioningImplicit;
    }

    @Override
    public void setVersioningImplicit(boolean versioningImplicit) {
        this.versioningImplicit = versioningImplicit;
    }

    @Override
    public boolean hasNode(Fqn fqn) {
        return this.nodes.containsKey(fqn);
    }

    public String toString() {
        return "Workspace nodes=" + this.nodes;
    }
}

