/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.loader;

import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.Modification;
import org.jboss.cache.RegionManager;
import org.jboss.cache.config.CacheLoaderConfig;
import org.jboss.cache.loader.AbstractCacheLoader;
import org.jboss.cache.loader.ClusteredCacheLoaderConfig;
import org.jboss.cache.marshall.MethodCall;
import org.jboss.cache.marshall.MethodCallFactory;
import org.jboss.cache.marshall.MethodDeclarations;
import org.jgroups.Address;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClusteredCacheLoader
extends AbstractCacheLoader {
    private static Log log = LogFactory.getLog(ClusteredCacheLoader.class);
    private ClusteredCacheLoaderConfig config;

    @Override
    public void setConfig(CacheLoaderConfig.IndividualCacheLoaderConfig base) {
        this.config = base instanceof ClusteredCacheLoaderConfig ? (ClusteredCacheLoaderConfig)base : new ClusteredCacheLoaderConfig(base);
    }

    @Override
    public CacheLoaderConfig.IndividualCacheLoaderConfig getConfig() {
        return this.config;
    }

    @Override
    public Set<String> getChildrenNames(Fqn fqn) throws Exception {
        MethodCall call = MethodCallFactory.create(MethodDeclarations.getChildrenNamesMethodLocal, fqn);
        Object resp = this.callRemote(call);
        return (Set)resp;
    }

    private Object callRemote(MethodCall call) throws Exception {
        if (log.isTraceEnabled()) {
            log.trace((Object)("cache=" + this.cache.getLocalAddress() + "; calling with " + (Object)((Object)call)));
        }
        List<Address> mbrs = this.cache.getMembers();
        MethodCall clusteredGet = MethodCallFactory.create(MethodDeclarations.clusteredGetMethod, new Object[]{call, false});
        List resps = this.cache.getRPCManager().callRemoteMethods(mbrs, clusteredGet, 1, true, this.config.getTimeout());
        if (resps == null) {
            if (log.isInfoEnabled()) {
                log.info((Object)("No replies to call " + (Object)((Object)call) + ".  Perhaps we're alone in the cluster?"));
            }
            return null;
        }
        Iterator i = resps.iterator();
        Object result = null;
        while (i.hasNext()) {
            Object o = i.next();
            if (o instanceof Exception) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)"Found remote exception among responses - removing from responses list", (Throwable)((Exception)o));
                continue;
            }
            List clusteredGetResp = (List)o;
            if (!((Boolean)clusteredGetResp.get(0)).booleanValue()) continue;
            result = clusteredGetResp.get(1);
            break;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("got responses " + resps));
        }
        return result;
    }

    public Map get(Fqn name) throws Exception {
        return this.get0(name);
    }

    protected Map get0(Fqn name) throws Exception {
        MethodCall call = MethodCallFactory.create(MethodDeclarations.getDataMapMethodLocal, name);
        Object resp = this.callRemote(call);
        Map m = (Map)resp;
        return m;
    }

    @Override
    public boolean exists(Fqn name) throws Exception {
        MethodCall call = MethodCallFactory.create(MethodDeclarations.existsMethod, name);
        Object resp = this.callRemote(call);
        return resp != null && (Boolean)resp != false;
    }

    @Override
    public Object put(Fqn name, Object key, Object value) throws Exception {
        if (this.cache.getInvocationContext().isOriginLocal()) {
            Object[] o = new Object[]{name, key, true};
            MethodCall call = MethodCallFactory.create(MethodDeclarations.getKeyValueMethodLocal, o);
            return this.callRemote(call);
        }
        log.trace((Object)"Call originated remotely.  Not bothering to try and do a clustered get() for this put().  Returning null.");
        return null;
    }

    public void put(Fqn name, Map attributes) throws Exception {
    }

    @Override
    public void put(List<Modification> modifications) throws Exception {
    }

    @Override
    public Object remove(Fqn name, Object key) throws Exception {
        Map map = this.get(name);
        return map == null ? null : map.get(key);
    }

    @Override
    public void remove(Fqn name) throws Exception {
    }

    @Override
    public void removeData(Fqn name) throws Exception {
    }

    public void prepare(Object tx, List modifications, boolean one_phase) throws Exception {
    }

    @Override
    public void commit(Object tx) throws Exception {
    }

    @Override
    public void rollback(Object tx) {
    }

    @Override
    public void loadEntireState(ObjectOutputStream os) throws Exception {
    }

    @Override
    public void loadState(Fqn subtree, ObjectOutputStream os) throws Exception {
    }

    @Override
    public void storeEntireState(ObjectInputStream is) throws Exception {
    }

    @Override
    public void storeState(Fqn subtree, ObjectInputStream is) throws Exception {
    }

    @Override
    public void setRegionManager(RegionManager manager) {
    }

    @Override
    public void create() throws Exception {
    }

    @Override
    public void start() throws Exception {
    }

    @Override
    public void stop() {
    }

    @Override
    public void destroy() {
    }
}

