/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.jmx;

import javax.management.NotificationBroadcaster;
import javax.transaction.TransactionManager;
import org.jboss.cache.config.BuddyReplicationConfig;
import org.jboss.cache.config.CacheLoaderConfig;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.config.EvictionConfig;
import org.jboss.cache.factories.XmlConfigurationParser;
import org.jboss.cache.jmx.CacheJmxWrapper;
import org.jboss.cache.jmx.CacheLegacyJmxWrapperMBean;
import org.jgroups.jmx.JChannelFactoryMBean;
import org.w3c.dom.Element;

public class CacheLegacyJmxWrapper
extends CacheJmxWrapper
implements CacheLegacyJmxWrapperMBean,
NotificationBroadcaster {
    private Element buddyReplConfig;
    private Element evictionConfig;
    private Element cacheLoaderConfig;

    public CacheLegacyJmxWrapper() {
        this.setConfiguration(new Configuration());
    }

    public Configuration getConfiguration() {
        Configuration result = super.getConfiguration();
        if (result == null) {
            result = new Configuration();
            this.setConfiguration(result);
        }
        return result;
    }

    public Element getBuddyReplicationConfig() {
        return this.buddyReplConfig;
    }

    public Element getCacheLoaderConfiguration() {
        return this.cacheLoaderConfig;
    }

    public String getCacheMode() {
        return this.getConfiguration().getCacheModeString();
    }

    public String getClusterName() {
        return this.getConfiguration().getClusterName();
    }

    public String getClusterProperties() {
        return this.getConfiguration().getClusterConfig();
    }

    public Element getEvictionPolicyConfig() {
        return this.evictionConfig;
    }

    public boolean getExposeManagementStatistics() {
        return this.getConfiguration().getExposeManagementStatistics();
    }

    public boolean getFetchInMemoryState() {
        return this.getConfiguration().isFetchInMemoryState();
    }

    public long getInitialStateRetrievalTimeout() {
        return this.getConfiguration().getInitialStateRetrievalTimeout();
    }

    public String getIsolationLevel() {
        return this.getConfiguration().getIsolationLevelString();
    }

    public long getLockAcquisitionTimeout() {
        return this.getConfiguration().getLockAcquisitionTimeout();
    }

    public String getMultiplexerService() {
        return this.getConfiguration().getMultiplexerService();
    }

    public String getMultiplexerStack() {
        return this.getConfiguration().getMultiplexerStack();
    }

    public JChannelFactoryMBean getMuxChannelFactory() {
        return this.getConfiguration().getRuntimeConfig().getMuxChannelFactory();
    }

    public String getNodeLockingScheme() {
        return this.getConfiguration().getNodeLockingSchemeString();
    }

    public long getReplQueueInterval() {
        return this.getConfiguration().getReplQueueInterval();
    }

    public int getReplQueueMaxElements() {
        return this.getConfiguration().getReplQueueMaxElements();
    }

    public String getReplicationVersion() {
        return this.getConfiguration().getReplVersionString();
    }

    public boolean getSyncCommitPhase() {
        return this.getConfiguration().isSyncCommitPhase();
    }

    public long getSyncReplTimeout() {
        return this.getConfiguration().getSyncReplTimeout();
    }

    public boolean getSyncRollbackPhase() {
        return this.getConfiguration().isSyncRollbackPhase();
    }

    public TransactionManager getTransactionManager() {
        return this.getConfiguration().getRuntimeConfig().getTransactionManager();
    }

    public String getTransactionManagerLookupClass() {
        return this.getConfiguration().getTransactionManagerLookupClass();
    }

    public boolean getUseRegionBasedMarshalling() {
        return this.getConfiguration().isUseRegionBasedMarshalling();
    }

    public boolean getUseReplQueue() {
        return this.getConfiguration().isUseReplQueue();
    }

    public boolean isInactiveOnStartup() {
        return this.getConfiguration().isInactiveOnStartup();
    }

    public void setBuddyReplicationConfig(Element config) {
        BuddyReplicationConfig brc = null;
        if (config != null) {
            brc = XmlConfigurationParser.parseBuddyReplicationConfig(config);
        }
        this.getConfiguration().setBuddyReplicationConfig(brc);
    }

    public void setCacheLoaderConfiguration(Element cache_loader_config) {
        CacheLoaderConfig clc = null;
        if (cache_loader_config != null) {
            clc = XmlConfigurationParser.parseCacheLoaderConfig(cache_loader_config);
        }
        this.getConfiguration().setCacheLoaderConfig(clc);
    }

    public void setCacheMode(String mode) throws Exception {
        this.getConfiguration().setCacheModeString(mode);
    }

    public void setClusterConfig(Element config) {
        String props = null;
        if (config != null) {
            props = XmlConfigurationParser.parseClusterConfigXml(config);
        }
        this.getConfiguration().setClusterConfig(props);
    }

    public void setClusterName(String name) {
        this.getConfiguration().setClusterName(name);
    }

    public void setClusterProperties(String cluster_props) {
        this.getConfiguration().setClusterConfig(cluster_props);
    }

    public void setEvictionPolicyConfig(Element config) {
        EvictionConfig ec = null;
        if (config != null) {
            ec = XmlConfigurationParser.parseEvictionConfig(config);
        }
        this.getConfiguration().setEvictionConfig(ec);
    }

    public void setExposeManagementStatistics(boolean expose) {
        this.getConfiguration().setExposeManagementStatistics(expose);
    }

    public void setFetchInMemoryState(boolean flag) {
        this.getConfiguration().setFetchInMemoryState(flag);
    }

    public void setInactiveOnStartup(boolean inactiveOnStartup) {
        this.getConfiguration().setInactiveOnStartup(inactiveOnStartup);
    }

    public void setInitialStateRetrievalTimeout(long timeout) {
        this.getConfiguration().setInitialStateRetrievalTimeout(timeout);
    }

    public void setIsolationLevel(String level) {
        this.getConfiguration().setIsolationLevelString(level);
    }

    public void setLockAcquisitionTimeout(long timeout) {
        this.getConfiguration().setLockAcquisitionTimeout(timeout);
    }

    public void setMultiplexerService(String serviceName) {
        this.getConfiguration().setMultiplexerService(serviceName);
    }

    public void setMultiplexerStack(String stackName) {
        this.getConfiguration().setMultiplexerStack(stackName);
    }

    public void setMuxChannelFactory(JChannelFactoryMBean factory) {
        this.getConfiguration().getRuntimeConfig().setMuxChannelFactory(factory);
    }

    public void setNodeLockingScheme(String nodeLockingScheme) {
        this.getConfiguration().setNodeLockingSchemeString(nodeLockingScheme);
    }

    public void setReplQueueInterval(long interval) {
        this.getConfiguration().setReplQueueInterval(interval);
    }

    public void setReplQueueMaxElements(int max_elements) {
        this.getConfiguration().setReplQueueMaxElements(max_elements);
    }

    public void setReplicationVersion(String version) {
        this.getConfiguration().setReplVersionString(version);
    }

    public void setSyncCommitPhase(boolean sync_commit_phase) {
        this.getConfiguration().setSyncCommitPhase(sync_commit_phase);
    }

    public void setSyncReplTimeout(long timeout) {
        this.getConfiguration().setSyncReplTimeout(timeout);
    }

    public void setSyncRollbackPhase(boolean sync_rollback_phase) {
        this.getConfiguration().setSyncRollbackPhase(sync_rollback_phase);
    }

    public void setTransactionManager(TransactionManager manager) {
        this.getConfiguration().getRuntimeConfig().setTransactionManager(manager);
    }

    public void setTransactionManagerLookupClass(String cl) throws Exception {
        this.getConfiguration().setTransactionManagerLookupClass(cl);
    }

    public void setUseRegionBasedMarshalling(boolean isTrue) {
        this.getConfiguration().setUseRegionBasedMarshalling(isTrue);
    }

    public void setUseReplQueue(boolean flag) {
        this.getConfiguration().setUseReplQueue(flag);
    }
}

