/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.jmx;

import javax.management.ListenerNotFoundException;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheImpl;
import org.jboss.cache.DefaultCacheFactory;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.config.ConfigurationException;
import org.jboss.cache.interceptors.CacheMgmtInterceptor;
import org.jboss.cache.interceptors.Interceptor;
import org.jboss.cache.jmx.CacheJmxWrapperMBean;
import org.jboss.cache.jmx.JmxUtil;

public class CacheJmxWrapper
implements CacheJmxWrapperMBean,
MBeanRegistration {
    private Log log = LogFactory.getLog((String)this.getClass().getName());
    private MBeanServer server;
    private String cacheObjectName;
    private boolean registeredInterceptorsInCreate;
    private boolean interceptorsRegistered;
    private CacheImpl<?, ?> cache;
    private boolean selfConstructed = false;
    private Configuration config;
    private boolean created;
    private boolean registerInterceptors = true;

    public CacheJmxWrapper() {
    }

    public CacheJmxWrapper(Cache cache) {
        this.setCache(cache);
    }

    public Cache getCache() {
        return this.cache;
    }

    public Configuration getConfiguration() {
        return this.cache == null ? null : this.cache.getConfiguration();
    }

    public String getConfigurationAsString() {
        return this.cache == null ? "Cache is null" : this.cache.getConfiguration().toString();
    }

    public String getConfigurationAsHtmlString() {
        return this.cache == null ? "Cache is null" : this.formatHtml(this.cache.getConfiguration().toString());
    }

    public String getCacheDetails() {
        return this.cache == null ? "Cache is null" : this.cache.printDetails();
    }

    public String getCacheDetailsAsHtml() {
        return this.cache == null ? "Cache is null" : this.formatHtml(this.cache.printDetails());
    }

    public int getNumberOfNodes() {
        return this.cache == null ? -1 : this.cache.getNumberOfNodes();
    }

    public int getNumberOfAttributes() {
        return this.cache == null ? -1 : this.cache.getNumberOfAttributes();
    }

    public String getLockInfo() {
        return this.cache == null ? "Cache is null" : this.cache.printLockInfo();
    }

    public String getLockInfoAsHtml() {
        return this.cache == null ? "Cache is null" : this.formatHtml(this.cache.printLockInfo());
    }

    public void addNotificationListener(NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) throws IllegalArgumentException {
        this.getCacheMgmtInterceptor().addNotificationListener(notificationListener, notificationFilter, object);
    }

    public void removeNotificationListener(NotificationListener notificationListener) throws ListenerNotFoundException {
        this.getCacheMgmtInterceptor().removeNotificationListener(notificationListener);
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        return this.getCacheMgmtInterceptor().getNotificationInfo();
    }

    private CacheMgmtInterceptor getCacheMgmtInterceptor() {
        for (Interceptor i : this.cache.getInterceptors()) {
            if (!(i instanceof CacheMgmtInterceptor)) continue;
            return (CacheMgmtInterceptor)i;
        }
        throw new RuntimeException("Cache management interceptor not found");
    }

    protected String formatHtml(String s) {
        s = s.replaceAll("\r\n", "<br />");
        s = s.replaceAll("\r", "<br />");
        s = s.replaceAll("\n", "<br />");
        s = s.replaceAll("\t", "&nbsp;&nbsp;&nbsp;&nbsp;");
        s = s.replaceAll(" ", "&nbsp;");
        return s;
    }

    public void create() throws Exception {
        if (this.cache == null) {
            if (this.config == null) {
                throw new ConfigurationException("Must call setConfiguration() or setCache() before call to create()");
            }
            this.constructCache();
        }
        if (this.selfConstructed) {
            this.cache.create();
        }
        this.registeredInterceptorsInCreate = this.registerInterceptors();
        this.created = true;
    }

    public void start() throws Exception {
        if (this.selfConstructed) {
            this.cache.start();
        }
    }

    public void stop() {
        if (this.selfConstructed) {
            this.cache.stop();
        }
    }

    public void destroy() {
        if (this.selfConstructed) {
            this.cache.destroy();
            if (this.registeredInterceptorsInCreate) {
                this.unregisterInterceptors();
            }
        }
        this.created = false;
    }

    public boolean getRegisterInterceptors() {
        return this.registerInterceptors;
    }

    public void setRegisterInterceptors(boolean register) {
        this.registerInterceptors = register;
    }

    protected void constructCache() throws Exception {
        this.log.debug((Object)"Constructing Cache");
        this.setCache(DefaultCacheFactory.getInstance().createCache(this.config, false));
        this.selfConstructed = true;
    }

    protected boolean registerInterceptors() throws Exception {
        if (this.registerInterceptors && !this.interceptorsRegistered && this.server != null) {
            this.log.debug((Object)"Registering interceptors");
            JmxUtil.registerInterceptors(this.server, this.cache.getInterceptorChain(), this.cacheObjectName);
            this.interceptorsRegistered = true;
            return true;
        }
        return false;
    }

    protected void unregisterInterceptors() {
        if (this.registerInterceptors && this.interceptorsRegistered && this.server != null) {
            try {
                this.log.debug((Object)"Unreqistering interceptors");
                JmxUtil.unregisterInterceptors(this.server, this.cache.getInterceptorChain(), this.getCacheObjectName());
                this.interceptorsRegistered = false;
            }
            catch (Exception e) {
                this.log.error((Object)"Exception unregistering interceptors from JMX", (Throwable)e);
            }
        }
    }

    public ObjectName preRegister(MBeanServer server, ObjectName objName) throws Exception {
        this.server = server;
        if (this.cacheObjectName == null) {
            if (objName == null) {
                this.getCacheObjectName();
            } else {
                this.cacheObjectName = objName.getCanonicalName();
            }
        }
        return new ObjectName(this.cacheObjectName);
    }

    public void postRegister(Boolean registrationDone) {
        if (Boolean.TRUE.equals(registrationDone)) {
            this.log.debug((Object)("Registered in JMX under " + this.cacheObjectName));
            if (this.cache != null) {
                try {
                    this.registerInterceptors();
                }
                catch (Exception e) {
                    this.log.error((Object)"Caught exception registering cache interceptors with JMX", (Throwable)e);
                }
            }
        }
    }

    public void preDeregister() throws Exception {
    }

    public void postDeregister() {
        this.unregisterInterceptors();
        this.server = null;
    }

    public void setConfiguration(Configuration config) {
        this.config = config;
    }

    public void setCache(Cache cache) {
        if (this.created) {
            throw new IllegalStateException("Cannot set underlying cache after call to create()");
        }
        this.cache = (CacheImpl)cache;
        this.config = cache == null ? null : cache.getConfiguration();
    }

    public String getCacheObjectName() {
        if (this.cacheObjectName == null) {
            this.cacheObjectName = JmxUtil.getCacheObjectName(this.config, CacheImpl.class.getName());
        }
        return this.cacheObjectName;
    }

    public void setCacheObjectName(String name) throws MalformedObjectNameException {
        if (name != null) {
            new ObjectName(name);
        }
        this.cacheObjectName = name;
    }

    public MBeanServer getMBeanServer() {
        return this.server;
    }
}

