/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.interceptors;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import org.jboss.cache.CacheException;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.InvocationContext;
import org.jboss.cache.ReplicationException;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.config.Option;
import org.jboss.cache.interceptors.BaseTransactionalContextInterceptor;
import org.jboss.cache.interceptors.OrderedSynchronizationHandler;
import org.jboss.cache.interceptors.TxInterceptorMBean;
import org.jboss.cache.marshall.MethodCall;
import org.jboss.cache.marshall.MethodCallFactory;
import org.jboss.cache.marshall.MethodDeclarations;
import org.jboss.cache.optimistic.DataVersion;
import org.jboss.cache.transaction.GlobalTransaction;
import org.jboss.cache.transaction.OptimisticTransactionEntry;
import org.jboss.cache.transaction.TransactionEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TxInterceptor
extends BaseTransactionalContextInterceptor
implements TxInterceptorMBean {
    private static final Object NULL = new Object();
    private Map transactions = new ConcurrentHashMap(16);
    private Map rollbackTransactions = new ConcurrentHashMap(16);
    private long m_prepares = 0L;
    private long m_commits = 0L;
    private long m_rollbacks = 0L;
    private Map remoteTransactions = new ConcurrentHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(MethodCall m) throws Throwable {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("(" + this.cache.getLocalAddress() + ") call on method [" + (Object)((Object)m) + "]"));
        }
        if (MethodDeclarations.isBuddyGroupOrganisationMethod(m.getMethodId())) {
            return super.invoke(m);
        }
        InvocationContext ctx = this.cache.getInvocationContext();
        boolean scrubTxsOnExit = false;
        Option optionOverride = ctx.getOptionOverrides();
        Object result = null;
        try {
            if (MethodDeclarations.isTransactionLifecycleMethod(m.getMethodId())) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Got gtx from invocation context " + ctx.getGlobalTransaction()));
                }
                if (ctx.getGlobalTransaction().isRemote()) {
                    this.remoteTransactions.put(ctx.getGlobalTransaction(), NULL);
                }
                switch (m.getMethodId()) {
                    case 10: 
                    case 18: {
                        if (ctx.getGlobalTransaction().isRemote()) {
                            result = this.handleRemotePrepare(m, ctx.getGlobalTransaction());
                            scrubTxsOnExit = true;
                            if (!this.configuration.getExposeManagementStatistics() || !this.getStatisticsEnabled()) break;
                            ++this.m_prepares;
                            break;
                        }
                        if (this.log.isTraceEnabled()) {
                            this.log.trace((Object)"received my own message (discarding it)");
                        }
                        result = null;
                        break;
                    }
                    case 11: 
                    case 12: {
                        if (ctx.getGlobalTransaction().isRemote()) {
                            result = this.handleRemoteCommitRollback(m, ctx.getGlobalTransaction());
                            scrubTxsOnExit = true;
                            break;
                        }
                        if (this.log.isTraceEnabled()) {
                            this.log.trace((Object)"received my own message (discarding it)");
                        }
                        result = null;
                    }
                }
            } else {
                result = this.handleNonTxMethod(m);
            }
        }
        catch (Exception e) {
            if (optionOverride == null || !optionOverride.isFailSilently()) {
                throw e;
            }
            this.log.trace((Object)"There was a problem handling this request, but failSilently was set, so suppressing exception", (Throwable)e);
        }
        finally {
            if (scrubTxsOnExit) {
                this.setTransactionalContext(null, null);
            }
        }
        return result;
    }

    @Override
    public long getPrepares() {
        return this.m_prepares;
    }

    @Override
    public long getCommits() {
        return this.m_commits;
    }

    @Override
    public long getRollbacks() {
        return this.m_rollbacks;
    }

    @Override
    public void resetStatistics() {
        this.m_prepares = 0L;
        this.m_commits = 0L;
        this.m_rollbacks = 0L;
    }

    @Override
    public Map<String, Object> dumpStatistics() {
        HashMap<String, Object> retval = new HashMap<String, Object>(3);
        retval.put("Prepares", this.m_prepares);
        retval.put("Commits", this.m_commits);
        retval.put("Rollbacks", this.m_rollbacks);
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object handleRemotePrepare(MethodCall m, GlobalTransaction gtx) throws Throwable {
        List modifications = (List)m.getArgs()[1];
        boolean onePhase = (Boolean)m.getArgs()[this.configuration.isNodeLockingOptimistic() ? 4 : 3];
        Transaction ltx = this.txTable.getLocalTransaction(gtx);
        Transaction currentTx = this.txManager.getTransaction();
        Object retval = null;
        try {
            if (ltx == null) {
                if (currentTx != null) {
                    this.txManager.suspend();
                }
                ltx = this.createLocalTxForGlobalTx(gtx);
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("(" + this.cache.getLocalAddress() + "): started new local TX as result of remote PREPARE: local TX=" + ltx + ", global TX=" + gtx));
                }
            } else {
                if (!this.isValid(ltx)) {
                    throw new CacheException("Transaction " + ltx + " not in correct state to be prepared");
                }
                if (currentTx == null || !ltx.equals(currentTx)) {
                    this.txManager.suspend();
                    this.txManager.resume(ltx);
                }
            }
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Resuming existing transaction " + ltx + ", global TX=" + gtx));
            }
            if (this.txTable.get(gtx) == null) {
                TransactionEntry entry = this.configuration.isNodeLockingOptimistic() ? new OptimisticTransactionEntry() : new TransactionEntry();
                entry.setTransaction(ltx);
                this.log.debug((Object)"creating new tx entry");
                this.txTable.put(gtx, entry);
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("TxTable contents: " + this.txTable));
                }
            }
            this.registerHandler(ltx, new RemoteSynchronizationHandler(gtx, ltx, this.cache));
            retval = this.configuration.isNodeLockingOptimistic() ? this.handleOptimisticPrepare(m, gtx, modifications, onePhase, ltx) : this.handlePessimisticPrepare(m, gtx, modifications, onePhase, ltx);
        }
        finally {
            this.txManager.suspend();
            if (currentTx != null) {
                this.txManager.resume(currentTx);
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Finished remote prepare " + gtx));
            }
        }
        return retval;
    }

    private Object handleNonTxMethod(MethodCall m) throws Throwable {
        Object result;
        boolean implicitTransaction;
        InvocationContext ctx = this.cache.getInvocationContext();
        Transaction tx = ctx.getTransaction();
        boolean bl = implicitTransaction = this.configuration.isNodeLockingOptimistic() && tx == null;
        if (implicitTransaction) {
            tx = this.createLocalTx();
            ctx.setTransaction(tx);
        }
        if (tx != null) {
            m = this.attachGlobalTransaction(tx, m);
        }
        GlobalTransaction gtx = ctx.getGlobalTransaction();
        try {
            result = super.invoke(m);
            if (implicitTransaction) {
                this.copyInvocationScopeOptionsToTxScope(ctx);
                this.txManager.commit();
            }
        }
        catch (Throwable t) {
            if (implicitTransaction) {
                this.log.warn((Object)"Rolling back, exception encountered", t);
                result = t;
                try {
                    this.setTransactionalContext(tx, gtx);
                    this.txManager.rollback();
                }
                catch (Throwable th) {
                    this.log.warn((Object)"Roll back failed encountered", th);
                }
            }
            throw t;
        }
        return result;
    }

    private MethodCall attachGlobalTransaction(Transaction tx, MethodCall m) throws Exception {
        GlobalTransaction gtx;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)(" local transaction exists - registering global tx if not present for " + Thread.currentThread()));
        }
        if (this.log.isTraceEnabled()) {
            GlobalTransaction tempGtx = this.txTable.get(tx);
            this.log.trace((Object)("Associated gtx in txTable is " + tempGtx));
        }
        if ((gtx = this.registerTransaction(tx)) != null) {
            m = this.replaceGtx(m, gtx);
        } else {
            gtx = this.txTable.get(tx);
        }
        this.cache.getInvocationContext().setGlobalTransaction(gtx);
        return m;
    }

    private Object handleOptimisticPrepare(MethodCall m, GlobalTransaction gtx, List<MethodCall> modifications, boolean onePhase, Transaction ltx) throws Throwable {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Handling optimistic remote prepare " + gtx));
        }
        this.replayModifications(modifications, ltx, true);
        Object retval = super.invoke(m);
        if (!this.isActive(ltx)) {
            throw new ReplicationException("prepare() failed -- local transaction status is not STATUS_ACTIVE; is " + ltx.getStatus());
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Object handlePessimisticPrepare(MethodCall m, GlobalTransaction gtx, List<MethodCall> modifications, boolean commit, Transaction ltx) throws Exception {
        boolean success = true;
        try {
            block23: {
                try {
                    this.replayModifications(modifications, ltx, false);
                    if (this.isOnePhaseCommitPrepareMehod(m)) {
                        this.log.trace((Object)"Using one-phase prepare.  Not propagating the prepare call up the stack until called to do so by the sync handler.");
                    } else {
                        super.invoke(m);
                    }
                    if (!this.isActive(ltx)) {
                        throw new ReplicationException("prepare() failed -- local transaction status is not STATUS_ACTIVE; is " + ltx.getStatus());
                    }
                }
                catch (Throwable th) {
                    this.log.error((Object)"prepare method invocation failed", th);
                    Throwable retval = th;
                    success = false;
                    if (!(retval instanceof Exception)) break block23;
                    throw (Exception)retval;
                }
            }
            Object var10_9 = null;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Are we running a 1-phase commit? " + commit));
            }
            if (!commit) throw throwable;
            try {
                if (success) {
                    ltx.commit();
                } else {
                    ltx.rollback();
                }
                this.transactions.remove(ltx);
            }
            catch (Throwable t) {
                try {}
                catch (Throwable throwable2) {
                    this.transactions.remove(ltx);
                    this.remoteTransactions.remove(gtx);
                    throw throwable2;
                }
                this.log.error((Object)"Commit/rollback failed.", t);
                if (success) {
                    try {
                        this.log.info((Object)"Attempting anotehr rollback");
                        ltx.rollback();
                    }
                    catch (Throwable t2) {
                        this.log.error((Object)"Unable to rollback", t2);
                    }
                }
                this.transactions.remove(ltx);
                this.remoteTransactions.remove(gtx);
                throw throwable;
            }
            this.remoteTransactions.remove(gtx);
            throw throwable;
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Are we running a 1-phase commit? " + commit));
        }
        if (!commit) return null;
        try {
            if (success) {
                ltx.commit();
                return null;
            }
            ltx.rollback();
            return null;
        }
        catch (Throwable t) {
            this.log.error((Object)"Commit/rollback failed.", t);
            if (!success) return null;
            try {
                this.log.info((Object)"Attempting anotehr rollback");
                ltx.rollback();
                return null;
            }
            catch (Throwable t2) {
                this.log.error((Object)"Unable to rollback", t2);
            }
            return null;
        }
        finally {
            this.transactions.remove(ltx);
            this.remoteTransactions.remove(gtx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object replayModifications(List<MethodCall> modifications, Transaction tx, boolean injectDataVersions) {
        Object retval = null;
        if (modifications != null) {
            for (MethodCall modification : modifications) {
                try {
                    if (injectDataVersions && !MethodDeclarations.isDataGravitationMethod(modification.getMethodId())) {
                        Object[] origArgs = modification.getArgs();
                        this.injectDataVersion(origArgs[origArgs.length - 1]);
                        Object[] args = new Object[origArgs.length - 1];
                        System.arraycopy(origArgs, 0, args, 0, args.length);
                        retval = super.invoke(MethodCallFactory.create(MethodDeclarations.getUnversionedMethod(modification.getMethodId()), args));
                    } else {
                        retval = super.invoke(modification);
                    }
                    if (!this.isActive(tx)) {
                        throw new ReplicationException("prepare() failed -- local transaction status is not STATUS_ACTIVE; is " + tx.getStatus());
                    }
                }
                catch (Throwable t) {
                    this.log.error((Object)"method invocation failed", t);
                    retval = t;
                }
                finally {
                    if (injectDataVersions) {
                        this.cache.getInvocationContext().setOptionOverrides(null);
                    }
                }
                if (retval == null || !(retval instanceof Exception)) continue;
                if (retval instanceof RuntimeException) {
                    throw (RuntimeException)retval;
                }
                throw new RuntimeException((Exception)retval);
            }
        }
        return retval;
    }

    public void injectDataVersion(Object obj) {
        if (obj instanceof DataVersion) {
            Option o = new Option();
            o.setDataVersion((DataVersion)obj);
            this.cache.getInvocationContext().setOptionOverrides(o);
        } else {
            this.log.debug((Object)("Object " + obj + " is not a DataVersion, not applying to this mod."));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object handleRemoteCommitRollback(MethodCall m, GlobalTransaction gtx) throws Throwable {
        Transaction ltx;
        block17: {
            try {
                ltx = this.getLocalTxForGlobalTx(gtx);
            }
            catch (IllegalStateException e) {
                if (m.getMethodId() == 12) {
                    this.log.warn((Object)"No local transaction for this remotely originating rollback.  Possibly rolling back before a prepare call was broadcast?");
                    return null;
                }
                throw e;
            }
            Transaction currentTx = this.txManager.getTransaction();
            boolean resumeCurrentTxOnCompletion = false;
            try {
                if (!ltx.equals(currentTx)) {
                    currentTx = this.txManager.suspend();
                    resumeCurrentTxOnCompletion = true;
                    this.txManager.resume(ltx);
                    this.cache.getInvocationContext().setTransaction(ltx);
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)(" executing " + (Object)((Object)m) + "() with local TX " + ltx + " under global tx " + gtx));
                }
                if (m.getMethodId() == 11) {
                    this.txManager.commit();
                    if (this.configuration.getExposeManagementStatistics() && this.getStatisticsEnabled()) {
                        ++this.m_commits;
                    }
                } else {
                    this.txManager.rollback();
                    if (this.configuration.getExposeManagementStatistics() && this.getStatisticsEnabled()) {
                        ++this.m_rollbacks;
                    }
                }
                Object var7_7 = null;
                if (!resumeCurrentTxOnCompletion) break block17;
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                if (resumeCurrentTxOnCompletion) {
                    if (this.log.isTraceEnabled()) {
                        this.log.trace((Object)("Resuming suspended transaction " + currentTx));
                    }
                    this.txManager.suspend();
                    if (currentTx != null) {
                        this.txManager.resume(currentTx);
                        this.cache.getInvocationContext().setTransaction(currentTx);
                    }
                }
                this.remoteTransactions.remove(gtx);
                this.transactions.remove(ltx);
                this.txTable.remove(gtx);
                this.txTable.remove(ltx);
                throw throwable;
            }
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Resuming suspended transaction " + currentTx));
            }
            this.txManager.suspend();
            if (currentTx != null) {
                this.txManager.resume(currentTx);
                this.cache.getInvocationContext().setTransaction(currentTx);
            }
        }
        this.remoteTransactions.remove(gtx);
        this.transactions.remove(ltx);
        this.txTable.remove(gtx);
        this.txTable.remove(ltx);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Finished remote commit/rollback method for " + gtx));
        }
        return null;
    }

    private Transaction getLocalTxForGlobalTx(GlobalTransaction gtx) throws IllegalStateException {
        Transaction ltx = this.txTable.getLocalTransaction(gtx);
        if (ltx != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Found local TX=" + ltx + ", global TX=" + gtx));
            }
        } else {
            throw new IllegalStateException(" found no local TX for global TX " + gtx);
        }
        return ltx;
    }

    private Object handleCommitRollback(MethodCall m) throws Throwable {
        GlobalTransaction gtx = this.cache.getInvocationContext().getGlobalTransaction();
        Object result = super.invoke(m);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Finished local commit/rollback method for " + gtx));
        }
        return result;
    }

    protected void runCommitPhase(GlobalTransaction gtx, Transaction tx, List modifications, boolean onePhaseCommit) {
        this.cache.getInvocationContext().setTxHasMods(modifications != null && modifications.size() > 0);
        try {
            MethodCall commitMethod = onePhaseCommit ? (this.configuration.isNodeLockingOptimistic() ? MethodCallFactory.create(MethodDeclarations.optimisticPrepareMethod, gtx, modifications, null, this.cache.getLocalAddress(), true) : MethodCallFactory.create(MethodDeclarations.prepareMethod, gtx, modifications, this.cache.getLocalAddress(), true)) : MethodCallFactory.create(MethodDeclarations.commitMethod, gtx);
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)(" running commit for " + gtx));
            }
            this.handleCommitRollback(commitMethod);
        }
        catch (Throwable e) {
            this.log.warn((Object)"Commit failed.  Clearing stale locks.");
            try {
                this.cleanupStaleLocks(gtx);
            }
            catch (RuntimeException re) {
                this.log.error((Object)"Unable to clear stale locks", (Throwable)re);
                throw re;
            }
            catch (Throwable e2) {
                this.log.error((Object)"Unable to clear stale locks", e2);
                throw new RuntimeException(e2);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException("Commit failed.", e);
        }
    }

    private void cleanupStaleLocks(GlobalTransaction gtx) throws Throwable {
        TransactionEntry entry = this.txTable.get(gtx);
        if (entry != null) {
            entry.releaseAllLocksLIFO(gtx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runRollbackPhase(GlobalTransaction gtx, Transaction tx, List modifications) {
        try {
            this.cache.getInvocationContext().setTxHasMods(modifications != null && modifications.size() > 0);
            MethodCall rollbackMethod = MethodCallFactory.create(MethodDeclarations.rollbackMethod, gtx);
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)(" running rollback for " + gtx));
            }
            this.rollbackTransactions.put(tx, gtx);
            this.handleCommitRollback(rollbackMethod);
        }
        catch (Throwable e) {
            this.log.warn((Object)"Rollback had a problem", e);
        }
        finally {
            if (tx != null) {
                this.rollbackTransactions.remove(tx);
            }
        }
    }

    protected Object runPreparePhase(GlobalTransaction gtx, List modifications) throws Throwable {
        MethodCall prepareMethod;
        if (this.configuration.isNodeLockingOptimistic()) {
            prepareMethod = MethodCallFactory.create(MethodDeclarations.optimisticPrepareMethod, gtx, modifications, null, this.cache.getLocalAddress(), false);
        } else if (this.configuration.getCacheMode() != Configuration.CacheMode.REPL_ASYNC) {
            prepareMethod = MethodCallFactory.create(MethodDeclarations.prepareMethod, gtx, modifications, this.cache.getLocalAddress(), false);
        } else {
            this.log.trace((Object)"This is a REPL_ASYNC call (1 phase commit) - do nothing for beforeCompletion()");
            return null;
        }
        Transaction ltx = this.txTable.getLocalTransaction(gtx);
        if (this.txManager.getTransaction() == null || ltx == null || !this.txManager.getTransaction().equals(ltx)) {
            this.log.warn((Object)("Local transaction does not exist or does not match expected transaction " + gtx));
            throw new CacheException(" local transaction " + ltx + " does not exist or does not match expected transaction " + gtx);
        }
        Object result = super.invoke(prepareMethod);
        return result;
    }

    private GlobalTransaction registerTransaction(Transaction tx) throws Exception {
        GlobalTransaction gtx;
        if (this.isValid(tx) && this.transactions.put(tx, NULL) == null) {
            gtx = this.cache.getCurrentTransaction(tx, true);
            if (gtx.isRemote()) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)"is a remotely initiated gtx so no need to register a tx for it");
                }
            } else {
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("Registering sync handler for tx " + tx + ", gtx " + gtx));
                }
                LocalSynchronizationHandler myHandler = new LocalSynchronizationHandler(gtx, tx, this.cache);
                this.registerHandler(tx, myHandler);
            }
        } else {
            gtx = (GlobalTransaction)this.rollbackTransactions.get(tx);
            if (gtx != null) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Transaction " + tx + " is already registered and is rolling back."));
                }
            } else if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Transaction " + tx + " is already registered."));
            }
        }
        return gtx;
    }

    private void registerHandler(Transaction tx, RemoteSynchronizationHandler handler) throws Exception {
        OrderedSynchronizationHandler orderedHandler = OrderedSynchronizationHandler.getInstance(tx);
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("registering for TX completion: SynchronizationHandler(" + handler + ")"));
        }
        orderedHandler.registerAtHead(handler);
    }

    private MethodCall replaceGtx(MethodCall m, GlobalTransaction gtx) {
        Class<?>[] argClasses = m.getMethod().getParameterTypes();
        Object[] args = m.getArgs();
        for (int i = 0; i < argClasses.length; ++i) {
            if (!argClasses[i].equals(GlobalTransaction.class)) continue;
            if (gtx.equals(args[i])) break;
            args[i] = gtx;
            m.setArgs(args);
            break;
        }
        return m;
    }

    private Transaction createLocalTx() throws Exception {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Creating transaction for thread " + Thread.currentThread()));
        }
        if (this.txManager == null) {
            throw new Exception("Failed to create local transaction; TransactionManager is null");
        }
        this.txManager.begin();
        Transaction localTx = this.txManager.getTransaction();
        return localTx;
    }

    private Transaction createLocalTxForGlobalTx(GlobalTransaction gtx) throws Exception {
        Transaction localTx = this.createLocalTx();
        this.txTable.put(localTx, gtx);
        this.cache.getInvocationContext().setTransaction(localTx);
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Created new tx for gtx " + gtx));
        }
        return localTx;
    }

    class LocalSynchronizationHandler
    extends RemoteSynchronizationHandler {
        private boolean localRollbackOnly;

        LocalSynchronizationHandler(GlobalTransaction gtx, Transaction tx, CacheSPI cache) {
            super(gtx, tx, cache);
            this.localRollbackOnly = true;
        }

        public void beforeCompletion() {
            super.beforeCompletion();
            TxInterceptor.this.setTransactionalContext(this.tx, this.gtx);
            if (this.modifications.size() == 0) {
                if (TxInterceptor.this.log.isTraceEnabled()) {
                    TxInterceptor.this.log.trace((Object)"No modifications in this tx.  Skipping beforeCompletion()");
                }
                return;
            }
            this.cache.getInvocationContext().setOptionOverrides(this.entry.getOption());
            try {
                switch (this.tx.getStatus()) {
                    case 0: 
                    case 7: {
                        Object result = TxInterceptor.this.runPreparePhase(this.gtx, this.modifications);
                        if (result instanceof Throwable) {
                            this.tx.setRollbackOnly();
                            throw (Throwable)result;
                        }
                        break;
                    }
                    default: {
                        throw new CacheException("transaction " + this.tx + " in status " + this.tx.getStatus() + " unbale to start transaction");
                    }
                }
            }
            catch (Throwable t) {
                try {
                    this.tx.setRollbackOnly();
                }
                catch (SystemException se) {
                    throw new RuntimeException("setting tx rollback failed ", se);
                }
                if (t instanceof RuntimeException) {
                    throw (RuntimeException)t;
                }
                throw new RuntimeException("", t);
            }
            finally {
                this.localRollbackOnly = false;
                TxInterceptor.this.setTransactionalContext(null, null);
            }
        }

        public void afterCompletion(int status) {
            this.cache.getInvocationContext().setLocalRollbackOnly(this.localRollbackOnly);
            super.afterCompletion(status);
        }

        public String toString() {
            return "TxInterceptor.LocalSynchronizationHandler(gtx=" + this.gtx + ", tx=" + this.tx + ")";
        }
    }

    class RemoteSynchronizationHandler
    implements Synchronization {
        Transaction tx = null;
        GlobalTransaction gtx = null;
        CacheSPI cache = null;
        List modifications = null;
        TransactionEntry entry = null;

        RemoteSynchronizationHandler(GlobalTransaction gtx, Transaction tx, CacheSPI cache) {
            this.gtx = gtx;
            this.tx = tx;
            this.cache = cache;
        }

        public void beforeCompletion() {
            if (TxInterceptor.this.log.isTraceEnabled()) {
                TxInterceptor.this.log.trace((Object)("Running beforeCompletion on gtx " + this.gtx));
            }
            this.entry = TxInterceptor.this.txTable.get(this.gtx);
            if (this.entry == null) {
                TxInterceptor.this.log.error((Object)"Transaction has a null transaction entry - beforeCompletion() will fail.");
                TxInterceptor.this.log.error((Object)("TxTable contents: " + TxInterceptor.this.txTable));
                throw new IllegalStateException("cannot find transaction entry for " + this.gtx);
            }
            this.modifications = this.entry.getModifications();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void afterCompletion(int status) {
            try {
                TxInterceptor.this.setTransactionalContext(this.tx, this.gtx);
                try {
                    if (TxInterceptor.this.txManager.getTransaction() != null && !TxInterceptor.this.txManager.getTransaction().equals(this.tx)) {
                        TxInterceptor.this.txManager.resume(this.tx);
                    }
                }
                catch (Exception e) {
                    TxInterceptor.this.log.error((Object)("afterCompletion error: " + status), (Throwable)e);
                }
                if (TxInterceptor.this.log.isTraceEnabled()) {
                    TxInterceptor.this.log.trace((Object)("calling aftercompletion for " + this.gtx));
                }
                if ((this.entry = TxInterceptor.this.txTable.get(this.gtx)) != null) {
                    this.modifications = this.entry.getModifications();
                    this.cache.getInvocationContext().setOptionOverrides(this.entry.getOption());
                }
                TxInterceptor.this.transactions.remove(this.tx);
                switch (status) {
                    case 3: {
                        boolean onePhaseCommit;
                        boolean bl = onePhaseCommit = !TxInterceptor.this.configuration.isNodeLockingOptimistic() && TxInterceptor.this.configuration.getCacheMode() == Configuration.CacheMode.REPL_ASYNC;
                        if (TxInterceptor.this.log.isDebugEnabled()) {
                            TxInterceptor.this.log.debug((Object)("Running commit phase.  One phase? " + onePhaseCommit));
                        }
                        TxInterceptor.this.runCommitPhase(this.gtx, this.tx, this.modifications, onePhaseCommit);
                        TxInterceptor.this.log.debug((Object)"Finished commit phase");
                        return;
                    }
                    case 1: 
                    case 4: {
                        TxInterceptor.this.log.debug((Object)"Running rollback phase");
                        TxInterceptor.this.runRollbackPhase(this.gtx, this.tx, this.modifications);
                        TxInterceptor.this.log.debug((Object)"Finished rollback phase");
                        return;
                    }
                    default: {
                        throw new IllegalStateException("illegal status: " + status);
                    }
                }
            }
            finally {
                TxInterceptor.this.txTable.remove(this.gtx);
                TxInterceptor.this.txTable.remove(this.tx);
                TxInterceptor.this.setTransactionalContext(null, null);
            }
        }

        public String toString() {
            return "TxInterceptor.RemoteSynchronizationHandler(gtx=" + this.gtx + ", tx=" + this.tx + ")";
        }
    }
}

