/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.interceptors;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.transaction.Transaction;
import org.jboss.cache.CacheException;
import org.jboss.cache.Fqn;
import org.jboss.cache.InvocationContext;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.interceptors.OptimisticInterceptor;
import org.jboss.cache.marshall.MethodCall;
import org.jboss.cache.marshall.MethodDeclarations;
import org.jboss.cache.optimistic.DataVersioningException;
import org.jboss.cache.optimistic.DefaultDataVersion;
import org.jboss.cache.optimistic.TransactionWorkspace;
import org.jboss.cache.optimistic.WorkspaceNode;
import org.jboss.cache.transaction.GlobalTransaction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OptimisticValidatorInterceptor
extends OptimisticInterceptor {
    @Override
    public Object invoke(MethodCall m) throws Throwable {
        if (MethodDeclarations.isBuddyGroupOrganisationMethod(m.getMethodId())) {
            return super.invoke(m);
        }
        InvocationContext ctx = this.cache.getInvocationContext();
        Transaction tx = ctx.getTransaction();
        GlobalTransaction gtx = ctx.getGlobalTransaction();
        Object retval = null;
        if (tx == null) {
            throw new CacheException("Not in a transaction");
        }
        switch (m.getMethodId()) {
            case 18: {
                this.validateNodes(gtx);
                break;
            }
            case 11: {
                this.commit(gtx);
                break;
            }
            case 12: {
                this.rollBack(gtx);
                break;
            }
            default: {
                retval = super.invoke(m);
            }
        }
        return retval;
    }

    private void validateNodes(GlobalTransaction gtx) throws CacheException {
        TransactionWorkspace workspace;
        try {
            workspace = this.getTransactionWorkspace(gtx);
        }
        catch (CacheException e) {
            throw new CacheException("unable to retrieve workspace", e);
        }
        Collection<WorkspaceNode> nodes = workspace.getNodes().values();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("validating nodes. Num nodes: " + nodes.size()));
        }
        this.simpleValidate(nodes);
        this.log.debug((Object)"validated nodes");
    }

    private void simpleValidate(Collection<WorkspaceNode> nodes) throws DataVersioningException {
        boolean trace = this.log.isTraceEnabled();
        for (WorkspaceNode workspaceNode : nodes) {
            NodeSPI realNode;
            Fqn fqn = workspaceNode.getFqn();
            if (trace) {
                this.log.trace((Object)("Validating version for node " + fqn));
            }
            if ((realNode = this.cache.peek(fqn, true)) == null && !workspaceNode.isCreated()) {
                throw new DataVersioningException("Real node for " + fqn + " is null, and this wasn't newly created in this tx!");
            }
            if (realNode != null && workspaceNode.isCreated()) {
                throw new DataVersioningException("Tx attempted to create " + fqn + " anew.  It has already been created since this tx started by another (possibly remote) tx.");
            }
            if (workspaceNode.isCreated() || !workspaceNode.isDeleted() && !workspaceNode.isDirty() || !realNode.getVersion().newerThan(workspaceNode.getVersion())) continue;
            throw new DataVersioningException("DataNode [" + fqn + "] version " + workspaceNode.getNode().getVersion() + " is newer than workspace node " + workspaceNode.getVersion());
        }
    }

    private void commit(GlobalTransaction gtx) {
        TransactionWorkspace workspace;
        try {
            workspace = this.getTransactionWorkspace(gtx);
        }
        catch (CacheException e) {
            this.log.trace((Object)"we can't rollback", (Throwable)e);
            return;
        }
        this.log.debug((Object)"commiting validated changes ");
        Collection nodes = workspace.getNodes().values();
        boolean trace = this.log.isTraceEnabled();
        for (WorkspaceNode wrappedNode : nodes) {
            if (wrappedNode.isDeleted()) {
                NodeSPI dNode;
                if (trace) {
                    this.log.trace((Object)("Workspace node " + wrappedNode.getFqn() + " deleted; removing"));
                }
                if ((dNode = wrappedNode.getNode()).getFqn().isRoot()) {
                    this.log.warn((Object)"Attempted to delete the root node");
                    continue;
                }
                NodeSPI parent = dNode.getParent();
                if (parent == null) {
                    throw new IllegalStateException("dNode " + dNode + " has no parent");
                }
                parent.removeChildDirect(dNode.getFqn().getLastElement());
                continue;
            }
            NodeSPI current = wrappedNode.getNode();
            boolean updateVersion = false;
            if (wrappedNode.isChildrenModified()) {
                this.log.trace((Object)"Updating children since node has modified children");
                List<Set<Fqn>> deltas = wrappedNode.getMergedChildren();
                if (trace) {
                    this.log.trace((Object)("Applying children deltas to parent node " + current.getFqn()));
                }
                for (Fqn child : deltas.get(0)) {
                    current.addChildDirect(wrappedNode.getChild(child.getLastElement()));
                }
                for (Fqn child : deltas.get(1)) {
                    current.removeChildDirect(child.getLastElement());
                }
                updateVersion = this.cache.getConfiguration().isLockParentForChildInsertRemove();
            }
            if (wrappedNode.isDirty()) {
                this.log.trace((Object)"Merging data since node is dirty");
                Map mergedData = wrappedNode.getMergedData();
                current.clearDataDirect();
                current.putAllDirect(mergedData);
                updateVersion = true;
            }
            if (updateVersion) {
                if (wrappedNode.isVersioningImplicit()) {
                    if (trace) {
                        this.log.trace((Object)"Versioning is implicit; incrementing.");
                    }
                    current.setVersion(((DefaultDataVersion)wrappedNode.getVersion()).increment());
                } else {
                    if (trace) {
                        this.log.trace((Object)"Versioning is explicit; not attempting an increment.");
                    }
                    current.setVersion(wrappedNode.getVersion());
                }
                if (!trace) continue;
                this.log.trace((Object)("Setting version of node " + current.getFqn() + " from " + wrappedNode.getVersion() + " to " + current.getVersion()));
                continue;
            }
            if (!trace) continue;
            this.log.trace((Object)("Version update on " + wrappedNode.getFqn() + " not necessary since the node is not dirty or LockParentForChildInsertRemove is set to false"));
        }
    }

    private void rollBack(GlobalTransaction gtx) {
        try {
            TransactionWorkspace workspace = this.getTransactionWorkspace(gtx);
            Map nodes = workspace.getNodes();
            nodes.clear();
        }
        catch (CacheException e) {
            this.log.info((Object)"Unable to roll back", (Throwable)e);
        }
    }
}

