/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.interceptors;

import java.lang.reflect.Method;
import org.jboss.cache.CacheException;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.InvocationContext;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.interceptors.OptimisticInterceptor;
import org.jboss.cache.lock.NodeLock;
import org.jboss.cache.marshall.MethodCall;
import org.jboss.cache.marshall.MethodDeclarations;
import org.jboss.cache.optimistic.TransactionWorkspace;
import org.jboss.cache.optimistic.WorkspaceNode;
import org.jboss.cache.transaction.GlobalTransaction;
import org.jboss.cache.transaction.TransactionEntry;

public class OptimisticLockingInterceptor
extends OptimisticInterceptor {
    private long lockAcquisitionTimeout;

    public void setCache(CacheSPI cache) {
        super.setCache(cache);
        this.lockAcquisitionTimeout = cache.getConfiguration().getLockAcquisitionTimeout();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object invoke(MethodCall m) throws Throwable {
        if (MethodDeclarations.isBuddyGroupOrganisationMethod(m.getMethodId())) {
            return super.invoke(m);
        }
        InvocationContext ctx = this.cache.getInvocationContext();
        Object retval = null;
        Method meth = m.getMethod();
        if (m.getMethodId() == 33) {
            throw new CacheException("_lock() passed up the interceptor stack when Optimistic Locking is used.  This is NOT supported.");
        }
        if (ctx.getTransaction() == null) throw new CacheException("Not in a transaction");
        if (ctx.getGlobalTransaction() == null) throw new CacheException("Not in a transaction");
        GlobalTransaction gtx = ctx.getGlobalTransaction();
        switch (m.getMethodId()) {
            case 18: {
                try {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("Calling lockNodes() with gtx " + ctx.getGlobalTransaction()));
                    }
                    this.lockNodes(gtx);
                    return super.invoke(m);
                }
                catch (Throwable e) {
                    this.log.debug((Object)"Caught exception attempting to lock nodes ", e);
                    try {
                        this.unlock(gtx);
                        throw e;
                    }
                    catch (Throwable t) {
                        this.log.fatal((Object)"Failed to unlock on prepare ", t);
                    }
                    throw e;
                }
            }
            case 11: 
            case 12: {
                try {
                    retval = super.invoke(m);
                }
                catch (Throwable t) {
                    try {
                        this.log.debug((Object)("exception encountered on " + meth), t);
                        throw t;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.unlock(gtx);
                            throw throwable;
                        }
                        catch (Exception e) {
                            this.log.fatal((Object)("Failed to unlock on " + meth), (Throwable)e);
                        }
                        throw throwable;
                    }
                }
                try {
                    this.unlock(gtx);
                    return retval;
                }
                catch (Exception e) {
                    this.log.fatal((Object)("Failed to unlock on " + meth), (Throwable)e);
                    return retval;
                }
            }
        }
        return super.invoke(m);
    }

    private Object lockNodes(GlobalTransaction gtx) throws Exception {
        TransactionWorkspace workspace = this.getTransactionWorkspace(gtx);
        this.log.debug((Object)"Locking nodes in transaction workspace, presumably for a prepare()");
        for (WorkspaceNode workspaceNode : workspace.getNodes().values()) {
            NodeSPI node = workspaceNode.getNode();
            boolean acquired = node.getLock().acquire(gtx, this.lockAcquisitionTimeout, NodeLock.LockType.WRITE);
            if (acquired) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("Acquired lock on node " + node.getFqn()));
                }
                this.cache.getTransactionTable().addLock(gtx, node.getLock());
                continue;
            }
            throw new CacheException("Unable to acquire lock on node " + node.getFqn());
        }
        return null;
    }

    private void unlock(GlobalTransaction gtx) {
        TransactionEntry entry = this.txTable.get(gtx);
        entry.releaseAllLocksFIFO(gtx);
    }
}

