/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.interceptors;

import java.util.List;
import javax.transaction.TransactionManager;
import org.jboss.cache.CacheException;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.interceptors.Interceptor;
import org.jboss.cache.optimistic.TransactionWorkspace;
import org.jboss.cache.transaction.GlobalTransaction;
import org.jboss.cache.transaction.OptimisticTransactionEntry;
import org.jboss.cache.transaction.TransactionTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OptimisticInterceptor
extends Interceptor {
    protected TransactionManager txManager = null;
    protected TransactionTable txTable = null;

    @Override
    public void setCache(CacheSPI cache) {
        super.setCache(cache);
        this.txManager = cache.getTransactionManager();
        this.txTable = cache.getTransactionTable();
    }

    protected TransactionWorkspace getTransactionWorkspace(GlobalTransaction gtx) throws CacheException {
        OptimisticTransactionEntry transactionEntry = (OptimisticTransactionEntry)this.txTable.get(gtx);
        if (transactionEntry == null) {
            throw new CacheException("unable to map global transaction " + gtx + " to transaction entry");
        }
        return transactionEntry.getTransactionWorkSpace();
    }

    protected void greedyGetFqns(List<Fqn> list, NodeSPI<?, ?> n, Fqn newBase) {
        list.add(n.getFqn());
        Fqn<Object> newFqn = new Fqn<Object>(newBase, n.getFqn().getLastElement());
        list.add(newFqn);
        for (NodeSPI<?, ?> child : n.getChildrenDirect()) {
            this.greedyGetFqns(list, child, newFqn);
        }
    }
}

