/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.interceptors;

import java.util.ArrayList;
import org.jboss.cache.CacheException;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;
import org.jboss.cache.InvocationContext;
import org.jboss.cache.NodeFactory;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.interceptors.OptimisticInterceptor;
import org.jboss.cache.marshall.MethodCall;
import org.jboss.cache.marshall.MethodDeclarations;
import org.jboss.cache.notifications.Notifier;
import org.jboss.cache.optimistic.DataVersion;
import org.jboss.cache.optimistic.DefaultDataVersion;
import org.jboss.cache.optimistic.TransactionWorkspace;
import org.jboss.cache.optimistic.WorkspaceNode;
import org.jboss.cache.transaction.GlobalTransaction;
import org.jboss.cache.transaction.OptimisticTransactionEntry;
import org.jboss.cache.transaction.TransactionEntry;

public class OptimisticCreateIfNotExistsInterceptor
extends OptimisticInterceptor {
    private NodeFactory nodeFactory;

    public void setCache(CacheSPI cache) {
        super.setCache(cache);
        this.nodeFactory = cache.getConfiguration().getRuntimeConfig().getNodeFactory();
    }

    public Object invoke(MethodCall m) throws Throwable {
        if (MethodDeclarations.isPutMethod(m.getMethodId())) {
            Object[] args = m.getArgs();
            Fqn fqn = (Fqn)(args != null ? args[1] : null);
            if (this.cache.peek(fqn, false) == null) {
                this.createNode(fqn, false);
            }
        } else if (m.getMethodId() == 36) {
            Object[] args = m.getArgs();
            this.move((Fqn)args[0], (Fqn)args[1]);
        }
        return super.invoke(m);
    }

    private void move(Fqn nodeFqn, Fqn newParent) {
        ArrayList<Fqn> fqns = new ArrayList<Fqn>();
        fqns.add(newParent);
        NodeSPI node = this.cache.peek(nodeFqn, true);
        this.greedyGetFqns(fqns, node, newParent);
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Adding Fqns to workspace " + fqns));
        }
        for (Fqn f : fqns) {
            if (this.cache.peek(f, false) != null) continue;
            this.createNode(f, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void createNode(Fqn fqn, boolean suppressNotification) throws CacheException {
        if (fqn == null) {
            return;
        }
        GlobalTransaction gtx = this.cache.getInvocationContext().getGlobalTransaction();
        TransactionEntry baseTransactionEntry = this.txTable.get(gtx);
        OptimisticTransactionEntry transactionEntry = (OptimisticTransactionEntry)baseTransactionEntry;
        if (transactionEntry == null) {
            throw new CacheException("Unable to map global transaction " + gtx + " to transaction entry");
        }
        ArrayList<Fqn<Object>> nodesCreated = new ArrayList<Fqn<Object>>();
        int treeNodeSize = fqn.size();
        InvocationContext ctx = this.cache.getInvocationContext();
        TransactionWorkspace workspace = transactionEntry.getTransactionWorkSpace();
        boolean debug = this.log.isDebugEnabled();
        TransactionWorkspace transactionWorkspace = workspace;
        synchronized (transactionWorkspace) {
            DataVersion version = null;
            if (ctx.getOptionOverrides() != null && ctx.getOptionOverrides().getDataVersion() != null) {
                version = ctx.getOptionOverrides().getDataVersion();
                workspace.setVersioningImplicit(false);
            }
            WorkspaceNode workspaceNode = workspace.getNode(Fqn.ROOT);
            if (debug) {
                this.log.debug((Object)("Global TX: " + gtx + "  Root: " + workspaceNode));
            }
            if (workspaceNode == null) {
                NodeSPI nodeSPI = this.cache.getRoot();
                workspaceNode = this.nodeFactory.createWorkspaceNode(nodeSPI, workspace);
                workspace.addNode(workspaceNode);
                if (debug) {
                    this.log.debug((Object)("Created root node: " + workspaceNode));
                }
            } else if (debug) {
                this.log.debug((Object)("Found root node: " + workspaceNode));
            }
            Fqn fqn2 = Fqn.ROOT;
            for (int i = 0; i < treeNodeSize; ++i) {
                WorkspaceNode childWorkspaceNode;
                NodeSPI tempchildNode;
                void var16_16;
                boolean isTargetFqn = i == treeNodeSize - 1;
                Object childName = fqn.get(i);
                Fqn<Object> fqn3 = new Fqn<Object>((Fqn<Object>)var16_16, (E[])new Object[]{childName});
                if (debug) {
                    this.log.debug((Object)("workspaceNode.getChild(" + childName + ")"));
                }
                if ((tempchildNode = workspaceNode.getChild(new Fqn<Object>(childName))) == null) {
                    WorkspaceNode tempCheckWrapper;
                    if (debug) {
                        this.log.debug((Object)"Creating new child, doesn't exist");
                    }
                    if ((tempCheckWrapper = workspace.getNode(workspaceNode.getFqn())) == null || tempCheckWrapper.isDeleted()) {
                        if (debug) {
                            this.log.debug((Object)"Parent node doesn't exist in workspace or has been deleted.  Adding to workspace.");
                        }
                        workspace.addNode(workspaceNode);
                        if (!(workspaceNode.getVersion() instanceof DefaultDataVersion)) {
                            workspaceNode.setVersioningImplicit(false);
                        }
                    } else if (debug) {
                        this.log.debug((Object)("Parent node exists: " + workspaceNode));
                    }
                    DataVersion versionToPassIn = null;
                    if (isTargetFqn && !workspace.isVersioningImplicit()) {
                        versionToPassIn = version;
                    }
                    NodeSPI tempNode = workspaceNode.createChild(childName, workspaceNode.getNode(), this.cache, versionToPassIn);
                    childWorkspaceNode = this.nodeFactory.createWorkspaceNode(tempNode, workspace);
                    childWorkspaceNode.setVersioningImplicit(versionToPassIn == null || !isTargetFqn);
                    if (this.log.isTraceEnabled()) {
                        this.log.trace((Object)("setting versioning of " + childWorkspaceNode.getFqn() + " to be " + (childWorkspaceNode.isVersioningImplicit() ? "implicit" : "explicit")));
                    }
                    workspace.addNode(childWorkspaceNode);
                    childWorkspaceNode.markAsCreated();
                    nodesCreated.add(fqn3);
                } else {
                    childWorkspaceNode = workspace.getNode(tempchildNode.getFqn());
                    if (childWorkspaceNode == null || childWorkspaceNode.isDeleted()) {
                        if (debug) {
                            this.log.debug((Object)("Child node " + tempchildNode.getFqn() + " doesn't exist in workspace or has been deleted.  Adding to workspace in gtx " + gtx));
                        }
                        childWorkspaceNode = this.nodeFactory.createWorkspaceNode(tempchildNode, workspace);
                        if (isTargetFqn && !workspace.isVersioningImplicit()) {
                            childWorkspaceNode.setVersion(version);
                            childWorkspaceNode.setVersioningImplicit(false);
                        } else {
                            childWorkspaceNode.setVersioningImplicit(true);
                        }
                        if (this.log.isTraceEnabled()) {
                            this.log.trace((Object)("setting versioning of " + childWorkspaceNode.getFqn() + " to be " + (childWorkspaceNode.isVersioningImplicit() ? "implicit" : "explicit")));
                        }
                    } else if (debug) {
                        this.log.debug((Object)("Found child node: " + tempchildNode));
                    }
                }
                workspaceNode = childWorkspaceNode;
            }
        }
        if (debug) {
            this.log.debug((Object)"done synchronized access of GlobalTX");
        }
        if (!suppressNotification && nodesCreated.size() > 0) {
            Notifier n = this.cache.getNotifier();
            for (Fqn fqn4 : nodesCreated) {
                n.notifyNodeCreated(fqn4, true, false);
                n.notifyNodeCreated(fqn4, false, false);
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug((Object)("Notifying cache of node created in workspace " + fqn4));
            }
        }
    }
}

