/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.interceptors;

import java.util.List;
import org.jboss.cache.InvocationContext;
import org.jboss.cache.interceptors.BaseTransactionalContextInterceptor;
import org.jboss.cache.marshall.MethodCall;
import org.jboss.cache.marshall.MethodDeclarations;
import org.jboss.cache.notifications.Notifier;
import org.jboss.cache.transaction.TransactionEntry;

public class NotificationInterceptor
extends BaseTransactionalContextInterceptor {
    public Object invoke(MethodCall call) throws Throwable {
        Object retval = super.invoke(call);
        InvocationContext ctx = this.cache.getInvocationContext();
        Notifier n = this.cache.getNotifier();
        if (ctx.getGlobalTransaction() != null) {
            if (MethodDeclarations.isTransactionLifecycleMethod(call.getMethodId())) {
                if (call.getMethodId() == 11) {
                    List<MethodCall> events = ctx.getCacheListenerEvents();
                    TransactionEntry entry = this.txTable.get(ctx.getGlobalTransaction());
                    if (entry != null) {
                        entry.addCacheListenerEvents(events);
                        if (this.log.isTraceEnabled()) {
                            this.log.trace((Object)("Invoking notifications for this transaction.  Notification set: " + entry.getCacheListenerEvents()));
                        }
                        n.invokeQueuedNotifications(entry.getCacheListenerEvents());
                    } else {
                        this.log.trace((Object)"Committing but cache entry is null.");
                    }
                }
            } else {
                List<MethodCall> events = ctx.getCacheListenerEvents();
                TransactionEntry entry = this.txTable.get(ctx.getGlobalTransaction());
                if (entry == null) {
                    this.log.warn((Object)("Transaction entry for " + ctx.getGlobalTransaction() + " is null?"));
                } else {
                    if (this.log.isTraceEnabled()) {
                        this.log.trace((Object)("Adding " + events + " to transaction entry's notification list"));
                    }
                    entry.addCacheListenerEvents(events);
                    ctx.clearCacheListenerEvents();
                }
            }
        } else {
            n.invokeQueuedNotifications();
        }
        return retval;
    }
}

