/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.interceptors;

import javax.transaction.Transaction;
import org.jboss.cache.CacheImpl;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.InvocationContext;
import org.jboss.cache.config.Option;
import org.jboss.cache.interceptors.Interceptor;
import org.jboss.cache.marshall.MethodCall;
import org.jboss.cache.marshall.MethodDeclarations;
import org.jboss.cache.transaction.GlobalTransaction;

public class CallInterceptor
extends Interceptor {
    private CacheImpl cache;

    public void setCache(CacheSPI cache) {
        super.setCache(cache);
    }

    public void setTreeCacheInstance(CacheImpl c) {
        this.cache = c;
    }

    public Object invoke(MethodCall m) throws Throwable {
        InvocationContext ctx;
        Transaction tx;
        Object retval = null;
        if (!MethodDeclarations.isTransactionLifecycleMethod(m.getMethodId())) {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Passing up method " + (Object)((Object)m) + " so it gets invoked on cache."));
            }
            try {
                retval = m.invoke(this.cache);
            }
            catch (Throwable t) {
                retval = t;
            }
        } else if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Suppressing invocation of method " + (Object)((Object)m) + " on cache."));
        }
        if ((tx = (ctx = this.cache.getInvocationContext()).getTransaction()) != null && this.isValid(tx)) {
            if (retval instanceof Throwable) {
                tx.setRollbackOnly();
            } else if (!this.configuration.isNodeLockingOptimistic() && MethodDeclarations.isCrudMethod(m.getMethodId())) {
                GlobalTransaction gtx = ctx.getGlobalTransaction();
                if (gtx == null) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("didn't find GlobalTransaction for " + tx + "; won't add modification to transaction list"));
                    }
                } else {
                    Option o = this.cache.getInvocationContext().getOptionOverrides();
                    if (o != null && o.isCacheModeLocal()) {
                        this.log.debug((Object)"Not adding method to modification list since cache mode local is set.");
                    } else {
                        this.cache.getTransactionTable().addModification(gtx, m);
                    }
                    if (this.cache.getCacheLoaderManager() != null) {
                        this.cache.getTransactionTable().addCacheLoaderModification(gtx, m);
                    }
                }
            }
        }
        if (retval instanceof Throwable) {
            throw (Throwable)retval;
        }
        return retval;
    }
}

