/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.interceptors;

import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.InvocationContext;
import org.jboss.cache.config.Option;
import org.jboss.cache.interceptors.Interceptor;
import org.jboss.cache.transaction.GlobalTransaction;
import org.jboss.cache.transaction.TransactionEntry;
import org.jboss.cache.transaction.TransactionTable;

public abstract class BaseTransactionalContextInterceptor
extends Interceptor {
    protected TransactionTable txTable;
    protected TransactionManager txManager;

    public void setCache(CacheSPI cache) {
        super.setCache(cache);
        this.txManager = cache.getTransactionManager();
        this.txTable = cache.getTransactionTable();
    }

    protected void copyInvocationScopeOptionsToTxScope(InvocationContext ctx) {
        TransactionEntry entry = this.txTable.get(ctx.getGlobalTransaction());
        if (entry != null) {
            Option txScopeOption = new Option();
            txScopeOption.setCacheModeLocal(ctx.getOptionOverrides() != null && ctx.getOptionOverrides().isCacheModeLocal());
            entry.setOption(txScopeOption);
        }
    }

    protected void setTransactionalContext(Transaction tx, GlobalTransaction gtx) {
        InvocationContext ctx = this.cache.getInvocationContext();
        this.log.trace((Object)"Setting up transactional context.");
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Setting tx as " + tx + " and gtx as " + gtx));
        }
        ctx.setTransaction(tx);
        ctx.setGlobalTransaction(gtx);
    }

    protected boolean isRollingBack(Transaction tx) {
        if (tx == null) {
            return false;
        }
        int status = -1;
        try {
            status = tx.getStatus();
            return status == 9 || status == 4;
        }
        catch (SystemException e) {
            this.log.error((Object)"failed getting transaction status", (Throwable)e);
            return false;
        }
    }
}

