/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.loader;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.rmi.MarshalledObject;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.Modification;
import org.jboss.cache.TreeCache;
import org.jboss.cache.loader.CacheLoader;
import org.jboss.cache.loader.NodeData;
import org.jboss.cache.lock.StripedLock;
import org.jboss.invocation.MarshalledValue;
import org.jboss.invocation.MarshalledValueInputStream;
import org.jboss.invocation.MarshalledValueOutputStream;

public class JDBCCacheLoader
implements CacheLoader {
    private static final Log log = LogFactory.getLog((Class)JDBCCacheLoader.class);
    private static final ThreadLocal connection = new ThreadLocal();
    private String driverName;
    private String drv;
    private String table;
    private String selectChildNamesSql;
    private String deleteNodeSql;
    private String deleteAllSql;
    private String selectChildFqnsSql;
    private String insertNodeSql;
    private String updateNodeSql;
    private String selectNodeSql;
    private String createTableDdl;
    private String dropTableDdl;
    private boolean createTable;
    private boolean dropTable;
    private String datasourceName;
    private ConnectionFactory cf;
    protected StripedLock lock = new StripedLock();
    private static final Map NULL_NODE_IN_ROW = new Map(){

        public int size() {
            throw new UnsupportedOperationException();
        }

        public void clear() {
            throw new UnsupportedOperationException();
        }

        public boolean isEmpty() {
            throw new UnsupportedOperationException();
        }

        public boolean containsKey(Object key) {
            throw new UnsupportedOperationException();
        }

        public boolean containsValue(Object value) {
            throw new UnsupportedOperationException();
        }

        public Collection values() {
            throw new UnsupportedOperationException();
        }

        public void putAll(Map t) {
            throw new UnsupportedOperationException();
        }

        public Set entrySet() {
            throw new UnsupportedOperationException();
        }

        public Set keySet() {
            throw new UnsupportedOperationException();
        }

        public Object get(Object key) {
            throw new UnsupportedOperationException();
        }

        public Object remove(Object key) {
            throw new UnsupportedOperationException();
        }

        public Object put(Object key, Object value) {
            throw new UnsupportedOperationException();
        }
    };

    public void setConfig(Properties props) {
        String prop;
        this.datasourceName = props.getProperty("cache.jdbc.datasource");
        if (this.datasourceName == null) {
            this.drv = JDBCCacheLoader.getRequiredProperty(props, "cache.jdbc.driver");
            String jdbcUrl = JDBCCacheLoader.getRequiredProperty(props, "cache.jdbc.url");
            String jdbcUsr = JDBCCacheLoader.getRequiredProperty(props, "cache.jdbc.user");
            String jdbcPwd = JDBCCacheLoader.getRequiredProperty(props, "cache.jdbc.password");
            if (log.isDebugEnabled()) {
                log.debug((Object)("Properties: cache.jdbc.url=" + jdbcUrl + ", cache.jdbc.driver=" + this.drv + ", cache.jdbc.user=" + jdbcUsr + ", cache.jdbc.password=" + jdbcPwd + ", cache.jdbc.table=" + this.table));
            }
            this.cf = new NonManagedConnectionFactory(jdbcUrl, jdbcUsr, jdbcPwd);
        }
        this.createTable = (prop = props.getProperty("cache.jdbc.table.create")) == null || Boolean.valueOf(prop) != false;
        prop = props.getProperty("cache.jdbc.table.drop");
        this.dropTable = prop == null || Boolean.valueOf(prop) != false;
        this.table = props.getProperty("cache.jdbc.table.name", "jbosscache");
        String primaryKey = props.getProperty("cache.jdbc.table.primarykey", "jbosscache_pk");
        String fqnColumn = props.getProperty("cache.jdbc.fqn.column", "fqn");
        String fqnType = props.getProperty("cache.jdbc.fqn.type", "varchar(255)");
        String nodeColumn = props.getProperty("cache.jdbc.node.column", "node");
        String nodeType = props.getProperty("cache.jdbc.node.type", "blob");
        String parentColumn = props.getProperty("cache.jdbc.parent.column", "parent");
        this.selectChildNamesSql = "select " + fqnColumn + " from " + this.table + " where " + parentColumn + "=?";
        this.deleteNodeSql = "delete from " + this.table + " where " + fqnColumn + "=?";
        this.deleteAllSql = "delete from " + this.table;
        this.selectChildFqnsSql = "select " + fqnColumn + " from " + this.table + " where " + parentColumn + "=?";
        this.insertNodeSql = "insert into " + this.table + " (" + fqnColumn + ", " + nodeColumn + ", " + parentColumn + ") values (?, ?, ?)";
        this.updateNodeSql = "update " + this.table + " set " + nodeColumn + "=? where " + fqnColumn + "=?";
        this.selectNodeSql = "select " + nodeColumn + " from " + this.table + " where " + fqnColumn + "=?";
        this.createTableDdl = "create table " + this.table + "(" + fqnColumn + " " + fqnType + " not null, " + nodeColumn + " " + nodeType + ", " + parentColumn + " " + fqnType + ", constraint " + primaryKey + " primary key (" + fqnColumn + "))";
        this.dropTableDdl = "drop table " + this.table;
    }

    public void setCache(TreeCache c) {
    }

    public Set getChildrenNames(Fqn fqn) throws Exception {
        HashSet<String> children = null;
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            block6: {
                try {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("executing sql: " + this.selectChildNamesSql + " (" + fqn + ")"));
                    }
                    con = this.cf.getConnection();
                    ps = con.prepareStatement(this.selectChildNamesSql);
                    ps.setString(1, fqn.toString());
                    this.lock.acquireLock(fqn, false);
                    rs = ps.executeQuery();
                    if (!rs.next()) break block6;
                    children = new HashSet<String>();
                    do {
                        String child = rs.getString(1);
                        int slashInd = child.lastIndexOf(47);
                        String name = child.substring(slashInd + 1);
                        children.add(name);
                    } while (rs.next());
                }
                catch (SQLException e) {
                    log.error((Object)("Failed to get children names for fqn " + fqn), (Throwable)e);
                    throw new IllegalStateException("Failed to get children names for fqn " + fqn + ": " + e.getMessage());
                }
            }
            Object var10_10 = null;
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            JDBCCacheLoader.safeClose(rs);
            JDBCCacheLoader.safeClose(ps);
            this.cf.close(con);
            this.lock.releaseLock(fqn);
            throw throwable;
        }
        JDBCCacheLoader.safeClose(rs);
        JDBCCacheLoader.safeClose(ps);
        this.cf.close(con);
        this.lock.releaseLock(fqn);
        return children == null ? null : Collections.unmodifiableSet(children);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map get(Fqn name) throws Exception {
        this.lock.acquireLock(name, false);
        try {
            Map node = this.loadNode(name);
            Map map = node == NULL_NODE_IN_ROW ? new HashMap(0) : node;
            return map;
        }
        finally {
            this.lock.releaseLock(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exists(Fqn name) throws Exception {
        this.lock.acquireLock(name, false);
        try {
            Map node = this.loadNode(name);
            boolean bl = node != null;
            return bl;
        }
        finally {
            this.lock.releaseLock(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object put(Fqn name, Object key, Object value) throws Exception {
        this.lock.acquireLock(name, true);
        try {
            Map oldNode = this.loadNode(name);
            Map node = oldNode == null || oldNode == NULL_NODE_IN_ROW ? new HashMap() : oldNode;
            Object oldValue = node.put(key, value);
            if (oldNode != null) {
                this.updateNode(name, node);
            } else {
                if (name.size() > 1) {
                    for (int i = 1; i < name.size(); ++i) {
                        Fqn parent = name.getFqnChild(i);
                        if (this.exists(parent)) continue;
                        this.insertNode(parent, null);
                    }
                }
                this.insertNode(name, node);
            }
            Object object = oldValue;
            return object;
        }
        finally {
            this.lock.releaseLock(name);
        }
    }

    public void put(Fqn name, Map attributes) throws Exception {
        this.put(name, attributes, false);
    }

    public void put(List modifications) throws Exception {
        block8: for (int i = 0; i < modifications.size(); ++i) {
            Modification m = (Modification)modifications.get(i);
            switch (m.getType()) {
                case 2: {
                    this.put(m.getFqn(), m.getData());
                    continue block8;
                }
                case 3: {
                    this.put(m.getFqn(), m.getData(), true);
                    continue block8;
                }
                case 1: {
                    this.put(m.getFqn(), m.getKey(), m.getValue());
                    continue block8;
                }
                case 6: {
                    this.removeData(m.getFqn());
                    continue block8;
                }
                case 5: {
                    this.remove(m.getFqn(), m.getKey());
                    continue block8;
                }
                case 4: {
                    this.remove(m.getFqn());
                    continue block8;
                }
                default: {
                    throw new IllegalStateException("Unexpected modification code: " + m.getType());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object remove(Fqn name, Object key) throws Exception {
        this.lock.acquireLock(name, true);
        try {
            Object removedValue = null;
            Map node = this.loadNode(name);
            if (node != null && node != NULL_NODE_IN_ROW) {
                removedValue = node.remove(key);
                if (node.isEmpty()) {
                    this.updateNode(name, null);
                } else {
                    this.updateNode(name, node);
                }
            }
            Object var5_5 = removedValue;
            return var5_5;
        }
        finally {
            this.lock.releaseLock(name);
        }
    }

    public void remove(Fqn name) throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        try {
            block12: {
                try {
                    if (name.size() == 0) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("executing sql: " + this.deleteAllSql));
                        }
                        con = this.cf.getConnection();
                        ps = con.prepareStatement(this.deleteAllSql);
                        this.lock.acquireLock(name, true);
                        int deletedRows = ps.executeUpdate();
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("total rows deleted: " + deletedRows));
                        }
                        break block12;
                    }
                    StringBuffer sql = new StringBuffer(300);
                    sql.append("delete from ").append(this.table).append(" where fqn in (");
                    ArrayList fqns = new ArrayList();
                    this.addChildrenToDeleteSql(name.toString(), sql, fqns);
                    sql.append(')');
                    if (fqns.size() == 1) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("executing sql: " + this.deleteNodeSql + "(" + name + ")"));
                        }
                        con = this.cf.getConnection();
                        ps = con.prepareStatement(this.deleteNodeSql);
                        ps.setString(1, name.toString());
                    } else {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("executing sql: " + sql + " " + fqns));
                        }
                        con = this.cf.getConnection();
                        ps = con.prepareStatement(sql.toString());
                        for (int i = 0; i < fqns.size(); ++i) {
                            ps.setString(i + 1, (String)fqns.get(i));
                        }
                    }
                    this.lock.acquireLock(name, true);
                    int deletedRows = ps.executeUpdate();
                    if (!log.isDebugEnabled()) break block12;
                    log.debug((Object)("total rows deleted: " + deletedRows));
                }
                catch (SQLException e) {
                    log.error((Object)("Failed to remove node " + name), (Throwable)e);
                    throw new IllegalStateException("Failed to remove node " + name + ": " + e.getMessage());
                }
            }
            Object var8_9 = null;
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            JDBCCacheLoader.safeClose(ps);
            this.cf.close(con);
            this.lock.releaseLock(name);
            throw throwable;
        }
        JDBCCacheLoader.safeClose(ps);
        this.cf.close(con);
        this.lock.releaseLock(name);
    }

    public void removeData(Fqn name) throws Exception {
        this.updateNode(name, null);
    }

    public void prepare(Object tx, List modifications, boolean one_phase) throws Exception {
        if (this.cf instanceof NonManagedConnectionFactory) {
            Connection con = this.cf.prepare(tx);
            if (log.isTraceEnabled()) {
                log.trace((Object)("openned tx connection: tx=" + tx + ", con=" + con));
            }
        }
        try {
            this.put(modifications);
            if (one_phase) {
                this.commit(tx);
            }
        }
        catch (Exception e) {
            this.rollback(tx);
            throw e;
        }
    }

    public void commit(Object tx) throws Exception {
        this.cf.commit(tx);
    }

    public void rollback(Object tx) {
        this.cf.rollback(tx);
    }

    public byte[] loadEntireState() throws Exception {
        ByteArrayOutputStream out_stream = new ByteArrayOutputStream(1024);
        MarshalledValueOutputStream out = new MarshalledValueOutputStream((OutputStream)out_stream);
        this.loadState(Fqn.fromString("/"), (ObjectOutputStream)out);
        out.close();
        return out_stream.toByteArray();
    }

    public void storeEntireState(byte[] state) throws Exception {
        ByteArrayInputStream in_stream = new ByteArrayInputStream(state);
        MarshalledValueInputStream in = new MarshalledValueInputStream((InputStream)in_stream);
        this.remove(Fqn.fromString("/"));
        try {
            while (true) {
                NodeData nd = (NodeData)in.readObject();
                if (nd.attrs != null) {
                    this.put(nd.fqn, nd.attrs, true);
                    continue;
                }
                this.put(nd.fqn, null);
            }
        }
        catch (EOFException eof_ex) {
            return;
        }
    }

    public void create() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void start() throws Exception {
        block16: {
            if (this.drv != null) {
                JDBCCacheLoader.loadDriver(this.drv);
            } else {
                ctx = null;
                try {
                    ctx = new InitialContext();
                    dataSource = (DataSource)ctx.lookup(this.datasourceName);
                    this.cf = new ManagedConnectionFactory(dataSource);
                    var4_4 = null;
                    ** if (ctx == null) goto lbl-1000
                }
                catch (Throwable var3_8) {
                    var4_5 = null;
                    if (ctx != null) {
                        try {
                            ctx.close();
                        }
                        catch (NamingException e) {
                            JDBCCacheLoader.log.warn((Object)"Failed to close naming context.", (Throwable)e);
                        }
                    }
                    throw var3_8;
                }
lbl-1000:
                // 1 sources

                {
                    try {
                        ctx.close();
                    }
                    catch (NamingException e) {
                        JDBCCacheLoader.log.warn((Object)"Failed to close naming context.", (Throwable)e);
                    }
                }
lbl-1000:
                // 2 sources

                {
                    break block16;
                    catch (NamingException e) {
                        JDBCCacheLoader.log.error((Object)("Failed to lookup datasource " + this.datasourceName + ": " + e.getMessage()), (Throwable)e);
                        throw new IllegalStateException("Failed to lookup datasource " + this.datasourceName + ": " + e.getMessage());
                    }
                }
            }
        }
        con = null;
        st = null;
        try {
            con = this.cf.getConnection();
            this.driverName = JDBCCacheLoader.getDriverName(con);
            if (this.createTable && !JDBCCacheLoader.tableExists(this.table, con)) {
                if (JDBCCacheLoader.log.isDebugEnabled()) {
                    JDBCCacheLoader.log.debug((Object)("executing ddl: " + this.createTableDdl));
                }
                st = con.createStatement();
                st.executeUpdate(this.createTableDdl);
            }
        }
        finally {
            JDBCCacheLoader.safeClose(st);
            this.cf.close(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        if (this.dropTable) {
            Connection con = null;
            Statement st = null;
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("executing ddl: " + this.dropTableDdl));
                }
                con = this.cf.getConnection();
                st = con.createStatement();
                st.executeUpdate(this.dropTableDdl);
                JDBCCacheLoader.safeClose(st);
            }
            catch (SQLException e) {
                try {
                    log.error((Object)("Failed to drop table: " + e.getMessage()), (Throwable)e);
                }
                catch (Throwable throwable) {
                    JDBCCacheLoader.safeClose(st);
                    this.cf.close(con);
                    throw throwable;
                }
                JDBCCacheLoader.safeClose(st);
                this.cf.close(con);
            }
            JDBCCacheLoader.safeClose(st);
            this.cf.close(con);
        }
    }

    public void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addChildrenToDeleteSql(String name, StringBuffer sql, List fqns) throws SQLException {
        Connection con = null;
        PreparedStatement selChildrenPs = null;
        ResultSet rs = null;
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("executing sql: " + this.selectChildFqnsSql + "(" + name + ")"));
            }
            con = this.cf.getConnection();
            selChildrenPs = con.prepareStatement(this.selectChildFqnsSql);
            selChildrenPs.setString(1, name);
            rs = selChildrenPs.executeQuery();
            if (rs.next()) {
                do {
                    String childStr = rs.getString(1);
                    this.addChildrenToDeleteSql(childStr, sql, fqns);
                } while (rs.next());
            }
            if (fqns.size() == 0) {
                sql.append("?");
            } else {
                sql.append(", ?");
            }
            fqns.add(name);
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            JDBCCacheLoader.safeClose(rs);
            JDBCCacheLoader.safeClose(selChildrenPs);
            this.cf.close(con);
            throw throwable;
        }
        JDBCCacheLoader.safeClose(rs);
        JDBCCacheLoader.safeClose(selChildrenPs);
        this.cf.close(con);
    }

    protected void loadState(Fqn fqn, ObjectOutputStream out) throws Exception {
        Map attrs = this.get(fqn);
        NodeData nd = attrs == null || attrs.size() == 0 ? new NodeData(fqn) : new NodeData(fqn, attrs);
        out.writeObject(nd);
        Set children_names = this.getChildrenNames(fqn);
        if (children_names == null) {
            return;
        }
        Iterator it = children_names.iterator();
        while (it.hasNext()) {
            String child_name = (String)it.next();
            Fqn tmp_fqn = new Fqn(fqn, child_name);
            this.loadState(tmp_fqn, out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void put(Fqn name, Map attributes, boolean override) throws Exception {
        HashMap attrs = attributes == null ? null : new HashMap(attributes);
        this.lock.acquireLock(name, true);
        try {
            Map oldNode = this.loadNode(name);
            if (oldNode != null) {
                if (!override && oldNode != NULL_NODE_IN_ROW && attrs != null) {
                    attrs.putAll(oldNode);
                }
                this.updateNode(name, attrs);
            } else {
                if (name.size() > 1) {
                    for (int i = 1; i < name.size(); ++i) {
                        Fqn parent = name.getFqnChild(i);
                        if (this.exists(parent)) continue;
                        this.insertNode(parent, null);
                    }
                }
                this.insertNode(name, attrs);
            }
        }
        finally {
            this.lock.releaseLock(name);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void insertNode(Fqn name, Map node) {
        Connection con = null;
        PreparedStatement ps = null;
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("executing sql: " + this.insertNodeSql + " (" + name + ")"));
            }
            con = this.cf.getConnection();
            ps = con.prepareStatement(this.insertNodeSql);
            ps.setString(1, name.toString());
            if (node != null) {
                MarshalledValue marshalledNode = new MarshalledValue((Object)node);
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                ObjectOutputStream oos = new ObjectOutputStream(baos);
                oos.writeObject(marshalledNode);
                ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
                ps.setBinaryStream(2, (InputStream)bais, baos.size());
            } else if (this.driverName != null && (this.driverName.indexOf("SQLSERVER") >= 0 || this.driverName.indexOf("POSTGRESQL") >= 0)) {
                ps.setNull(2, -4);
            } else {
                ps.setNull(2, 2004);
            }
            if (name.size() == 0) {
                ps.setNull(3, 12);
            } else {
                ps.setString(3, name.getFqnChild(name.size() - 1).toString());
            }
            int rows = ps.executeUpdate();
            if (rows != 1) {
                throw new IllegalStateException("Expected one insert row but got " + rows);
            }
        }
        catch (RuntimeException e) {
            try {
                throw e;
                catch (Exception e2) {
                    log.error((Object)("Failed to insert node: " + e2.getMessage()), (Throwable)e2);
                    throw new IllegalStateException("Failed to insert node: " + e2.getMessage());
                }
            }
            catch (Throwable throwable) {
                JDBCCacheLoader.safeClose(ps);
                this.cf.close(con);
                throw throwable;
            }
        }
        JDBCCacheLoader.safeClose(ps);
        this.cf.close(con);
    }

    private void updateNode(Fqn name, Map node) {
        Connection con = null;
        PreparedStatement ps = null;
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("executing sql: " + this.updateNodeSql));
            }
            con = this.cf.getConnection();
            ps = con.prepareStatement(this.updateNodeSql);
            if (node == null) {
                node = new HashMap(0);
            }
            MarshalledValue marshalledNode = new MarshalledValue((Object)node);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(marshalledNode);
            ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
            ps.setBinaryStream(1, (InputStream)bais, baos.size());
            ps.setString(2, name.toString());
            int rows = ps.executeUpdate();
            if (rows != 1) {
                throw new IllegalStateException("Expected one updated row but got " + rows);
            }
        }
        catch (Exception e) {
            try {
                log.error((Object)("Failed to update node for fqn " + name + ": " + e.getMessage()), (Throwable)e);
                throw new IllegalStateException("Failed to update node for fqn " + name + ": " + e.getMessage());
            }
            catch (Throwable throwable) {
                JDBCCacheLoader.safeClose(ps);
                this.cf.close(con);
                throw throwable;
            }
        }
        JDBCCacheLoader.safeClose(ps);
        this.cf.close(con);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map loadNode(Fqn name) {
        Map map;
        boolean rowExists = false;
        Map oldNode = null;
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("executing sql: " + this.selectNodeSql + " (" + name + ")"));
                }
                con = this.cf.getConnection();
                ps = con.prepareStatement(this.selectNodeSql);
                ps.setString(1, name.toString());
                rs = ps.executeQuery();
                if (rs.next()) {
                    rowExists = true;
                    InputStream is = rs.getBinaryStream(1);
                    if (is != null && !rs.wasNull()) {
                        ObjectInputStream ois;
                        block15: {
                            ois = null;
                            try {
                                ois = new ObjectInputStream(is);
                                Object marshalledNode = ois.readObject();
                                if (marshalledNode instanceof MarshalledValue) {
                                    oldNode = (Map)((MarshalledValue)marshalledNode).get();
                                    break block15;
                                }
                                if (marshalledNode instanceof MarshalledObject) {
                                    oldNode = (Map)((MarshalledObject)marshalledNode).get();
                                }
                            }
                            catch (IOException e) {
                                try {
                                    throw new SQLException("Unable to load to deserialize result: " + e);
                                    catch (ClassNotFoundException e2) {
                                        throw new SQLException("Unable to load to deserialize result: " + e2);
                                    }
                                }
                                catch (Throwable throwable) {
                                    JDBCCacheLoader.safeClose(ois);
                                    throw throwable;
                                }
                            }
                        }
                        JDBCCacheLoader.safeClose(ois);
                    }
                }
                Object var12_14 = null;
            }
            catch (SQLException e) {
                log.error((Object)("Failed to load node for fqn " + name + ": " + e.getMessage()), (Throwable)e);
                throw new IllegalStateException("Failed to load node for fqn " + name + ": " + e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var12_15 = null;
            JDBCCacheLoader.safeClose(rs);
            JDBCCacheLoader.safeClose(ps);
            this.cf.close(con);
            throw throwable;
        }
        JDBCCacheLoader.safeClose(rs);
        JDBCCacheLoader.safeClose(ps);
        this.cf.close(con);
        if (oldNode != null) {
            map = oldNode;
            return map;
        }
        if (!rowExists) return null;
        map = NULL_NODE_IN_ROW;
        return map;
    }

    private static void safeClose(InputStream is) {
        if (is != null) {
            try {
                is.close();
            }
            catch (IOException e) {
                log.warn((Object)("Failed to close input stream: " + e.getMessage()));
            }
        }
    }

    private static void safeClose(Connection con) {
        if (con != null) {
            try {
                con.close();
            }
            catch (SQLException e) {
                log.warn((Object)("Failed to close connection: " + e.getMessage()));
            }
        }
    }

    private static void safeClose(Statement st) {
        if (st != null) {
            try {
                st.close();
            }
            catch (SQLException e) {
                log.warn((Object)("Failed to close statement: " + e.getMessage()));
            }
        }
    }

    private static void safeClose(ResultSet rs) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException e) {
                log.warn((Object)("Failed to close result set: " + e.getMessage()));
            }
        }
    }

    private static void loadDriver(String drv) {
        try {
            Class.forName(drv).newInstance();
        }
        catch (Exception e) {
            log.error((Object)("Failed to load driver " + drv), (Throwable)e);
            throw new IllegalStateException("Failed to load driver " + drv + ": " + e.getMessage());
        }
    }

    private static String getDriverName(Connection con) {
        if (con == null) {
            return null;
        }
        try {
            DatabaseMetaData dmd = con.getMetaData();
            return dmd.getDriverName().toUpperCase();
        }
        catch (SQLException e) {
            throw new IllegalStateException("Error while getting the driver name : " + e.getMessage());
        }
    }

    private static String getRequiredProperty(Properties props, String name) {
        String value = props.getProperty(name);
        if (value == null) {
            throw new IllegalStateException("Missing required property: " + name);
        }
        return value;
    }

    private static boolean tableExists(String tableName, Connection con) {
        boolean bl;
        ResultSet rs = null;
        try {
            DatabaseMetaData dmd = con.getMetaData();
            String catalog = con.getCatalog();
            String schema = null;
            String quote = dmd.getIdentifierQuoteString();
            if (tableName.startsWith(quote)) {
                if (!tableName.endsWith(quote)) {
                    throw new IllegalStateException("Mismatched quote in table name: " + tableName);
                }
                int quoteLength = quote.length();
                tableName = tableName.substring(quoteLength, tableName.length() - quoteLength);
                if (dmd.storesLowerCaseQuotedIdentifiers()) {
                    tableName = tableName.toLowerCase();
                } else if (dmd.storesUpperCaseQuotedIdentifiers()) {
                    tableName = tableName.toUpperCase();
                }
            } else if (dmd.storesLowerCaseIdentifiers()) {
                tableName = tableName.toLowerCase();
            } else if (dmd.storesUpperCaseIdentifiers()) {
                tableName = tableName.toUpperCase();
            }
            int dotIndex = tableName.indexOf(46);
            if (dotIndex != -1) {
                schema = tableName.substring(0, dotIndex);
                tableName = tableName.substring(dotIndex + 1);
            }
            rs = dmd.getTables(catalog, schema, tableName, null);
            bl = rs.next();
        }
        catch (SQLException e) {
            try {
                throw new IllegalStateException("Error while checking if table aleady exists " + tableName + ": " + e.getMessage());
            }
            catch (Throwable throwable) {
                JDBCCacheLoader.safeClose(rs);
                throw throwable;
            }
        }
        JDBCCacheLoader.safeClose(rs);
        return bl;
    }

    private final class ManagedConnectionFactory
    implements ConnectionFactory {
        private final DataSource dataSource;

        public ManagedConnectionFactory(DataSource dataSource) {
            if (dataSource == null) {
                throw new IllegalArgumentException("dataSource cannot be null");
            }
            this.dataSource = dataSource;
        }

        public Connection prepare(Object tx) {
            try {
                return this.getConnection();
            }
            catch (SQLException e) {
                log.error((Object)("Failed to get connection: " + e.getMessage()), (Throwable)e);
                throw new IllegalStateException("Failed to get connection: " + e.getMessage());
            }
        }

        public Connection getConnection() throws SQLException {
            return this.dataSource.getConnection();
        }

        public void commit(Object tx) {
        }

        public void rollback(Object tx) {
        }

        public void close(Connection con) {
            JDBCCacheLoader.safeClose(con);
        }
    }

    private final class NonManagedConnectionFactory
    implements ConnectionFactory {
        private final String url;
        private final String usr;
        private final String pwd;

        public NonManagedConnectionFactory(String url, String usr, String pwd) {
            this.url = url;
            this.usr = usr;
            this.pwd = pwd;
        }

        public Connection prepare(Object tx) {
            Connection con = this.getConnection();
            try {
                if (con.getAutoCommit()) {
                    con.setAutoCommit(false);
                }
            }
            catch (Exception e) {
                log.error((Object)("Failed to set auto-commit: " + e.getMessage()), (Throwable)e);
                throw new IllegalStateException("Failed to set auto-commit: " + e.getMessage());
            }
            connection.set(con);
            return con;
        }

        public Connection getConnection() {
            Connection con = (Connection)connection.get();
            if (con == null) {
                try {
                    con = DriverManager.getConnection(this.url, this.usr, this.pwd);
                    connection.set(con);
                }
                catch (SQLException e) {
                    log.error((Object)("Failed to get connection for url=" + this.url + ", user=" + this.usr + ", password=" + this.pwd), (Throwable)e);
                    throw new IllegalStateException("Failed to get connection for url=" + this.url + ", user=" + this.usr + ", password=" + this.pwd + ": " + e.getMessage());
                }
            }
            if (log.isTraceEnabled()) {
                log.debug((Object)("using connection: " + con));
            }
            return con;
        }

        public void commit(Object tx) {
            Connection con = (Connection)connection.get();
            if (con == null) {
                throw new IllegalStateException("Failed to commit: thread is not associated with the connection!");
            }
            try {
                con.commit();
                if (log.isTraceEnabled()) {
                    log.trace((Object)("committed tx=" + tx + ", con=" + con));
                }
            }
            catch (SQLException e) {
                log.error((Object)"Failed to commit", (Throwable)e);
                throw new IllegalStateException("Failed to commit: " + e.getMessage());
            }
            finally {
                this.closeTxConnection(con);
            }
        }

        public void rollback(Object tx) {
            Connection con = (Connection)connection.get();
            if (con == null) {
                throw new IllegalStateException("Failed to rollback: thread is not associated with the connection!");
            }
            try {
                con.rollback();
                if (log.isTraceEnabled()) {
                    log.trace((Object)("rolledback tx=" + tx + ", con=" + con));
                }
            }
            catch (SQLException e) {
                log.error((Object)"Failed to rollback", (Throwable)e);
                throw new IllegalStateException("Failed to rollback: " + e.getMessage());
            }
            finally {
                this.closeTxConnection(con);
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void close(Connection con) {
            if (con == null || con == connection.get()) return;
            try {
                con.close();
                if (!log.isTraceEnabled()) return;
            }
            catch (SQLException e) {
                log.warn((Object)("Failed to close connection: " + e.getMessage()));
            }
        }

        private void closeTxConnection(Connection con) {
            JDBCCacheLoader.safeClose(con);
            connection.set(null);
        }
    }

    static interface ConnectionFactory {
        public Connection getConnection() throws SQLException;

        public Connection prepare(Object var1);

        public void commit(Object var1);

        public void rollback(Object var1);

        public void close(Connection var1);
    }
}

