/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.aop.collection;

import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jboss.cache.CacheException;
import org.jboss.cache.Fqn;
import org.jboss.cache.aop.PojoCache;
import org.jboss.cache.aop.collection.AbstractCollectionInterceptor;
import org.jboss.cache.aop.util.AopUtil;
import org.jboss.cache.aop.util.Null;

public class CachedMapImpl
implements Map {
    protected PojoCache cache_;
    protected AbstractCollectionInterceptor interceptor_;

    protected CachedMapImpl(PojoCache cache, AbstractCollectionInterceptor interceptor) {
        this.cache_ = cache;
        this.interceptor_ = interceptor;
    }

    protected Fqn getFqn() {
        return this.interceptor_.getFqn();
    }

    protected Set getNodeChildren() {
        try {
            return AopUtil.getNodeChildren(this.cache_, this.getFqn());
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Object get(Object key) {
        try {
            return Null.toNullValue(this.cache_.getObject(AopUtil.constructFqn(this.getFqn(), Null.toNullKeyObject(key))));
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Object put(Object key, Object value) {
        try {
            return this.cache_.putObject(AopUtil.constructFqn(this.getFqn(), Null.toNullKeyObject(key)), Null.toNullObject(value));
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void putAll(Map map) {
        Iterator i = map.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public Object remove(Object key) {
        try {
            return this.cache_.removeObject(AopUtil.constructFqn(this.getFqn(), Null.toNullKeyObject(key)));
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void clear() {
        ArrayList list = new ArrayList(this.keySet());
        for (int i = 0; i < list.size(); ++i) {
            this.remove(list.get(i));
        }
    }

    public int size() {
        Set children = this.getNodeChildren();
        return children == null ? 0 : children.size();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean containsKey(Object object) {
        Set children = this.getNodeChildren();
        if (object != null) {
            object = object.toString();
        }
        return children != null && children.contains(Null.toNullKeyObject(object));
    }

    public boolean containsValue(Object object) {
        return this.values().contains(Null.toNullObject(object));
    }

    public Set entrySet() {
        final CachedMapImpl map = this;
        return new AbstractSet(){

            public int size() {
                Set children = CachedMapImpl.this.getNodeChildren();
                return children == null ? 0 : children.size();
            }

            public Iterator iterator() {
                Set children = CachedMapImpl.this.getNodeChildren();
                Iterator i = children == null ? Collections.EMPTY_LIST.iterator() : children.iterator();
                return new Iterator(this, i){
                    Object lastKey;
                    private final /* synthetic */ Iterator val$i;
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = this$1;
                        this.val$i = val$i;
                    }

                    public boolean hasNext() {
                        return this.val$i.hasNext();
                    }

                    public Object next() {
                        this.lastKey = this.val$i.next();
                        return 1.access$000(this.this$1).new Entry(this.lastKey);
                    }

                    public void remove() {
                        1.access$100(this.this$1).remove(this.lastKey);
                    }
                };
            }

            static /* synthetic */ CachedMapImpl access$000(1 x0) {
                return x0.CachedMapImpl.this;
            }

            static /* synthetic */ CachedMapImpl access$100(1 x0) {
                return x0.map;
            }
        };
    }

    public Collection values() {
        final CachedMapImpl map = this;
        return new AbstractCollection(){

            public int size() {
                Set children = CachedMapImpl.this.getNodeChildren();
                return children == null ? 0 : children.size();
            }

            public void clear() {
                map.clear();
            }

            public Iterator iterator() {
                Set children = CachedMapImpl.this.getNodeChildren();
                Iterator i = children == null ? Collections.EMPTY_LIST.iterator() : children.iterator();
                return new Iterator(this, i){
                    Object lastKey;
                    private final /* synthetic */ Iterator val$i;
                    private final /* synthetic */ 3 this$1;
                    {
                        this.this$1 = this$1;
                        this.val$i = val$i;
                    }

                    public boolean hasNext() {
                        return this.val$i.hasNext();
                    }

                    public Object next() {
                        try {
                            this.lastKey = this.val$i.next();
                            return Null.toNullValue(3.access$200(this.this$1).cache_.getObject(AopUtil.constructFqn(3.access$200(this.this$1).getFqn(), this.lastKey)));
                        }
                        catch (RuntimeException re) {
                            throw re;
                        }
                        catch (CacheException e) {
                            throw new RuntimeException(e);
                        }
                    }

                    public void remove() {
                        Object key = this.lastKey;
                        if (key != null) {
                            key = Null.toNullKeyValue(key);
                        }
                        3.access$300(this.this$1).remove(key);
                    }
                };
            }

            static /* synthetic */ CachedMapImpl access$200(3 x0) {
                return x0.CachedMapImpl.this;
            }

            static /* synthetic */ CachedMapImpl access$300(3 x0) {
                return x0.map;
            }
        };
    }

    public Set keySet() {
        final CachedMapImpl map = this;
        return new AbstractSet(){

            public int size() {
                Set children = CachedMapImpl.this.getNodeChildren();
                return children == null ? 0 : children.size();
            }

            public Iterator iterator() {
                Set children = CachedMapImpl.this.getNodeChildren();
                Iterator i = children == null ? Collections.EMPTY_LIST.iterator() : children.iterator();
                return new Iterator(this, i){
                    Object lastKey;
                    private final /* synthetic */ Iterator val$i;
                    private final /* synthetic */ 5 this$1;
                    {
                        this.this$1 = this$1;
                        this.val$i = val$i;
                    }

                    public boolean hasNext() {
                        return this.val$i.hasNext();
                    }

                    public Object next() {
                        this.lastKey = this.val$i.next();
                        return Null.toNullKeyValue(this.lastKey);
                    }

                    public void remove() {
                        Object key = this.lastKey;
                        if (key != null) {
                            key = Null.toNullKeyValue(key);
                        }
                        5.access$400(this.this$1).remove(key);
                    }
                };
            }

            static /* synthetic */ CachedMapImpl access$400(5 x0) {
                return x0.map;
            }
        };
    }

    public int hashCode() {
        int result = 0;
        Iterator i = this.entrySet().iterator();
        while (i.hasNext()) {
            result += i.next().hashCode();
        }
        return result;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !(object instanceof Map)) {
            return false;
        }
        Map map = (Map)object;
        if (this.size() != map.size()) {
            return false;
        }
        Iterator i = this.entrySet().iterator();
        while (i.hasNext()) {
            Entry entry = (Entry)i.next();
            Object value = entry.getValue();
            Object key = entry.getKey();
            if (!(value == null ? map.get(key) != null || !map.containsKey(key) : !value.equals(map.get(key)))) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        Set set = this.keySet();
        Iterator it = set.iterator();
        while (it.hasNext()) {
            Object key = it.next();
            buf.append("[").append(key).append(", ").append(this.get(key)).append("]");
            if (!it.hasNext()) continue;
            buf.append(", ");
        }
        return buf.toString();
    }

    protected class Entry
    implements Map.Entry {
        Object key;

        public Entry(Object key) {
            this.key = key;
        }

        public Object getKey() {
            return Null.toNullValue(this.key);
        }

        public Object getValue() {
            try {
                return Null.toNullValue(CachedMapImpl.this.cache_.getObject(AopUtil.constructFqn(CachedMapImpl.this.getFqn(), this.key)));
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public Object setValue(Object value) {
            try {
                return CachedMapImpl.this.cache_.putObject(AopUtil.constructFqn(CachedMapImpl.this.getFqn(), this.key), Null.toNullObject(value));
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public int hashCode() {
            Object value = this.getValue();
            return (this.key == null ? 0 : this.key.hashCode()) ^ (value == null ? 0 : value.hashCode());
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Entry)) {
                return false;
            }
            Entry entry = (Entry)obj;
            Object value = this.getValue();
            return (this.key == null ? entry.getKey() == null : this.key.equals(entry.getKey())) && (value == null ? entry.getValue() == null : value.equals(entry.getValue()));
        }
    }
}

