/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.storage.xray_udp;

import com.squareup.moshi.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import okio.Buffer;
import okio.BufferedSink;
import okio.BufferedSource;
import zipkin2.Span;

final class UDPMessageEncoder {
    static final Logger logger = Logger.getLogger(UDPMessageEncoder.class.getName());

    UDPMessageEncoder() {
    }

    static void writeJson(Span span, Buffer buffer) throws IOException {
        Integer errorStatus;
        JsonWriter writer = JsonWriter.of((BufferedSink)buffer);
        writer.beginObject();
        writer.name("trace_id");
        writer.value((BufferedSource)new Buffer().writeByte(34).writeByte(49).writeByte(45).writeUtf8(span.traceId(), 0, 8).writeByte(45).writeUtf8(span.traceId(), 8, 32).writeByte(34));
        if (span.parentId() != null) {
            writer.name("parent_id").value(span.parentId());
        }
        writer.name("id").value(span.id());
        if (span.kind() == null) {
            if (span.parentId() != null) {
                writer.name("type").value("subsegment");
            }
            writer.name("name").value(span.name() == null ? "unknown" : span.name());
        } else if (span.kind() == Span.Kind.CLIENT || span.kind() == Span.Kind.PRODUCER) {
            if (span.parentId() != null) {
                writer.name("type").value("subsegment");
            }
            writer.name("namespace").value("remote");
            String name = span.remoteServiceName();
            if (name == null) {
                name = (String)span.tags().get("http.host");
            }
            if (name == null) {
                name = span.name();
            }
            if (name == null) {
                name = "unknown";
            }
            writer.name("name").value(name);
        } else {
            writer.name("name").value(span.localServiceName());
        }
        if (span.tags().get("xray.namespace") != null) {
            writer.name("namespace").value((String)span.tags().get("xray.namespace"));
        }
        if (span.timestamp() != null) {
            writer.name("start_time").value((double)span.timestamp().longValue() / 1000000.0);
            if (span.duration() != null) {
                writer.name("end_time").value((double)(span.timestamp() + span.duration()) / 1000000.0);
            } else {
                writer.name("in_progress").value(true);
            }
        }
        String httpRequestMethod = null;
        String httpRequestUrl = null;
        Integer httpResponseStatus = null;
        String sqlUrl = null;
        String sqlPreparation = null;
        String sqlDatabaseType = null;
        String sqlDatabaseVersion = null;
        String sqlDriverVersion = null;
        String sqlUser = null;
        String sqlSanitizedQuery = null;
        String awsOperation = null;
        String awsAccountId = null;
        String awsRegion = null;
        String awsRequestId = null;
        String awsQueueUrl = null;
        String awsTableName = null;
        String ec2AvailabilityZone = null;
        String ec2InstanceId = null;
        String xrayOrigin = null;
        String xraySdk = null;
        String causeWorkingDirectory = null;
        String causeExceptions = null;
        boolean http = false;
        boolean sql = false;
        boolean cause = false;
        LinkedHashMap<String, String> annotations = new LinkedHashMap<String, String>();
        LinkedHashMap<String, String> metadata = new LinkedHashMap<String, String>();
        block60: for (Map.Entry entry : span.tags().entrySet()) {
            if (((String)entry.getKey()).startsWith("http.")) {
                http = true;
                switch ((String)entry.getKey()) {
                    case "http.method": {
                        httpRequestMethod = (String)entry.getValue();
                        continue block60;
                    }
                    case "http.url": {
                        httpRequestUrl = (String)entry.getValue();
                        continue block60;
                    }
                    case "http.status_code": {
                        httpResponseStatus = Integer.parseInt((String)entry.getValue());
                        continue block60;
                    }
                }
            }
            if (((String)entry.getKey()).startsWith("sql.")) {
                sql = true;
                switch ((String)entry.getKey()) {
                    case "sql.url": {
                        sqlUrl = (String)entry.getValue();
                        continue block60;
                    }
                    case "sql.preparation": {
                        sqlPreparation = (String)entry.getValue();
                        continue block60;
                    }
                    case "sql.database_type": {
                        sqlDatabaseType = (String)entry.getValue();
                        continue block60;
                    }
                    case "sql.database_version": {
                        sqlDatabaseVersion = (String)entry.getValue();
                        continue block60;
                    }
                    case "sql.driver_version": {
                        sqlDriverVersion = (String)entry.getValue();
                        continue block60;
                    }
                    case "sql.user": {
                        sqlUser = (String)entry.getValue();
                        continue block60;
                    }
                    case "sql.sanitized_query": {
                        sqlSanitizedQuery = (String)entry.getValue();
                        continue block60;
                    }
                }
            }
            if (((String)entry.getKey()).startsWith("aws.")) {
                switch ((String)entry.getKey()) {
                    case "aws.operation": {
                        awsOperation = (String)entry.getValue();
                        continue block60;
                    }
                    case "aws.account_id": {
                        awsAccountId = (String)entry.getValue();
                        continue block60;
                    }
                    case "aws.region": {
                        awsRegion = (String)entry.getValue();
                        continue block60;
                    }
                    case "aws.request_id": {
                        awsRequestId = (String)entry.getValue();
                        continue block60;
                    }
                    case "aws.queue_url": {
                        awsQueueUrl = (String)entry.getValue();
                        continue block60;
                    }
                    case "aws.table_name": {
                        awsTableName = (String)entry.getValue();
                        continue block60;
                    }
                    case "aws.ec2.availability_zone": {
                        ec2AvailabilityZone = (String)entry.getValue();
                        continue block60;
                    }
                    case "aws.ec2.instance_id": {
                        ec2InstanceId = (String)entry.getValue();
                        continue block60;
                    }
                    case "aws.origin": {
                        xrayOrigin = (String)entry.getValue();
                        continue block60;
                    }
                    case "aws.xray.sdk": {
                        xraySdk = (String)entry.getValue();
                        continue block60;
                    }
                }
            }
            if (((String)entry.getKey()).startsWith("cause.")) {
                cause = true;
                switch ((String)entry.getKey()) {
                    case "cause.working_directory": {
                        causeWorkingDirectory = (String)entry.getValue();
                        continue block60;
                    }
                    case "cause.exceptions": {
                        causeExceptions = (String)entry.getValue();
                        continue block60;
                    }
                }
            }
            String key = ((String)entry.getKey()).replace('.', '_');
            if (((String)entry.getValue()).length() < 250) {
                annotations.put(key, (String)entry.getValue());
                continue;
            }
            metadata.put(key, (String)entry.getValue());
        }
        if (http) {
            if (httpRequestMethod == null) {
                httpRequestMethod = span.name();
            }
            writer.name("http");
            writer.beginObject();
            if (httpRequestMethod != null || httpRequestUrl != null) {
                writer.name("request");
                writer.beginObject();
                if (httpRequestMethod != null) {
                    writer.name("method").value(httpRequestMethod.toUpperCase());
                }
                if (httpRequestUrl != null) {
                    writer.name("url").value(httpRequestUrl);
                }
                writer.endObject();
            }
            if (httpResponseStatus != null) {
                writer.name("response");
                writer.beginObject();
                writer.name("status").value((Number)httpResponseStatus);
                writer.endObject();
            }
            writer.endObject();
        }
        if ((errorStatus = httpResponseStatus) != null) {
            if (errorStatus == 429) {
                writer.name("throttle").value(true);
            } else if (errorStatus >= 500) {
                writer.name("fault").value(true);
            } else if (errorStatus >= 400) {
                writer.name("error").value(true);
            }
        }
        if (sql) {
            writer.name("sql");
            writer.beginObject();
            if (sqlUrl != null) {
                writer.name("url").value(sqlUrl);
            }
            if (sqlPreparation != null) {
                writer.name("preparation").value(sqlPreparation);
            }
            if (sqlDatabaseType != null) {
                writer.name("database_type").value(sqlDatabaseType);
            }
            if (sqlDatabaseVersion != null) {
                writer.name("database_version").value(sqlDatabaseVersion);
            }
            if (sqlDriverVersion != null) {
                writer.name("driver_version").value(sqlDriverVersion);
            }
            if (sqlUser != null) {
                writer.name("user").value(sqlUser);
            }
            if (sqlSanitizedQuery != null) {
                writer.name("sanitized_query").value(sqlUser);
            }
            writer.endObject();
        }
        writer.name("aws");
        writer.beginObject();
        writer.name("xray");
        writer.beginObject();
        writer.name("sdk");
        writer.value(xraySdk != null ? xraySdk : "Zipkin");
        writer.endObject();
        if (awsOperation != null) {
            writer.name("operation").value(awsOperation);
        }
        if (awsAccountId != null) {
            writer.name("account_id").value(awsAccountId);
        }
        if (awsRegion != null) {
            writer.name("region").value(awsRegion);
        }
        if (awsRequestId != null) {
            writer.name("request_id").value(awsRequestId);
        }
        if (awsQueueUrl != null) {
            writer.name("queue_url").value(awsQueueUrl);
        }
        if (awsTableName != null) {
            writer.name("table_name").value(awsTableName);
        }
        if (ec2AvailabilityZone != null || ec2InstanceId != null) {
            writer.name("ec2");
            writer.beginObject();
            if (ec2AvailabilityZone != null) {
                writer.name("availability_zone").value(ec2AvailabilityZone);
            }
            if (ec2InstanceId != null) {
                writer.name("instance_id").value(ec2InstanceId);
            }
            writer.endObject();
        }
        writer.endObject();
        if (xrayOrigin != null) {
            writer.name("origin").value(xrayOrigin);
        }
        if (cause) {
            writer.name("cause");
            writer.beginObject();
            if (causeWorkingDirectory != null) {
                writer.name("working_directory").value(causeWorkingDirectory);
            }
            if (causeExceptions != null) {
                String s = "\"exceptions\" :";
                if (causeWorkingDirectory != null) {
                    s = "," + s;
                }
                buffer.writeUtf8(s + causeExceptions);
            }
            writer.endObject();
        }
        if (!annotations.isEmpty()) {
            writer.name("annotations");
            writer.beginObject();
            if (httpRequestMethod != null && span.name() != null && !httpRequestMethod.equals(span.name())) {
                writer.name("operation").value(span.name());
            }
            for (Map.Entry annotation : annotations.entrySet()) {
                writer.name((String)annotation.getKey()).value((String)annotation.getValue());
            }
            writer.endObject();
        }
        if (!metadata.isEmpty()) {
            writer.name("metadata");
            writer.beginObject();
            for (Map.Entry metadatum : metadata.entrySet()) {
                writer.name((String)metadatum.getKey()).value((String)metadatum.getValue());
            }
            writer.endObject();
        }
        writer.endObject();
        writer.flush();
    }

    static byte[] encode(Span span) {
        try {
            if (span.traceId().length() != 32) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("span reported without a 128-bit trace ID" + span);
                }
                throw new IllegalStateException("Change the tracer to use 128-bit trace IDs");
            }
            Buffer buffer = new Buffer();
            buffer.writeUtf8("{\"format\": \"json\", \"version\": 1}\n");
            UDPMessageEncoder.writeJson(span, buffer);
            return buffer.readByteArray();
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }
}

