/*
 * Decompiled with CFR 0.152.
 */
package io.streamthoughts.kafka.connect.transform.pattern;

import io.streamthoughts.kafka.connect.transform.pattern.GrokException;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GrokPatternResolver {
    private static final Logger LOG = LoggerFactory.getLogger(GrokPatternResolver.class);
    private static final Pattern DEFINITION = Pattern.compile("^(?<NAME>[A-Z0-9_]+)(\\s)*(?<PATTERN>.*)");
    private static final String PATTERNS_PATH = "patterns";
    private static final String TAB = "\t ";
    private static final String NEWLINE = "\n";
    private static final String SPACE = " ";
    private final Map<String, String> definitions = new LinkedHashMap<String, String>();

    public GrokPatternResolver() {
        this(Collections.emptyList(), Collections.emptyList());
    }

    public GrokPatternResolver(Collection<String> patternDefinitions, Collection<File> patternsDir) {
        this.loadPredefinedPatterns();
        this.loadUserDefinedPatterns(patternsDir);
        this.definitions.putAll(this.readPatterns(patternDefinitions));
    }

    private void loadUserDefinedPatterns(Collection<File> patternsDir) {
        if (patternsDir != null) {
            for (File dir : patternsDir) {
                if (!dir.exists() || !dir.canRead()) {
                    LOG.error("Can't read pattern from user directory {} - directory doesn't exist or is readable", patternsDir);
                    return;
                }
                if (!dir.isDirectory()) {
                    LOG.error("Can't read pattern from {} - not a directory", patternsDir);
                    return;
                }
                try {
                    List<Path> paths = Files.list(dir.toPath()).collect(Collectors.toList());
                    this.loadPatternDefinitions(paths);
                }
                catch (IOException e) {
                    LOG.error("Unexpected error occurred while reading user defined patterns", (Throwable)e);
                }
            }
        }
    }

    private void loadPredefinedPatterns() {
        block10: {
            LOG.info("Looking for pre-defined patterns definitions from : {}", (Object)PATTERNS_PATH);
            try {
                ClassLoader cl = GrokPatternResolver.getClassLoader();
                URL url = cl.getResource(PATTERNS_PATH);
                if (url != null) {
                    String protocol = url.getProtocol();
                    if (protocol != null && protocol.equals("jar")) {
                        try (FileSystem fs = this.getFileSystemFor(url);){
                            List<Path> paths = Files.walk(fs.getPath(PATTERNS_PATH, new String[0]), new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).collect(Collectors.toList());
                            this.loadPatternDefinitions(paths);
                            break block10;
                        }
                    }
                    List<Path> paths = Files.list(Paths.get(url.toURI())).collect(Collectors.toList());
                    this.loadPatternDefinitions(paths);
                    break block10;
                }
                LOG.error("Failed to load pre-defined patterns definitions : {}", (Object)PATTERNS_PATH);
            }
            catch (IOException | URISyntaxException e) {
                LOG.error("Unexpected error occurred while reading pre-defined patterns", (Throwable)e);
            }
        }
    }

    private FileSystem getFileSystemFor(URL url) throws URISyntaxException, IOException {
        FileSystem fs;
        try {
            fs = FileSystems.getFileSystem(url.toURI());
        }
        catch (FileSystemNotFoundException e) {
            fs = FileSystems.newFileSystem(url.toURI(), Collections.emptyMap());
        }
        return fs;
    }

    private void loadPatternDefinitions(List<Path> paths) throws IOException {
        for (Path path : paths) {
            Map<String, String> patternDefinitions = this.readPatternDefinitionsFrom(path);
            this.definitions.putAll(patternDefinitions);
            LOG.info("Loaded patterns definitions from : {}", (Object)path.toUri());
        }
    }

    private static ClassLoader getClassLoader() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            return GrokPatternResolver.class.getClassLoader();
        }
        return cl;
    }

    public String resolve(String syntax) {
        if (!this.definitions.containsKey(syntax)) {
            throw new GrokException("No pattern definition found for syntax : " + syntax);
        }
        return this.definitions.get(syntax);
    }

    void print() {
        StringBuilder sb = new StringBuilder();
        sb.append("Defined pattern definitions list : \n");
        this.definitions.forEach((k, v) -> sb.append(TAB).append((String)k).append(SPACE).append((String)v).append(NEWLINE));
        LOG.info("{}", (Object)sb.toString());
    }

    boolean isEmpty() {
        return this.definitions.isEmpty();
    }

    private Map<String, String> readPatternDefinitionsFrom(Path path) throws GrokException, IOException {
        Map<String, String> map;
        InputStream is = Files.newInputStream(path, StandardOpenOption.READ);
        BufferedReader br = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));
        try {
            List<String> definitions = br.lines().collect(Collectors.toList());
            map = this.readPatterns(definitions);
        }
        catch (Throwable throwable) {
            try {
                try {
                    br.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new GrokException("Unexpected error while reading pattern definition : " + path);
            }
        }
        br.close();
        return map;
    }

    private Map<String, String> readPatterns(Collection<String> definitions) {
        return definitions.stream().map(s -> {
            KeyValue<String, String> result = null;
            Matcher matcher = DEFINITION.matcher((CharSequence)s);
            if (matcher.matches()) {
                String name = matcher.group("NAME");
                String pattern = matcher.group("PATTERN");
                result = new KeyValue<String, String>(name, pattern);
            }
            return result;
        }).filter(Objects::nonNull).collect(Collectors.toMap(KeyValue::key, KeyValue::value));
    }

    private static class KeyValue<K, V> {
        private final K key;
        private final V value;

        KeyValue(K key, V value) {
            Objects.requireNonNull(key, "key can't be null");
            Objects.requireNonNull(value, "value can't be null");
            this.key = key;
            this.value = value;
        }

        K key() {
            return this.key;
        }

        V value() {
            return this.value;
        }
    }
}

