/*
 * Decompiled with CFR 0.152.
 */
package io.streamthoughts.kafka.connect.transform.pattern;

import io.streamthoughts.kafka.connect.transform.pattern.GrokMatcher;
import io.streamthoughts.kafka.connect.transform.pattern.GrokPattern;
import io.streamthoughts.kafka.connect.transform.pattern.GrokPatternResolver;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GrokPatternCompiler {
    private static final Logger LOG = LoggerFactory.getLogger(GrokPatternCompiler.class);
    private static final String SYNTAX_FIELD = "syntax";
    private static final String SEMANTIC_FIELD = "semantic";
    private static final String TYPE_FIELD = "type";
    private static final String REGEX = "(?:%\\{(?<syntax>[A-Z0-9_]+)(?:\\:(?<semantic>[a-zA-Z0-9_\\\\-]+))?(?:\\:(?<type>[a-zA-Z0-9_\\\\-]+))?\\})";
    private static final Pattern PATTERN = Pattern.compile("(?:%\\{(?<syntax>[A-Z0-9_]+)(?:\\:(?<semantic>[a-zA-Z0-9_\\\\-]+))?(?:\\:(?<type>[a-zA-Z0-9_\\\\-]+))?\\})");
    private final GrokPatternResolver resolver;
    private final boolean namedCapturesOnly;

    public GrokPatternCompiler(GrokPatternResolver resolver, boolean namedCapturesOnly) {
        Objects.requireNonNull(resolver, "resolver can't be null");
        this.resolver = resolver;
        this.namedCapturesOnly = namedCapturesOnly;
    }

    public GrokMatcher compile(String expression) {
        Objects.requireNonNull(expression, "expression can't be null");
        LOG.info("Starting to compile grok matcher expression : {}", (Object)expression);
        ArrayList<GrokPattern> patterns = new ArrayList<GrokPattern>();
        String regex = this.compileRegex(expression, patterns);
        LOG.info("Grok expression compiled to regex : {}", (Object)regex);
        return new GrokMatcher(patterns, regex);
    }

    private String compileRegex(String expression, List<GrokPattern> patterns) {
        Matcher matcher = PATTERN.matcher(expression);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            GrokPattern grok = new GrokPattern(matcher.group(SYNTAX_FIELD), matcher.group(SEMANTIC_FIELD), matcher.group(TYPE_FIELD));
            patterns.add(grok);
            String resolved = this.resolver.resolve(grok.syntax());
            String replacement = this.compileRegex(resolved, patterns);
            if (grok.semantic() != null) {
                replacement = this.capture(replacement, grok.semantic());
            } else if (!this.namedCapturesOnly) {
                replacement = this.capture(replacement, grok.syntax());
            }
            replacement = replacement.replace("\\$", "\\\\\\$").replace("\\", "\\\\");
            matcher.appendReplacement(sb, replacement);
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    private String capture(String expression, String name) {
        return "(?<" + name + ">" + expression + ")";
    }
}

