/*
 * Decompiled with CFR 0.152.
 */
package io.streamthoughts.kafka.connect.transform.pattern;

import io.streamthoughts.kafka.connect.transform.data.Type;
import io.streamthoughts.kafka.connect.transform.pattern.GrokCaptureExtractor;
import io.streamthoughts.kafka.connect.transform.pattern.GrokCaptureGroup;
import io.streamthoughts.kafka.connect.transform.pattern.GrokPattern;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.jcodings.Encoding;
import org.jcodings.specific.UTF8Encoding;
import org.joni.Matcher;
import org.joni.NameEntry;
import org.joni.Regex;

public class GrokMatcher {
    private final Map<String, GrokPattern> patternsByName;
    private final List<GrokPattern> patterns;
    private final String expression;
    private final Regex regex;
    private final List<GrokCaptureGroup> grokCaptureGroups;
    private final Schema schema;

    GrokMatcher(List<GrokPattern> patterns, String expression) {
        Objects.requireNonNull(patterns, "pattern can't be null");
        Objects.requireNonNull(expression, "expression can't be null");
        this.patterns = patterns;
        this.expression = expression;
        this.patternsByName = patterns.stream().collect(Collectors.toMap(GrokPattern::syntax, p -> p, (p1, p2) -> p1.semantic() != null ? p1 : p2));
        byte[] bytes = expression.getBytes(StandardCharsets.UTF_8);
        this.regex = new Regex(bytes, 0, bytes.length, 0, (Encoding)UTF8Encoding.INSTANCE);
        this.grokCaptureGroups = new ArrayList<GrokCaptureGroup>();
        Iterator entry = this.regex.namedBackrefIterator();
        while (entry.hasNext()) {
            NameEntry nameEntry = (NameEntry)entry.next();
            String field = new String(nameEntry.name, nameEntry.nameP, nameEntry.nameEnd - nameEntry.nameP, StandardCharsets.UTF_8);
            GrokPattern pattern = this.getGrokPattern(field);
            Type type = pattern != null ? pattern.type() : Type.STRING;
            this.grokCaptureGroups.add(new GrokCaptureGroup(field, nameEntry.getBackRefs(), type));
        }
        SchemaBuilder builder = SchemaBuilder.struct();
        for (GrokCaptureGroup group : this.grokCaptureGroups) {
            Schema fieldSchema = new SchemaBuilder(group.type().schemaType()).optional().defaultValue(null).build();
            builder.field(group.name(), fieldSchema);
        }
        this.schema = builder.build();
    }

    public Schema schema() {
        return this.schema;
    }

    public GrokPattern getGrokPattern(int i) {
        return this.patterns.get(i);
    }

    public GrokPattern getGrokPattern(String name) {
        return this.patternsByName.get(name);
    }

    public Regex regex() {
        return this.regex;
    }

    public String expression() {
        return this.expression;
    }

    public Map<String, Object> captures(byte[] bytes) {
        long now = Time.SYSTEM.milliseconds();
        GrokCaptureExtractor.MapGrokCaptureExtractor extractor = new GrokCaptureExtractor.MapGrokCaptureExtractor(this.grokCaptureGroups);
        Matcher matcher = this.regex.matcher(bytes);
        int result = matcher.search(0, bytes.length, 0);
        if (result == -1) {
            return null;
        }
        if (result == -2) {
            long interruptedAfterMs = Time.SYSTEM.milliseconds() - now;
            throw new RuntimeException("Grok pattern matching was interrupted before completion (" + interruptedAfterMs + " ms)");
        }
        extractor.extract(bytes, matcher.getEagerRegion());
        return extractor.captured();
    }

    public String toString() {
        return "GrokMatcher{patterns=" + this.patterns + ", expression='" + this.expression + "'}";
    }
}

