/*
 * Decompiled with CFR 0.152.
 */
package io.streamthoughts.kafka.connect.transform.pattern;

import io.streamthoughts.kafka.connect.transform.pattern.GrokCaptureGroup;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.joni.Region;

public interface GrokCaptureExtractor {
    public void extract(byte[] var1, Region var2);

    public static class MapGrokCaptureExtractor
    implements GrokCaptureExtractor {
        private final List<GrokCaptureExtractor> extractors;
        private final Map<String, Object> captured = new HashMap<String, Object>();

        public MapGrokCaptureExtractor(List<GrokCaptureGroup> grokCaptureGroups) {
            this.extractors = grokCaptureGroups.stream().map(group -> group.getExtractor(o -> this.captured.put(group.name(), o))).collect(Collectors.toList());
        }

        @Override
        public void extract(byte[] bytes, Region region) {
            for (GrokCaptureExtractor extractor : this.extractors) {
                extractor.extract(bytes, region);
            }
        }

        public Map<String, Object> captured() {
            return this.captured;
        }
    }
}

