/*
 * Decompiled with CFR 0.152.
 */
package io.streamthoughts.kafka.connect.transform.data;

import io.streamthoughts.kafka.connect.transform.data.internal.TypeConverter;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.errors.DataException;

public enum Type {
    NULL(null, null){

        @Override
        public Short convert(Object o) {
            throw new UnsupportedOperationException("Cannot convert an object to type NULL");
        }

        @Override
        protected boolean isInternal() {
            return true;
        }
    }
    ,
    SHORT(Collections.singletonList(Short.class), Schema.Type.INT16){

        @Override
        public Short convert(Object o) {
            return TypeConverter.getShort(o);
        }
    }
    ,
    INTEGER(Collections.singletonList(Integer.class), Schema.Type.INT32){

        @Override
        public Integer convert(Object o) {
            return TypeConverter.getInt(o);
        }
    }
    ,
    LONG(Collections.singletonList(Long.class), Schema.Type.INT64){

        @Override
        public Long convert(Object o) {
            return TypeConverter.getLong(o);
        }
    }
    ,
    FLOAT(Collections.singletonList(Float.class), Schema.Type.FLOAT32){

        @Override
        public Float convert(Object o) {
            return TypeConverter.getFloat(o);
        }
    }
    ,
    DOUBLE(Collections.singletonList(Double.class), Schema.Type.FLOAT64){

        @Override
        public Double convert(Object o) {
            return TypeConverter.getDouble(o);
        }
    }
    ,
    BOOLEAN(Collections.singletonList(Boolean.class), Schema.Type.BOOLEAN){

        @Override
        public Boolean convert(Object o) {
            return TypeConverter.getBool(o);
        }
    }
    ,
    STRING(Collections.singletonList(String.class), Schema.Type.STRING){

        @Override
        public String convert(Object o) {
            return TypeConverter.getString(o);
        }
    }
    ,
    ARRAY(Collections.singletonList(Collection.class), Schema.Type.ARRAY){

        @Override
        public Collection convert(Object o) {
            return TypeConverter.getArray(o);
        }
    }
    ,
    BYTES(Collections.emptyList(), Schema.Type.BYTES){

        public byte[] convert(Object o) {
            return TypeConverter.getBytes(o);
        }
    };

    private static final Map<Class<?>, Type> JAVA_CLASS_TYPES;
    private Schema.Type schemaType;
    private Collection<Class<?>> classes;

    private Type(Collection<Class<?>> classes, Schema.Type schemaType) {
        this.classes = classes;
        this.schemaType = schemaType;
    }

    public Schema.Type schemaType() {
        return this.schemaType;
    }

    public abstract Object convert(Object var1);

    protected boolean isInternal() {
        return false;
    }

    public boolean isPrimitive() {
        switch (this) {
            case FLOAT: 
            case DOUBLE: 
            case INTEGER: 
            case LONG: 
            case BOOLEAN: 
            case STRING: 
            case BYTES: {
                return true;
            }
        }
        return false;
    }

    public static Type forName(String name) {
        for (Type type : Type.values()) {
            if (type.isInternal() || !type.name().equals(name) && !type.schemaType.name().equals(name)) continue;
            return type;
        }
        throw new DataException("Cannot find corresponding Type for name : " + name);
    }

    static {
        JAVA_CLASS_TYPES = new HashMap();
        for (Type type : Type.values()) {
            if (type.isInternal()) continue;
            Collection<Class<?>> typeClasses = type.classes;
            for (Class<?> typeClass : typeClasses) {
                JAVA_CLASS_TYPES.put(typeClass, type);
            }
        }
    }
}

