/*
 * Decompiled with CFR 0.152.
 */
package io.socket.socketio.server;

import io.socket.emitter.Emitter;
import io.socket.parser.Packet;
import io.socket.socketio.server.PacketUtils;
import io.socket.socketio.server.SocketIoAdapter;
import io.socket.socketio.server.SocketIoClient;
import io.socket.socketio.server.SocketIoNamespace;
import io.socket.socketio.server.SocketIoNamespaceImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class SocketIoSocket
extends Emitter {
    private static final Object[] EMPTY_ARGS = new Object[0];
    private final ConcurrentLinkedQueue<AllEventListener> mAllEventListeners = new ConcurrentLinkedQueue();
    private final SocketIoNamespaceImpl mNamespace;
    private final SocketIoClient mClient;
    private final SocketIoAdapter mAdapter;
    private final String mId;
    private final HashSet<String> mRooms = new HashSet();
    private final HashMap<Integer, ReceivedByRemoteAcknowledgementCallback> mAcknowledgementCallbacks = new HashMap();
    private boolean mConnected;

    SocketIoSocket(SocketIoNamespaceImpl namespace, SocketIoClient client) {
        this.mNamespace = namespace;
        this.mClient = client;
        this.mAdapter = namespace.getAdapter();
        this.mId = this.mNamespace.getName().equals("/") ? client.getId() : this.mNamespace.getName() + "#" + client.getId();
        this.mConnected = true;
    }

    public int hashCode() {
        return this.mId.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof SocketIoSocket && this.getId().equals(((SocketIoSocket)((Object)obj)).getId());
    }

    public String getId() {
        return this.mId;
    }

    public SocketIoNamespace getNamespace() {
        return this.mNamespace;
    }

    public void disconnect(boolean close) {
        if (this.mConnected) {
            if (close) {
                this.mClient.disconnect();
            } else {
                Packet packet = new Packet();
                packet.type = 1;
                this.sendPacket(packet);
                this.onClose("server namespace disconnect");
            }
        }
    }

    public void broadcast(String room, String event, Object ... args) throws IllegalArgumentException {
        String[] stringArray;
        if (room != null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = room;
        } else {
            stringArray = null;
        }
        this.broadcast(stringArray, event, args);
    }

    public void broadcast(String[] rooms, String event, Object[] args) throws IllegalArgumentException {
        if (event == null) {
            throw new IllegalArgumentException("event cannot be null.");
        }
        Packet packet = PacketUtils.createDataPacket(2, event, args);
        this.mAdapter.broadcast(packet, rooms, new String[]{this.getId()});
    }

    public void send(String event, Object ... args) throws IllegalArgumentException {
        this.send(event, args, null);
    }

    public void send(String event, Object[] args, ReceivedByRemoteAcknowledgementCallback acknowledgementCallback) throws IllegalArgumentException {
        if (event == null) {
            throw new IllegalArgumentException("event cannot be null.");
        }
        Packet packet = PacketUtils.createDataPacket(2, event, args);
        if (acknowledgementCallback != null) {
            packet.id = this.mNamespace.nextId();
            this.mAcknowledgementCallbacks.put(packet.id, acknowledgementCallback);
        }
        this.sendPacket(packet);
    }

    public synchronized void joinRoom(String ... rooms) {
        ArrayList<String> roomList = new ArrayList<String>();
        for (String room : rooms) {
            if (this.mRooms.contains(room)) continue;
            roomList.add(room);
        }
        if (roomList.size() > 0) {
            for (String room : roomList) {
                this.mAdapter.add(room, this);
                this.mRooms.add(room);
            }
        }
    }

    public synchronized void leaveRoom(String ... rooms) {
        ArrayList<String> roomList = new ArrayList<String>();
        for (String room : rooms) {
            if (!this.mRooms.contains(room)) continue;
            roomList.add(room);
        }
        if (roomList.size() > 0) {
            for (String room : roomList) {
                this.mAdapter.remove(room, this);
                this.mRooms.remove(room);
            }
        }
    }

    public synchronized void leaveAllRooms() {
        for (String room : this.mRooms) {
            this.mAdapter.remove(room, this);
        }
        this.mRooms.clear();
    }

    public void registerAllEventListener(AllEventListener listener) {
        this.mAllEventListeners.add(listener);
    }

    public void unregisterAllEventListener(AllEventListener listener) {
        this.mAllEventListeners.remove(listener);
    }

    void onEvent(Packet<?> packet) {
        Object[] args;
        Object[] objectArray = args = packet.data != null ? SocketIoSocket.unpackEventData((JSONArray)packet.data) : EMPTY_ARGS;
        if (packet.id >= 0) {
            Object[] emitArgs = new Object[args.length + 1];
            System.arraycopy(args, 0, emitArgs, 0, args.length);
            emitArgs[args.length] = args1 -> {
                Packet ackPacket = PacketUtils.createDataPacket(3, null, args1);
                ackPacket.id = packet.id;
                this.sendPacket(ackPacket);
            };
            args = emitArgs;
        }
        String event = args[0].toString();
        Object[] eventArgs = new Object[args.length - 1];
        System.arraycopy(args, 1, eventArgs, 0, eventArgs.length);
        this.emit(event, eventArgs);
        for (AllEventListener listener : this.mAllEventListeners) {
            listener.event(event, eventArgs);
        }
    }

    void onAck(Packet<?> packet) {
        if (this.mAcknowledgementCallbacks.containsKey(packet.id)) {
            ReceivedByRemoteAcknowledgementCallback acknowledgement = this.mAcknowledgementCallbacks.get(packet.id);
            this.mAcknowledgementCallbacks.remove(packet.id);
            Object[] args = packet.data != null ? SocketIoSocket.unpackEventData((JSONArray)packet.data) : EMPTY_ARGS;
            acknowledgement.onReceivedByRemote(args);
        }
    }

    void onPacket(Packet<?> packet) {
        switch (packet.type) {
            case 2: 
            case 5: {
                this.onEvent(packet);
                break;
            }
            case 3: 
            case 6: {
                this.onAck(packet);
                break;
            }
            case 1: {
                this.onDisconnect();
                break;
            }
            case 4: {
                this.onError((String)packet.data);
            }
        }
    }

    void onConnect() {
        this.mNamespace.addConnected(this);
        this.joinRoom(this.getId());
        this.sendPacket(new Packet(0));
    }

    void onDisconnect() {
        this.onClose("client namespace disconnect");
    }

    void onClose(String reason) {
        if (this.mConnected) {
            this.emit("disconnecting", new Object[]{reason});
            this.leaveAllRooms();
            this.mNamespace.remove(this);
            this.mClient.remove(this);
            this.mConnected = false;
            this.mNamespace.removeConnected(this);
            this.emit("disconnect", new Object[]{reason});
        }
    }

    void onError(String error) {
        if (this.listeners("error").size() > 0) {
            this.emit("error", new Object[]{error});
        }
    }

    void sendPacket(Packet<?> packet) {
        packet.nsp = this.mNamespace.getName();
        this.mClient.sendPacket(packet);
    }

    private static Object[] unpackEventData(JSONArray data) {
        Object[] result = new Object[data.length()];
        for (int i = 0; i < result.length; ++i) {
            try {
                result[i] = data.get(i);
                if (result[i] != JSONObject.NULL) continue;
                result[i] = null;
                continue;
            }
            catch (JSONException ex) {
                throw new RuntimeException(ex);
            }
        }
        return result;
    }

    public static interface ReceivedByLocalAcknowledgementCallback {
        public void sendAcknowledgement(Object ... var1);
    }

    public static interface ReceivedByRemoteAcknowledgementCallback {
        public void onReceivedByRemote(Object ... var1);
    }

    public static interface AllEventListener {
        public void event(String var1, Object ... var2);
    }
}

